/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.watcher.api;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.access.ClusterConfiguration;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.service.Fabric8ServiceHub;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.WatchService;
import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.project.MavenProject;

public class WatcherContext {
    private MavenProject project;
    private ProcessorConfig config;
    private Logger logger;
    private Logger newPodLogger;
    private Logger oldPodLogger;
    private RuntimeMode mode;
    private boolean useProjectClasspath;
    private ServiceHub serviceHub;
    private WatchService.WatchContext watchContext;
    private BuildService.BuildContext buildContext;
    private ClusterConfiguration clusterConfiguration;
    private KubernetesClient kubernetesClient;
    private Fabric8ServiceHub fabric8ServiceHub;

    private WatcherContext() {
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RuntimeMode getMode() {
        return this.mode;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public ServiceHub getServiceHub() {
        return this.serviceHub;
    }

    public WatchService.WatchContext getWatchContext() {
        return this.watchContext;
    }

    public BuildService.BuildContext getBuildContext() {
        return this.buildContext;
    }

    public ClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public Logger getNewPodLogger() {
        return this.newPodLogger;
    }

    public Logger getOldPodLogger() {
        return this.oldPodLogger;
    }

    public Fabric8ServiceHub getFabric8ServiceHub() {
        return this.fabric8ServiceHub;
    }

    public static class Builder {
        private WatcherContext ctx = new WatcherContext();

        public Builder project(MavenProject project) {
            this.ctx.project = project;
            return this;
        }

        public Builder config(ProcessorConfig config) {
            this.ctx.config = config;
            return this;
        }

        public Builder logger(Logger logger) {
            this.ctx.logger = logger;
            return this;
        }

        public Builder newPodLogger(Logger newPodLogger) {
            this.ctx.newPodLogger = newPodLogger;
            return this;
        }

        public Builder oldPodLogger(Logger oldPodLogger) {
            this.ctx.oldPodLogger = oldPodLogger;
            return this;
        }

        public Builder mode(RuntimeMode mode) {
            this.ctx.mode = mode;
            return this;
        }

        public Builder useProjectClasspath(boolean useProjectClasspath) {
            this.ctx.useProjectClasspath = useProjectClasspath;
            return this;
        }

        public Builder serviceHub(ServiceHub serviceHub) {
            this.ctx.serviceHub = serviceHub;
            return this;
        }

        public Builder watchContext(WatchService.WatchContext watchContext) {
            this.ctx.watchContext = watchContext;
            return this;
        }

        public Builder buildContext(BuildService.BuildContext buildContext) {
            this.ctx.buildContext = buildContext;
            return this;
        }

        public Builder clusterConfiguration(ClusterConfiguration clusterConfiguration) {
            this.ctx.clusterConfiguration = clusterConfiguration;
            return this;
        }

        public Builder kubernetesClient(KubernetesClient kubernetesClient) {
            this.ctx.kubernetesClient = kubernetesClient;
            return this;
        }

        public Builder fabric8ServiceHub(Fabric8ServiceHub fabric8ServiceHub) {
            this.ctx.fabric8ServiceHub = fabric8ServiceHub;
            return this;
        }

        public WatcherContext build() {
            return this.ctx;
        }
    }
}

