/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractFabric8Mojo
extends AbstractMojo {
    @Parameter(property="fabric8.zip.file", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-app.zip")
    protected File zipFile;
    @Parameter(property="kubernetesJson", defaultValue="${basedir}/target/classes/kubernetes.json")
    private File kubernetesJson;
    @Component
    private MavenProject project;
    @Parameter(property="fabric8.replicas", defaultValue="1")
    private Integer replicas;
    @Parameter(property="fabric8.ignoreProject", defaultValue="false")
    private boolean ignoreProject;

    protected static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    public File getKubernetesJson() {
        return this.kubernetesJson;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public boolean isIgnoreProject() {
        return this.ignoreProject;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    protected boolean isPom(MavenProject reactorProject) {
        return "pom".equals(reactorProject.getPackaging());
    }

    protected InputStream loadPluginResource(String iconRef) throws MojoExecutionException {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(iconRef);
        if (answer == null) {
            answer = this.getTestClassLoader().getResourceAsStream(iconRef);
        }
        return answer;
    }

    protected URLClassLoader getTestClassLoader() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (Object object : this.getProject().getTestClasspathElements()) {
                if (object == null) continue;
                String path = object.toString();
                File file = new File(path);
                URL url = file.toURI().toURL();
                urls.add(url);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
        return AbstractFabric8Mojo.createURLClassLoader(urls);
    }
}

