/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.kubernetes.template.GenerateTemplateDTO;
import io.fabric8.kubernetes.template.TemplateGenerator;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.utils.Files;
import io.fabric8.utils.Function;
import io.fabric8.utils.Lists;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="json", defaultPhase=LifecyclePhase.COMPILE)
public class JsonMojo
extends AbstractFabric8Mojo {
    public static final String FABRIC8_PORT_HOST_PREFIX = "docker.port.host.";
    public static final String FABRIC8_PORT_CONTAINER_PREFIX = "docker.port.container.";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.kubernetes.artifactType", defaultValue="json")
    private String artifactType = "json";
    @Parameter(property="fabric8.kubernetes.artifactClassifier", defaultValue="kubernetes")
    private String artifactClassifier = "kubernetes";
    @Parameter(property="fabric8.json.template", defaultValue="io/fabric8/templates/default.mvel")
    private String jsonTemplate;
    @Parameter(property="fabric8.generateJson", defaultValue="true")
    private boolean generateJson;
    @Parameter(property="fabric8.kubernetes.name")
    private String kubernetesName;
    @Parameter(property="fabric8.container.name")
    private String kubernetesContainerName;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private List<EnvVar> environmentVariables;
    @Parameter
    private List<Port> ports;
    @Parameter
    private Map<String, Integer> defaultContainerPortMap;
    @Parameter(property="fabric8.replicas", defaultValue="1")
    private Integer replicaCount;
    @Parameter(property="kubernetesExtraJson", defaultValue="${basedir}/target/classes/kubernetes-extra.json")
    private File kubernetesExtraJson;
    @Parameter(property="fabric8.service.name", defaultValue="${project.artifactId}")
    private String serviceName;
    @Parameter(property="fabric8.service.port")
    private Integer servicePort;
    @Parameter(property="fabric8.service.containerPort")
    private Integer serviceContainerPort;
    @Parameter(property="fabric8.imagePullPolicy")
    private String imagePullPolicy;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File json = this.getKubernetesJson();
        this.getLog().info((CharSequence)("Configured with file: " + json));
        if (json == null) {
            throw new MojoExecutionException("No kubernetes json file is specified!");
        }
        if (this.shouldGenerateForThisProject() && !this.isIgnoreProject() && this.generateJson) {
            this.generateKubernetesJson(json);
            if (this.kubernetesExtraJson != null && this.kubernetesExtraJson.exists()) {
                this.combineJsonFiles(json, this.kubernetesExtraJson);
            }
        }
        if (Files.isFile((File)json)) {
            this.getLog().info((CharSequence)("Attaching kubernetes json file: " + json + " to the build"));
            this.projectHelper.attachArtifact(this.getProject(), this.artifactType, this.artifactClassifier, json);
        }
    }

    protected void combineJsonFiles(File json, File kubernetesExtraJson) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Combining generated json " + json + " with extra json " + kubernetesExtraJson));
        Object extra = JsonMojo.loadJsonFile(kubernetesExtraJson);
        Object generated = JsonMojo.loadJsonFile(json);
        try {
            JsonNode comnbined = KubernetesHelper.combineJson((Object[])new Object[]{generated, extra});
            KubernetesHelper.saveJson((File)json, (Object)comnbined);
            this.getLog().info((CharSequence)("Saved as :" + json.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save combined JSON files " + json + " and " + kubernetesExtraJson + " as " + json + ". " + e, (Exception)e);
        }
    }

    protected static Object loadJsonFile(File file) throws MojoExecutionException {
        try {
            return KubernetesHelper.loadJson((File)file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse JSON " + file + ". " + e, (Exception)e);
        }
    }

    protected void generateKubernetesJson(File kubernetesJson) throws MojoExecutionException {
        if (Strings.isNullOrBlank((String)this.jsonTemplate)) {
            throw new MojoExecutionException("No fabric8.jsonTemplate specified so cannot generate the Kubernetes JSON file!");
        }
        GenerateTemplateDTO config = new GenerateTemplateDTO();
        config.setTemplate(this.jsonTemplate);
        MavenProject project = this.getProject();
        Properties properties = project.getProperties();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) continue;
            String keyText = key.toString();
            keyText = keyText.replace('.', '_');
            variables.put(keyText, value);
        }
        Map<String, String> labelMap = this.getLabels();
        String name = this.getKubernetesName();
        if (labelMap.isEmpty() && Strings.isNotBlank((String)name)) {
            labelMap.put("component", name);
        }
        config.setLabels(labelMap);
        config.setTemplateVariables(variables);
        config.setPorts(this.getPorts());
        config.setName(name);
        config.setContainerName(this.getKubernetesContainerName());
        config.setReplicaCount(this.replicaCount);
        config.setEnvironmentVariables(this.getEnvironmentVariables());
        config.setServiceName(this.serviceName);
        config.setServicePort(this.servicePort);
        config.setServiceContainerPort(this.serviceContainerPort);
        String pullPolicy = this.getImagePullPolicy();
        config.setImagePullPolicy(pullPolicy);
        List classLoaders = Lists.newArrayList((Object[])new ClassLoader[]{Thread.currentThread().getContextClassLoader(), this.getTestClassLoader(), ((Object)((Object)this)).getClass().getClassLoader(), TemplateGenerator.class.getClassLoader()});
        TemplateGenerator generator = new TemplateGenerator(config, classLoaders);
        generator.generate(kubernetesJson);
    }

    public String getImagePullPolicy() {
        MavenProject project = this.getProject();
        String pullPolicy = this.imagePullPolicy;
        if (project != null) {
            String version = project.getVersion();
            if (Strings.isNullOrBlank((String)pullPolicy) && version != null && version.endsWith("SNAPSHOT")) {
                pullPolicy = "PullAlways";
            }
        }
        return pullPolicy;
    }

    public String getKubernetesContainerName() {
        if (Strings.isNullOrBlank((String)this.kubernetesContainerName)) {
            String[] paths;
            String groupPrefix = null;
            MavenProject project = this.getProject();
            String imageName = project.getProperties().getProperty("docker.image");
            if (Strings.isNotBlank((String)imageName) && (paths = imageName.split("/")) != null) {
                if (paths.length == 2) {
                    groupPrefix = paths[0];
                } else if (paths.length == 3) {
                    groupPrefix = paths[1];
                }
            }
            if (Strings.isNullOrBlank(groupPrefix)) {
                groupPrefix = project.getGroupId();
            }
            this.kubernetesContainerName = groupPrefix + "-" + project.getArtifactId();
        }
        return this.kubernetesContainerName;
    }

    public void setKubernetesContainerName(String kubernetesContainerName) {
        this.kubernetesContainerName = kubernetesContainerName;
    }

    public String getKubernetesName() {
        if (Strings.isNullOrBlank((String)this.kubernetesName)) {
            this.kubernetesName = Strings.convertToCamelCase((String)this.getKubernetesContainerName(), (String)"-");
        }
        return this.kubernetesName;
    }

    public void setKubernetesName(String kubernetesName) {
        this.kubernetesName = kubernetesName;
    }

    public Map<String, Integer> getDefaultContainerPortMap() {
        if (this.defaultContainerPortMap == null) {
            this.defaultContainerPortMap = new HashMap<String, Integer>();
        }
        if (this.defaultContainerPortMap.isEmpty()) {
            this.defaultContainerPortMap.put("jolokia", 8778);
            this.defaultContainerPortMap.put("web", 8080);
        }
        return this.defaultContainerPortMap;
    }

    public void setDefaultContainerPortMap(Map<String, Integer> defaultContainerPortMap) {
        this.defaultContainerPortMap = defaultContainerPortMap;
    }

    public List<Port> getPorts() {
        if (this.ports == null) {
            this.ports = new ArrayList<Port>();
        }
        if (this.ports.isEmpty()) {
            Port port;
            Integer portNumber;
            String portText;
            String name;
            HashMap<String, Port> portMap = new HashMap<String, Port>();
            Properties properties1 = this.getProject().getProperties();
            Map hostPorts = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)FABRIC8_PORT_HOST_PREFIX);
            Properties properties = this.getProject().getProperties();
            Map containerPorts = PropertiesHelper.findPropertiesWithPrefix((Properties)properties, (String)FABRIC8_PORT_CONTAINER_PREFIX);
            for (Map.Entry entry : containerPorts.entrySet()) {
                name = (String)entry.getKey();
                portText = (String)entry.getValue();
                portNumber = this.parsePort(portText, FABRIC8_PORT_CONTAINER_PREFIX + name);
                if (portNumber == null) continue;
                port = JsonMojo.getOrCreatePort(portMap, name);
                port.setContainerPort(portNumber);
            }
            for (Map.Entry entry : hostPorts.entrySet()) {
                name = (String)entry.getKey();
                portText = (String)entry.getValue();
                portNumber = this.parsePort(portText, FABRIC8_PORT_HOST_PREFIX + name);
                if (portNumber == null) continue;
                port = JsonMojo.getOrCreatePort(portMap, name);
                port.setHostPort(portNumber);
                if (port.getContainerPort() != null) continue;
                port.setContainerPort(this.getDefaultContainerPortMap().get(name));
            }
            this.getLog().info((CharSequence)("Generated port mappings: " + portMap));
            this.getLog().debug((CharSequence)("from host ports: " + hostPorts));
            this.getLog().debug((CharSequence)("from containerPorts ports: " + containerPorts));
            this.ports.addAll(portMap.values());
        }
        return this.ports;
    }

    protected static Port getOrCreatePort(Map<String, Port> portMap, String name) {
        Port answer = portMap.get(name);
        if (answer == null) {
            answer = new Port();
            portMap.put(name, answer);
        }
        return answer;
    }

    protected static EnvVar getOrCreateEnv(Map<String, EnvVar> envMap, String name) {
        EnvVar answer = envMap.get(name);
        if (answer == null) {
            answer = new EnvVar();
            envMap.put(name, answer);
        }
        return answer;
    }

    protected Integer parsePort(String portText, String propertyName) {
        if (Strings.isNotBlank((String)portText)) {
            try {
                return Integer.parseInt(portText);
            }
            catch (NumberFormatException e) {
                this.getLog().warn((CharSequence)("Failed to parse port text: " + portText + " from maven property " + propertyName + ". " + e), (Throwable)e);
            }
        }
        return null;
    }

    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        if (this.labels.isEmpty()) {
            this.labels = PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProject().getProperties(), (String)"fabric8.label.", (Function)Strings.toLowerCaseFunction());
        }
        return this.labels;
    }

    public List<EnvVar> getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = new ArrayList<EnvVar>();
        }
        if (this.environmentVariables.isEmpty()) {
            HashMap<String, EnvVar> envMap = new HashMap<String, EnvVar>();
            Map envs = PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProject().getProperties(), (String)"fabric8.env.", (Function)Strings.toEnvironmentVariableFunction());
            for (Map.Entry entry : envs.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (name == null) continue;
                EnvVar env = JsonMojo.getOrCreateEnv(envMap, name);
                env.setName(name);
                if (env.getValue() != null) continue;
                env.setValue(value);
            }
            this.getLog().info((CharSequence)("Generated env mappings: " + envMap));
            this.getLog().debug((CharSequence)("from envs: " + envs));
            this.environmentVariables.addAll(envMap.values());
        }
        return this.environmentVariables;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    protected static void addIfNotDefined(Map<String, Object> variables, String key, String value) {
        if (!variables.containsKey(key)) {
            variables.put(key, value);
        }
    }
}

