/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemaProperty;
import io.fabric8.utils.TablePrinter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="env", defaultPhase=LifecyclePhase.COMPILE)
public class EnvironmentMojo
extends AbstractFabric8Mojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            JsonSchema schema = this.getEnvironmentVariableJsonSchema();
            this.displaySchema(schema);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, (Exception)e);
        }
    }

    protected void displaySchema(JsonSchema schema) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"Name", "Default", "Type", "Description"});
        Map<String, JsonSchemaProperty> properties = schema.getProperties();
        TreeMap<String, JsonSchemaProperty> sortedProperties = new TreeMap<String, JsonSchemaProperty>();
        if (properties != null) {
            sortedProperties.putAll(properties);
        }
        Set entries = sortedProperties.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            JsonSchemaProperty property = (JsonSchemaProperty)entry.getValue();
            table.row(new String[]{name, property.getDefaultValue(), property.getType(), property.getDescription()});
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Environment variables which can be injected:");
        this.getLog().info((CharSequence)"--------------------------------------------");
        List lines = table.asTextLines();
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }
}

