/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Config;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.utils.Files;
import io.fabric8.utils.TablePrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-env", defaultPhase=LifecyclePhase.COMPILE)
public class CreateEnvMojo
extends AbstractFabric8Mojo {
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";
    private static final String DOCKE_ENV_PREFIX = "docker.env.";
    private static final String DOCKE_NAME = "docker.name";
    private final KubernetesClient kubernetes = new KubernetesClient();
    @Parameter(property="fabric8.namespace", defaultValue="default")
    private String namespace;
    @Parameter(property="fabric8.envFile", defaultValue="env.properties")
    private String envFileName;
    @Parameter(property="docker.image")
    private String name;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String basedir = System.getProperty("basedir", ".");
            File propertiesFile = new File(basedir + "/target/" + this.envFileName).getCanonicalFile();
            Config config = (Config)this.loadKubernetesJson();
            Map<String, String> env = this.getEnvFromConfig(config);
            env.putAll(this.getNamespaceServiceEnv(this.namespace));
            this.displayEnv(env);
            for (Map.Entry<String, String> entry : env.entrySet()) {
                this.getProject().getProperties().setProperty(DOCKE_ENV_PREFIX + entry.getKey(), entry.getValue());
            }
            this.getProject().getProperties().setProperty(DOCKE_NAME, this.name);
            Properties envProperties = new Properties();
            envProperties.putAll(env);
            CreateEnvMojo.saveProperties(envProperties, propertiesFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, (Exception)e);
        }
    }

    private Map<String, String> getNamespaceServiceEnv(String namespace) {
        HashMap<String, String> result = new HashMap<String, String>();
        ServiceList serviceList = this.kubernetes.getServices(namespace);
        for (Service service : serviceList.getItems()) {
            String id = service.getId().toUpperCase().replace("-", "_");
            result.put(id + HOST_SUFFIX, service.getPortalIP());
            result.put(id + PORT_SUFFIX, String.valueOf(service.getPort()));
            result.put(id + PROTO_SUFFIX, service.getProtocol());
            result.put(id + PORT_SUFFIX + "_" + service.getPort() + PROTO_SUFFIX, service.getProtocol());
        }
        return result;
    }

    private Map<String, String> getEnvFromConfig(Config config) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object entity : KubernetesHelper.getEntities((Config)config)) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                for (Container container : pod.getDesiredState().getManifest().getContainers()) {
                    if (!container.getImage().equals(this.name)) continue;
                    result.putAll(CreateEnvMojo.mapFromEnv(container.getEnv()));
                }
                continue;
            }
            if (!(entity instanceof ReplicationController)) continue;
            ReplicationController replicationController = (ReplicationController)entity;
            for (Container container : replicationController.getDesiredState().getPodTemplate().getDesiredState().getManifest().getContainers()) {
                if (!container.getImage().equals(this.name)) continue;
                result.putAll(CreateEnvMojo.mapFromEnv(container.getEnv()));
            }
        }
        return result;
    }

    private void displayEnv(Map<String, String> map) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"Name", "Value"});
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            table.row(new String[]{name, value});
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Generated Environment variables:");
        this.getLog().info((CharSequence)"-------------------------------");
        List lines = table.asTextLines();
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }

    private Object loadKubernetesJson() throws MojoFailureException, IOException {
        File json = this.getKubernetesJson();
        if (!Files.isFile((File)json)) {
            if (Files.isFile((File)this.kubernetesSourceJson)) {
                json = this.kubernetesSourceJson;
            } else {
                throw new MojoFailureException("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson);
            }
        }
        return KubernetesHelper.loadJson((File)json);
    }

    private static Map<String, String> mapFromEnv(List<EnvVar> envVars) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (EnvVar envVar : envVars) {
            result.put(envVar.getName(), envVar.getValue());
        }
        return result;
    }

    private static void saveProperties(Properties properties, File propertiesFile) throws IOException {
        try (FileWriter writer = new FileWriter(propertiesFile);){
            properties.store(writer, "Generated Environment Variables");
        }
    }
}

