/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.base.ObjectReference;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.template.Parameter;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="apply", defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractFabric8Mojo {
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.namespace")
    private String namespace;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.create", defaultValue="true")
    private boolean createNewResources;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.recreate")
    private boolean recreate;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.failOnError", defaultValue="true")
    private boolean failOnError;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.createRoutes", defaultValue="true")
    private boolean createRoutes;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.apply.domain", defaultValue="${env.KUBERNETES_DOMAIN}")
    private String routeDomain;
    private KubernetesClient kubernetes = new KubernetesClient();

    public void execute() throws MojoExecutionException, MojoFailureException {
        File json = this.getKubernetesJson();
        if (!Files.isFile((File)json)) {
            if (Files.isFile((File)this.kubernetesSourceJson)) {
                json = this.kubernetesSourceJson;
            } else {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson);
                }
                this.getLog().warn((CharSequence)("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson + " for this project so ignoring"));
                return;
            }
        }
        KubernetesClient kubernetes = this.getKubernetes();
        this.getLog().info((CharSequence)("Using kubernetes at: " + kubernetes.getAddress() + " in namespace " + kubernetes.getNamespace()));
        this.getLog().info((CharSequence)("Kubernetes JSON: " + json));
        try {
            String fileName = json.getName();
            Object dto = KubernetesHelper.loadJson((File)json);
            if (dto == null) {
                throw new MojoFailureException("Could not load kubernetes json: " + json);
            }
            Controller controller = new Controller(this.kubernetes);
            controller.setAllowCreate(this.createNewResources);
            controller.setRecreateMode(this.recreate);
            controller.setThrowExceptionOnError(this.failOnError);
            controller.setServicesOnlyMode(this.servicesOnly);
            controller.setIgnoreServiceMode(this.ignoreServices);
            controller.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            if (dto instanceof Template) {
                Template template = (Template)dto;
                KubernetesHelper.setNamespace((Template)template, (String)kubernetes.getNamespace());
                this.overrideTemplateParameters(template);
                dto = controller.processTemplate(template, fileName);
            }
            List list = KubernetesHelper.toItemList((Object)dto);
            if (this.createRoutes) {
                this.createRoutes(kubernetes, list);
                dto = list;
            }
            controller.apply(dto, fileName);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void overrideTemplateParameters(Template template) {
        List parameters = template.getParameters();
        MavenProject project = this.getProject();
        if (parameters != null && project != null) {
            Properties properties = project.getProperties();
            properties.putAll((Map<?, ?>)project.getProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            boolean missingProperty = false;
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                String name = "fabric8.apply." + parameterName;
                String propertyValue = properties.getProperty(name);
                if (Strings.isNotBlank((String)propertyValue)) {
                    this.getLog().info((CharSequence)("Overriding template parameter " + name + " with value: " + propertyValue));
                    parameter.setValue(propertyValue);
                    continue;
                }
                missingProperty = true;
                this.getLog().info((CharSequence)("No property defined for template parameter: " + name));
            }
            if (missingProperty) {
                this.getLog().debug((CharSequence)("current properties " + new TreeSet<Object>(properties.keySet())));
            }
        }
    }

    protected void createRoutes(KubernetesClient kubernetes, List<Object> list) {
        Object routes;
        if (Strings.isNullOrBlank((String)this.routeDomain)) {
            this.getLog().warn((CharSequence)"No fabric8.apply.routeDomain property or $KUBERNETES_DOMAIN environment variable so cannot create any OpenShift Routes");
            return;
        }
        String namespace = kubernetes.getNamespace();
        try {
            routes = kubernetes.getRoutes(namespace);
            if (routes != null) {
                List items = routes.getItems();
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Could not load routes; we maybe are not connected to an OpenShift environment? " + e), (Throwable)e);
            return;
        }
        routes = new ArrayList();
        for (Object object : list) {
            Service service;
            String id;
            if (!(object instanceof Service) || !Strings.isNotBlank((String)(id = KubernetesHelper.getName((Service)(service = (Service)object))))) continue;
            Route route = new Route();
            KubernetesHelper.setName((Route)route, (String)namespace, (String)(id + "-route"));
            RouteSpec routeSpec = new RouteSpec();
            ObjectReference objectRef = new ObjectReference();
            objectRef.setName(id);
            objectRef.setNamespace(namespace);
            routeSpec.setTo(objectRef);
            String host = Strings.stripSuffix((String)Strings.stripSuffix((String)id, (String)"-service"), (String)".");
            routeSpec.setHost(host + "." + Strings.stripPrefix((String)this.routeDomain, (String)"."));
            route.setSpec(routeSpec);
            String json = null;
            try {
                json = KubernetesHelper.toJson((Object)route);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + route;
            }
            this.getLog().debug((CharSequence)("Created route: " + json));
            routes.add(route);
        }
        list.addAll((Collection<Object>)routes);
    }

    public KubernetesClient getKubernetes() {
        if (Strings.isNotBlank((String)this.namespace)) {
            this.kubernetes.setNamespace(this.namespace);
        }
        return this.kubernetes;
    }
}

