/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-build-config", requiresProject=false)
public class CreateBuildConfigMojo
extends AbstractNamespacedMojo {
    @Parameter(property="fabric8.username")
    protected String username;
    @Parameter(property="fabric8.repoName")
    protected String repoName;
    @Parameter(property="fabric8.fullName")
    protected String fullName;
    @Parameter(property="fabric8.gitUrl")
    protected String gitUrl;
    @Parameter(property="fabric8.webhookSecret", defaultValue="secret101")
    protected String secret;
    @Parameter(property="fabric8.buildImageStream", defaultValue="triggerJenkins")
    protected String buildImageStream;
    @Parameter(property="fabric8.buildImageTag", defaultValue="latest")
    protected String buildImageTag;
    @Parameter(property="fabric8.jenkinsJob")
    protected String jenkinsJob;
    @Parameter(property="fabric8.jenkinsMonitorView")
    protected String jenkinsMonitorView;
    @Parameter(property="fabric8.jenkinsPipelineView")
    protected String jenkinsPipelineView;

    public void execute() throws MojoExecutionException, MojoFailureException {
        KubernetesClient kubernetes = this.getKubernetes();
        String name = this.repoName;
        if (Strings.isNotBlank((String)this.username)) {
            name = this.username + "-" + name;
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("user", this.username);
        labels.put("repo", this.repoName);
        HashMap<String, String> annotations = new HashMap<String, String>();
        try {
            String jenkinsUrl = kubernetes.getServiceURL("jenkins", kubernetes.getNamespace(), "http", true);
            if (Strings.isNotBlank((String)jenkinsUrl)) {
                if (Strings.isNotBlank((String)this.jenkinsMonitorView)) {
                    annotations.put("fabric8.link.jenkins.monitor/url", URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsMonitorView}));
                    annotations.put("fabric8.link.jenkins.monitor/label", "Monitor");
                }
                if (Strings.isNotBlank((String)this.jenkinsPipelineView)) {
                    annotations.put("fabric8.link.jenkins.pipeline/url", URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsPipelineView}));
                    annotations.put("fabric8.link.jenkins.pipeline/label", "Pipeline");
                }
                if (Strings.isNotBlank((String)this.jenkinsJob)) {
                    annotations.put("fabric8.link.jenkins.job/url", URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/job", this.jenkinsJob}));
                    annotations.put("fabric8.link.jenkins.job/label", "Job");
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Could not find the Jenkins URL!: " + e), (Throwable)e);
        }
        BuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GenericNested)((BuildConfigSpecFluent.TriggersNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GithubNested)((BuildConfigSpecFluent.TriggersNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildSourceFluent.GitNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(name)).withLabels(labels)).withAnnotations(annotations)).endMetadata()).withNewSpec().withNewSource().withType("Git")).withNewGit().withUri(this.gitUrl)).endGit()).endSource()).withNewStrategy().withType("Docker")).withNewDockerStrategy().withNewFrom().withName(this.buildImageStream + ":" + this.buildImageTag)).endFrom()).endDockerStrategy()).endStrategy()).addNewTrigger().withType("github")).withNewGithub().withSecret(this.secret)).endGithub()).endTrigger()).addNewTrigger().withType("generic")).withNewGeneric().withSecret(this.secret)).endGeneric()).endTrigger()).endSpec()).build();
        Controller controller = this.createController();
        controller.applyBuildConfig(buildConfig, "maven");
        this.getLog().info((CharSequence)("Created build configuration for " + name + " in namespace: " + controller.getNamespace() + " at " + kubernetes.getAddress()));
    }
}

