/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.maven.ApplyMojo;
import io.fabric8.openshift.api.model.Route;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="create-routes", requiresProject=false)
public class CreateRoutesMojo
extends AbstractNamespacedMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List items;
            KubernetesClient kubernetes = this.getKubernetes();
            Controller controller = this.createController();
            String namespace = kubernetes.getNamespace();
            Log log = this.getLog();
            ServiceList services = kubernetes.getServices(namespace);
            if (services != null && (items = services.getItems()) != null) {
                String routeDomainPostfix = this.routeDomain;
                for (Service service : items) {
                    Route route = ApplyMojo.createRouteForService(routeDomainPostfix, namespace, service, log);
                    if (route == null) continue;
                    controller.applyRoute(route, "Service " + KubernetesHelper.getName((Service)service));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, e);
        }
    }
}

