/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.Zips;
import io.fabric8.utils.Files;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="zip", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ZipMojo
extends AbstractFabric8Mojo {
    @Parameter(property="fabric8.zip.buildDir", defaultValue="${project.build.directory}/generated-app")
    private File buildDir;
    @Parameter(property="fabric8.zip.includeLegal", defaultValue="true")
    private boolean includeLegal;
    @Parameter(property="fabric8.aggregated.zip.outFile", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-app.zip")
    private File aggregatedZipOutputFile;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.distributionManagementArtifactRepository}", readonly=true, required=false)
    private ArtifactRepository deploymentRepository;
    @Parameter(property="fabric8.zip.artifactType", defaultValue="zip")
    private String artifactType = "zip";
    @Parameter(property="fabric8.zip.artifactClassifier", defaultValue="app")
    private String artifactClassifier = "app";
    @Parameter(defaultValue="${reactorProjects}")
    private List<MavenProject> reactorProjects;
    @Parameter(property="fabric8.fullzip.reactorProjectOutputPath", defaultValue="target/generated-app")
    private String reactorProjectOutputPath;
    @Parameter(property="fabric8.includeReadMe", defaultValue="true")
    protected boolean includeReadMe;
    @Parameter(property="fabric8.replaceReadmeLinksPrefix")
    protected String replaceReadmeLinksPrefix;
    @Parameter(property="fabric8.generateSummaryFile", defaultValue="true")
    protected boolean generateSummaryFile;
    @Parameter(property="fabric8.generateAppPropertiesFile", defaultValue="true")
    protected boolean generateAppPropertiesFile;
    @Parameter(property="fabric8.pathInZip", defaultValue="${project.artifactId}")
    protected String pathInZip;
    @Parameter(property="fabric8.deployFileGoal", defaultValue="gpg:sign-and-deploy-file")
    protected String deployFileGoal;
    @Parameter(property="fabric8.deployFileUrl")
    protected String deployFileUrl;
    @Parameter(property="fabric8.ignoreProject", defaultValue="false")
    private boolean ignoreProject;
    protected MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.isIgnoreProject()) {
                return;
            }
            if (this.shouldGenerateForThisProject()) {
                this.generateZip();
            }
            boolean isLastProject = this.getProject() == this.reactorProjects.get(this.reactorProjects.size() - 1);
            this.getLog().debug((CharSequence)("Is last project? " + isLastProject + " -> " + this.getProject().getArtifactId()));
            if (isLastProject) {
                this.getLog().info((CharSequence)"Last project done. Now generating aggregated zips for the entire project(s).");
                this.generateAggregatedZips();
            }
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing", e);
        }
    }

    protected void generateZip() throws DependencyTreeBuilderException, MojoExecutionException, IOException, MojoFailureException {
        File appBuildDir = this.buildDir;
        if (Strings.isNotBlank((String)this.pathInZip)) {
            appBuildDir = new File(this.buildDir, this.pathInZip);
        }
        appBuildDir.mkdirs();
        if (this.hasConfigDir()) {
            this.copyAppConfigFiles(appBuildDir, this.appConfigDir);
        } else {
            this.getLog().info((CharSequence)("The app configuration files directory " + this.appConfigDir + " doesn't exist, so not copying any additional project documentation or configuration files"));
        }
        MavenProject project = this.getProject();
        if (!this.ignoreProject) {
            File kubernetesJson = this.getKubernetesJson();
            if (kubernetesJson != null && kubernetesJson.isFile() && kubernetesJson.exists()) {
                File jsonFile = new File(appBuildDir, "kubernetes.json");
                jsonFile.getParentFile().mkdirs();
                Files.copy((File)kubernetesJson, (File)jsonFile);
            }
            this.copyIconToFolder(appBuildDir);
        }
        if (this.hasConfigDir() || !this.ignoreProject) {
            if (this.includeReadMe) {
                this.copyReadMe(appBuildDir);
            }
            if (this.generateSummaryFile) {
                this.copySummaryText(appBuildDir);
            }
            if (this.generateAppPropertiesFile) {
                String name = project.getName();
                if (Strings.isNullOrBlank((String)name)) {
                    name = project.getArtifactId();
                }
                String description = project.getDescription();
                Properties appProperties = new Properties();
                appProperties.put("name", name);
                if (Strings.isNotBlank((String)description)) {
                    appProperties.put("description", description);
                }
                appProperties.put("groupId", project.getGroupId());
                appProperties.put("artifactId", project.getArtifactId());
                appProperties.put("version", project.getVersion());
                File appPropertiesFile = new File(appBuildDir, "fabric8.properties");
                appPropertiesFile.getParentFile().mkdirs();
                if (!appPropertiesFile.exists()) {
                    appProperties.store(new FileWriter(appPropertiesFile), "Fabric8 Properties");
                }
            }
            File outputZipFile = this.getZipFile();
            File legalDir = null;
            if (this.includeLegal) {
                legalDir = new File(project.getBuild().getOutputDirectory(), "META-INF");
            }
            Zips.createZipFile(this.getLog(), this.buildDir, outputZipFile, legalDir);
            this.projectHelper.attachArtifact(project, this.artifactType, this.artifactClassifier, outputZipFile);
            this.getLog().info((CharSequence)("Created app zip file: " + outputZipFile));
        }
    }

    protected void generateAggregatedZips() throws IOException, MojoExecutionException {
        List<MavenProject> zipGoalProjects = this.fabricZipGoalProjects();
        Collections.reverse(zipGoalProjects);
        HashSet<MavenProject> doneParents = new HashSet<MavenProject>();
        for (MavenProject zipProject : zipGoalProjects) {
            Set<MavenProject> group;
            MavenProject parent = zipProject.getParent();
            if (parent == null || (group = this.sameParent(parent, zipGoalProjects)).size() < 2 || doneParents.contains(parent)) continue;
            doneParents.add(parent);
            Set<MavenProject> nested = this.sameParentTransitive(parent, zipGoalProjects);
            if (!nested.isEmpty()) {
                group.addAll(nested);
            }
            this.generateAggregatedZip(parent, this.reactorProjects, group);
        }
    }

    private Set<MavenProject> sameParent(MavenProject parent, List<MavenProject> projects) {
        LinkedHashSet<MavenProject> answer = new LinkedHashSet<MavenProject>();
        for (MavenProject zip : projects) {
            if (!Objects.equal((Object)parent, (Object)zip.getParent())) continue;
            answer.add(zip);
        }
        return answer;
    }

    private Set<MavenProject> sameParentTransitive(MavenProject parent, List<MavenProject> projects) {
        LinkedHashSet<MavenProject> answer = new LinkedHashSet<MavenProject>();
        for (MavenProject zip : projects) {
            if (!ZipMojo.hasAncestor(parent, zip)) continue;
            answer.add(zip);
        }
        return answer;
    }

    private List<MavenProject> fabricZipGoalProjects() {
        ArrayList<MavenProject> answer = new ArrayList<MavenProject>();
        if (this.reactorProjects != null) {
            ArrayList<MavenProject> pomZipProjects = new ArrayList<MavenProject>();
            for (MavenProject reactorProject : this.reactorProjects) {
                if (this.isPom(reactorProject)) {
                    pomZipProjects.add(reactorProject);
                }
                List buildPlugins = reactorProject.getBuildPlugins();
                for (Plugin buildPlugin : buildPlugins) {
                    String artifactId = buildPlugin.getArtifactId();
                    if (!"fabric8-maven-plugin".equals(artifactId)) continue;
                    Object goals = buildPlugin.getGoals();
                    boolean hasZipGoal = goals != null && goals.toString().contains("zip");
                    List executions = buildPlugin.getExecutions();
                    for (PluginExecution execution : executions) {
                        List execGoals = execution.getGoals();
                        if (!execGoals.contains("zip")) continue;
                        hasZipGoal = true;
                    }
                    this.getLog().debug((CharSequence)("Project " + reactorProject.getArtifactId() + " has zip goal: " + hasZipGoal));
                    if (!hasZipGoal) continue;
                    answer.add(reactorProject);
                }
            }
        }
        return answer;
    }

    protected void generateAggregatedZip(MavenProject rootProject, List<MavenProject> reactorProjects, Set<MavenProject> pomZipProjects) throws IOException, MojoExecutionException {
        Properties props;
        DefaultInvocationRequest request;
        File projectBaseDir = rootProject.getBasedir();
        String rootProjectGroupId = rootProject.getGroupId();
        String rootProjectArtifactId = rootProject.getArtifactId();
        String rootProjectVersion = rootProject.getVersion();
        String aggregatedZipFileName = "target/" + rootProjectArtifactId + "-" + rootProjectVersion + "-app.zip";
        File projectOutputFile = new File(projectBaseDir, aggregatedZipFileName);
        this.getLog().info((CharSequence)("Generating " + projectOutputFile.getAbsolutePath() + " from root project " + rootProjectArtifactId));
        File projectBuildDir = new File(projectBaseDir, this.reactorProjectOutputPath);
        if (projectOutputFile.exists()) {
            projectOutputFile.delete();
        }
        this.createAggregatedZip(projectBaseDir, projectBuildDir, this.reactorProjectOutputPath, projectOutputFile, this.includeReadMe, pomZipProjects);
        if (rootProject.getAttachedArtifacts() != null) {
            Artifact found = null;
            for (Artifact artifact : rootProject.getAttachedArtifacts()) {
                if (this.artifactClassifier == null || !artifact.hasClassifier() || !artifact.getClassifier().equals(this.artifactClassifier)) continue;
                found = artifact;
                break;
            }
            if (found != null) {
                rootProject.getAttachedArtifacts().remove(found);
            }
        }
        this.getLog().info((CharSequence)("Attaching aggregated zip " + projectOutputFile + " to root project " + rootProject.getArtifactId()));
        this.projectHelper.attachArtifact(rootProject, this.artifactType, this.artifactClassifier, projectOutputFile);
        ArrayList<String> activeProfileIds = new ArrayList<String>();
        List activeProfiles = rootProject.getActiveProfiles();
        if (activeProfiles != null) {
            for (Profile profile : activeProfiles) {
                String id = profile.getId();
                if (!Strings.isNotBlank((String)id)) continue;
                activeProfileIds.add(id);
            }
        }
        if (rootProject.hasLifecyclePhase("install")) {
            this.getLog().info((CharSequence)("Installing aggregated zip " + projectOutputFile));
            request = new DefaultInvocationRequest();
            request.setBaseDirectory(rootProject.getBasedir());
            request.setPomFile(new File("./pom.xml"));
            request.setGoals(Collections.singletonList("install:install-file"));
            request.setRecursive(false);
            request.setInteractive(false);
            request.setProfiles(activeProfileIds);
            props = new Properties();
            props.setProperty("file", aggregatedZipFileName);
            props.setProperty("groupId", rootProjectGroupId);
            props.setProperty("artifactId", rootProjectArtifactId);
            props.setProperty("version", rootProjectVersion);
            props.setProperty("classifier", "app");
            props.setProperty("packaging", "zip");
            props.setProperty("generatePom", "false");
            request.setProperties(props);
            this.getLog().info((CharSequence)("Installing aggregated zip using: mvn install:install-file" + this.serializeMvnProperties(props)));
            DefaultInvoker invoker = new DefaultInvoker();
            try {
                InvocationResult result = invoker.execute((InvocationRequest)request);
                if (result.getExitCode() != 0) {
                    throw new IllegalStateException("Error invoking Maven goal install:install-file");
                }
            }
            catch (MavenInvocationException e) {
                throw new MojoExecutionException("Error invoking Maven goal install:install-file", (Exception)((Object)e));
            }
        }
        if (rootProject.hasLifecyclePhase("deploy")) {
            if (this.deploymentRepository == null) {
                String msg = "Cannot run deploy phase as Maven project has no <distributionManagement> with the maven url to use for deploying the aggregated zip file";
                this.getLog().warn((CharSequence)msg);
                throw new MojoExecutionException(msg);
            }
            this.getLog().info((CharSequence)("Deploying aggregated zip " + projectOutputFile + " to root project " + rootProject.getArtifactId()));
            this.getLog().info((CharSequence)("Using deploy goal: " + this.deployFileGoal + " with active profiles: " + activeProfileIds));
            request = new DefaultInvocationRequest();
            request.setBaseDirectory(rootProject.getBasedir());
            request.setPomFile(new File("./pom.xml"));
            request.setGoals(Collections.singletonList(this.deployFileGoal));
            request.setRecursive(false);
            request.setInteractive(false);
            request.setProfiles(activeProfileIds);
            props = new Properties();
            props.setProperty("file", aggregatedZipFileName);
            props.setProperty("groupId", rootProjectGroupId);
            props.setProperty("artifactId", rootProjectArtifactId);
            props.setProperty("version", rootProjectVersion);
            props.setProperty("classifier", "app");
            props.setProperty("packaging", "zip");
            String deployUrl = this.deployFileUrl;
            if (Strings.isNullOrBlank((String)deployUrl)) {
                deployUrl = this.deploymentRepository.getUrl();
            }
            props.setProperty("url", deployUrl);
            props.setProperty("repositoryId", this.deploymentRepository.getId());
            props.setProperty("generatePom", "false");
            request.setProperties(props);
            this.getLog().info((CharSequence)("Deploying aggregated zip using: mvn deploy:deploy-file" + this.serializeMvnProperties(props)));
            DefaultInvoker invoker = new DefaultInvoker();
            try {
                InvocationResult result = invoker.execute((InvocationRequest)request);
                if (result.getExitCode() != 0) {
                    throw new IllegalStateException("Error invoking Maven goal deploy:deploy-file");
                }
            }
            catch (MavenInvocationException e) {
                throw new MojoExecutionException("Error invoking Maven goal deploy:deploy-file", (Exception)((Object)e));
            }
        }
    }

    private static boolean hasAncestor(MavenProject root, MavenProject target) {
        if (target.getParent() == null) {
            return false;
        }
        if (Objects.equal((Object)root, (Object)target.getParent())) {
            return true;
        }
        return ZipMojo.hasAncestor(root, target.getParent());
    }

    private static String getReadMeFileKey(String relativePath) {
        String answer = relativePath;
        if (Strings.isNullOrBlank((String)answer)) {
            return "<root>";
        }
        int pos = relativePath.indexOf(47);
        int pos2 = relativePath.indexOf(92);
        if (pos > 0 && pos2 > 0) {
            pos = Math.max(pos, pos2);
        } else if (pos2 > 0) {
            pos = pos2;
        }
        if (pos > -1) {
            answer = relativePath.substring(pos);
        }
        if (Strings.isNullOrBlank((String)(answer = Files.stripLeadingSeparator((String)answer)))) {
            answer = "<root>";
        }
        return answer;
    }

    protected String replaceGithubLinks(Set<String> names, String relativePath, String line) {
        boolean changed = false;
        Pattern pattern = Pattern.compile("\\[(.*?)\\]\\((.*?)\\)");
        Matcher matcher = pattern.matcher(line);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String s2 = matcher.group(2);
            if (s2.startsWith("http:") || s2.startsWith("https:")) {
                matcher.appendReplacement(sb, "[$1]($2)");
                continue;
            }
            if (names.contains(s2) || names.contains(relativePath + s2) || names.contains(relativePath + "/" + s2)) {
                if (relativePath != null && !"<root>".equals(relativePath)) {
                    s2 = ZipMojo.addToPath(relativePath, s2);
                }
                matcher.appendReplacement(sb, "[$1](" + this.replaceReadmeLinksPrefix + s2 + ")");
            } else {
                if (relativePath != null && !"<root>".equals(relativePath)) {
                    s2 = ZipMojo.addToPath(relativePath, s2);
                }
                matcher.appendReplacement(sb, "[$1](" + this.replaceReadmeLinksPrefix + s2 + ".app)");
            }
            changed = true;
        }
        matcher.appendTail(sb);
        if (changed) {
            return sb.toString();
        }
        return null;
    }

    private static String addToPath(String path, String add) {
        if (add.startsWith("/") || path.endsWith("/")) {
            return path + add;
        }
        return path + "/" + add;
    }

    protected void createAggregatedZip(File projectBaseDir, File projectBuildDir, String reactorProjectOutputPath, File projectOutputFile, boolean includeReadMe, Set<MavenProject> pomZipProjects) throws IOException {
        projectBuildDir.mkdirs();
        for (MavenProject reactorProject : pomZipProjects) {
            if (reactorProject.isExecutionRoot()) continue;
            Log log = this.getLog();
            String relativePath = ZipMojo.getChildProjectRelativePath(projectBaseDir, reactorProject);
            File outDir = new File(projectBuildDir, relativePath);
            ZipMojo.combineAppFilesToFolder(reactorProject, outDir, log, reactorProjectOutputPath);
        }
        if (includeReadMe) {
            HashMap<String, File> pomNames = new HashMap<String, File>();
            for (MavenProject mavenProject : pomZipProjects) {
                String relativePath;
                File outDir;
                File src = mavenProject.getFile().getParentFile();
                File copiedFile = ZipMojo.copyReadMe(src, outDir = new File(projectBuildDir, relativePath = ZipMojo.getChildProjectRelativePath(projectBaseDir, mavenProject)));
                if (copiedFile == null) continue;
                String key = ZipMojo.getReadMeFileKey(relativePath);
                pomNames.put(key, copiedFile);
            }
            if (this.replaceReadmeLinksPrefix != null) {
                for (Map.Entry entry : pomNames.entrySet()) {
                    File file = (File)entry.getValue();
                    String key = (String)entry.getKey();
                    boolean changed = false;
                    List lines = Files.readLines((File)file);
                    for (int i = 0; i < lines.size(); ++i) {
                        String line = (String)lines.get(i);
                        String newLine = this.replaceGithubLinks(pomNames.keySet(), key, line);
                        if (newLine == null) continue;
                        lines.set(i, newLine);
                        changed = true;
                    }
                    if (!changed) continue;
                    Files.writeLines((File)file, (List)lines);
                    this.getLog().info((CharSequence)("Replaced github links to fabric apps in reaadme file: " + file));
                }
            }
        }
        Zips.createZipFile(this.getLog(), projectBuildDir, projectOutputFile, null);
        String relativePath = Files.getRelativePath((File)projectBaseDir, (File)projectOutputFile);
        while (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        this.getLog().info((CharSequence)("Created app zip file: " + relativePath));
    }

    protected static String getChildProjectRelativePath(File projectBaseDir, MavenProject pomProject) throws IOException {
        String root = projectBaseDir.getName();
        String relativePath = Files.getRelativePath((File)projectBaseDir, (File)pomProject.getBasedir());
        relativePath = root + File.separator + relativePath;
        return relativePath;
    }

    public static void appendAppConfigFiles(File appSourceDir, File outputDir) throws IOException {
        File[] files;
        if (appSourceDir.exists() && appSourceDir.isDirectory() && (files = appSourceDir.listFiles()) != null) {
            outputDir.mkdirs();
            for (File file : files) {
                File outFile = new File(outputDir, file.getName());
                if (file.isDirectory()) {
                    ZipMojo.appendAppConfigFiles(file, outFile);
                    continue;
                }
                if (outFile.exists() && file.getName().endsWith(".properties")) {
                    System.out.println("Combining properties: file " + file.getAbsolutePath());
                    ZipMojo.combinePropertiesFiles(file, outFile);
                    continue;
                }
                System.out.println("Copying file " + file.getAbsolutePath());
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    protected static void combineAppFilesToFolder(MavenProject reactorProject, File buildDir, Log log, String reactorProjectOutputPath) throws IOException {
        File basedir = reactorProject.getBasedir();
        if (!basedir.exists()) {
            log.warn((CharSequence)("No basedir " + basedir.getAbsolutePath() + " for project + " + reactorProject));
            return;
        }
        File outDir = new File(basedir, reactorProjectOutputPath);
        if (!outDir.exists()) {
            log.warn((CharSequence)("No app output dir at: " + outDir.getAbsolutePath() + " for project + " + reactorProject + " so ignoring this project."));
            return;
        }
        log.info((CharSequence)("Copying apps from " + outDir.getAbsolutePath() + " into the output directory: " + buildDir));
        File[] files = outDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                ZipMojo.appendAppConfigFiles(file, buildDir);
            }
        }
    }

    protected static void combinePropertiesFiles(File sourceFile, File destFile) throws IOException {
        Properties source = ZipMojo.loadProperties(sourceFile);
        Properties dest = ZipMojo.loadProperties(destFile);
        Set<Map.Entry<Object, Object>> entries = source.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String keyText = key.toString();
            String valueText = value.toString();
            String oldValue = dest.getProperty(keyText);
            if (oldValue == null || oldValue.trim().length() == 0) {
                dest.setProperty(keyText, valueText);
                continue;
            }
            if (oldValue.contains(valueText)) continue;
            String newValue = oldValue + " " + valueText;
            dest.setProperty(keyText, newValue);
        }
        dest.store(new FileWriter(destFile), "Generated by fabric8:full-zip plugin at " + new Date());
    }

    private static Properties loadProperties(File file) throws IOException {
        Properties answer = new Properties();
        answer.load(new FileReader(file));
        return answer;
    }

    protected String escapeAgentPropertiesKey(String text) {
        return text.replaceAll("\\:", "\\\\:");
    }

    protected String escapeAgentPropertiesValue(String text) {
        return this.escapeAgentPropertiesKey(text);
    }

    private static String leadingSlash(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private String serializeMvnProperties(Properties properties) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append(" -D").append(key).append('=').append(value);
            }
        }
        return sb.toString();
    }
}

