/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.utils.Files;
import io.fabric8.utils.TablePrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-env", defaultPhase=LifecyclePhase.COMPILE)
public class CreateEnvMojo
extends AbstractFabric8Mojo {
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";
    private static final String DOCKE_ENV_PREFIX = "docker.env.";
    private static final String DOCKER_NAME = "docker.name";
    private static final String EXEC_ENV_SCRIPT = "environmentScript";
    @Parameter(property="fabric8.envFile", defaultValue="env.properties")
    private String envPropertiesFileName;
    @Parameter(property="fabric8.envScript", defaultValue="env.sh")
    private String envScriptFileName;
    @Parameter(property="docker.image")
    private String name;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String basedir = System.getProperty("basedir", ".");
            File propertiesFile = new File(basedir + "/target/" + this.envPropertiesFileName).getCanonicalFile();
            File scriptFile = new File(basedir + "/target/" + this.envScriptFileName).getCanonicalFile();
            Object config = this.loadKubernetesJson();
            List list = KubernetesHelper.toItemList((Object)config);
            Map<String, String> env = this.getEnvFromConfig(list);
            String namespace = this.getNamespace();
            env.putAll(this.getNamespaceServiceEnv(namespace));
            this.displayEnv(env);
            for (Map.Entry<String, String> entry : env.entrySet()) {
                this.getProject().getProperties().setProperty(DOCKE_ENV_PREFIX + entry.getKey(), entry.getValue());
            }
            this.getProject().getProperties().setProperty(DOCKER_NAME, this.name);
            this.getProject().getProperties().setProperty(EXEC_ENV_SCRIPT, scriptFile.getAbsolutePath());
            Properties envProperties = new Properties();
            envProperties.putAll(env);
            CreateEnvMojo.saveScript(env, scriptFile);
            CreateEnvMojo.saveProperties(envProperties, propertiesFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, (Exception)e);
        }
    }

    Map<String, String> getNamespaceServiceEnv(String namespace) {
        HashMap<String, String> result = new HashMap<String, String>();
        KubernetesClient kubernetes = this.getKubernetes();
        ServiceList serviceList = kubernetes.getServices(namespace);
        RouteList routeList = kubernetes.getRoutes(namespace);
        for (Service service : serviceList.getItems()) {
            String serviceName = KubernetesHelper.getName((HasMetadata)service);
            String id = serviceName.toUpperCase().replace("-", "_");
            Route route = CreateEnvMojo.findRoute(serviceName, routeList);
            RouteSpec spec = null;
            if (route != null) {
                spec = route.getSpec();
            }
            ServiceSpec serviceSpec = service.getSpec();
            if (spec != null) {
                result.put(id + HOST_SUFFIX, spec.getHost());
            } else if (serviceSpec != null) {
                result.put(id + HOST_SUFFIX, serviceSpec.getPortalIP());
            }
            if (serviceSpec == null) continue;
            List ports = serviceSpec.getPorts();
            for (ServicePort port : ports) {
                result.put(id + PORT_SUFFIX, String.valueOf(port.getPort()));
                result.put(id + PROTO_SUFFIX, port.getProtocol());
                result.put(id + PORT_SUFFIX + "_" + port.getPort() + PROTO_SUFFIX, port.getProtocol());
            }
        }
        return result;
    }

    private Map<String, String> getEnvFromConfig(List<HasMetadata> entities) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                for (Container container : pod.getSpec().getContainers()) {
                    if (!container.getImage().equals(this.name)) continue;
                    result.putAll(CreateEnvMojo.mapFromEnv(container.getEnv()));
                }
                continue;
            }
            if (!(entity instanceof ReplicationController)) continue;
            ReplicationController replicationController = (ReplicationController)entity;
            for (Container container : replicationController.getSpec().getTemplate().getSpec().getContainers()) {
                if (!container.getImage().equals(this.name)) continue;
                result.putAll(CreateEnvMojo.mapFromEnv(container.getEnv()));
            }
        }
        return result;
    }

    private void displayEnv(Map<String, String> map) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"Name", "Value"});
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            table.row(new String[]{name, value});
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Generated Environment variables:");
        this.getLog().info((CharSequence)"-------------------------------");
        List lines = table.asTextLines();
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }

    private Object loadKubernetesJson() throws MojoFailureException, IOException {
        File json = this.getKubernetesJson();
        if (!Files.isFile((File)json)) {
            if (Files.isFile((File)this.kubernetesSourceJson)) {
                json = this.kubernetesSourceJson;
            } else {
                throw new MojoFailureException("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson);
            }
        }
        return KubernetesHelper.loadJson((File)json);
    }

    private static Map<String, String> mapFromEnv(List<EnvVar> envVars) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (EnvVar envVar : envVars) {
            result.put(envVar.getName(), envVar.getValue());
        }
        return result;
    }

    private static void saveProperties(Properties properties, File propertiesFile) throws IOException {
        try (FileWriter writer = new FileWriter(propertiesFile);){
            properties.store(writer, "Generated Environment Variables");
        }
    }

    private static void saveScript(Map<String, String> map, File scroptFile) throws IOException {
        try (FileWriter writer = new FileWriter(scroptFile);){
            writer.append("#!/bin/bash").append("\n");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                writer.append("export ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
            writer.flush();
        }
    }

    private static Route findRoute(String serviceId, RouteList routeList) {
        for (Route route : routeList.getItems()) {
            String name;
            ObjectReference to;
            RouteSpec spec = route.getSpec();
            if (spec == null || (to = spec.getTo()) == null || !serviceId.equals(name = to.getName())) continue;
            return route;
        }
        return null;
    }
}

