/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemas;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.Function;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractFabric8Mojo
extends AbstractNamespacedMojo {
    public static String[] ICON_EXTENSIONS = new String[]{".svg", ".png", ".gif", ".jpg", ".jpeg"};
    @Parameter(property="fabric8.zip.file", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-app.zip")
    protected File zipFile;
    @Parameter(property="fabric8.source.dir", defaultValue="${basedir}/src/main/fabric8")
    protected File appConfigDir;
    @Parameter(property="fabric8.iconRef")
    protected String iconRef;
    @Parameter(property="fabric8.json.target", defaultValue="${basedir}/target/classes/kubernetes.json")
    private File kubernetesJson;
    @Parameter(property="fabric8.json.source", defaultValue="${basedir}/src/main/fabric8/kubernetes.json")
    protected File kubernetesSourceJson;
    @Parameter(property="fabric8.replicas", defaultValue="1")
    private Integer replicas;
    @Parameter(property="fabric8.ignoreProject", defaultValue="false")
    private boolean ignoreProject;
    @Parameter(property="fabric8.envProperties", defaultValue="${basedir}/src/main/fabric8/env.properties")
    protected File envPropertiesFile;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="fabric8.excludedFiles", defaultValue="io.fabric8.agent.properties")
    private String[] filesToBeExcluded;

    protected static File copyReadMe(File src, File appBuildDir) throws IOException {
        File[] files = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).startsWith("readme.");
            }
        });
        if (files != null && files.length == 1) {
            File readme = files[0];
            File outFile = new File(appBuildDir, readme.getName());
            Files.copy((File)readme, (File)outFile);
            return outFile;
        }
        return null;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    public File getKubernetesJson() {
        return this.kubernetesJson;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public boolean isIgnoreProject() {
        return this.ignoreProject;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    protected boolean isPom(MavenProject reactorProject) {
        return "pom".equals(reactorProject.getPackaging());
    }

    protected InputStream loadPluginResource(String iconRef) throws MojoExecutionException {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(iconRef);
        if (answer == null) {
            answer = this.getTestClassLoader().getResourceAsStream(iconRef);
        }
        if (answer == null) {
            answer = ((Object)((Object)this)).getClass().getResourceAsStream(iconRef);
        }
        return answer;
    }

    protected URLClassLoader getCompileClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.getProject().getCompileClasspathElements();
            return this.createClassLoader(classpathElements, this.getProject().getBuild().getOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader getTestClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.getProject().getTestClasspathElements();
            return this.createClassLoader(classpathElements, this.getProject().getBuild().getTestOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader createClassLoader(List<String> classpathElements, String ... paths) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        for (String object : classpathElements) {
            if (object == null) continue;
            String path = object.toString();
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        this.getLog().debug((CharSequence)("Creating class loader from: " + urls));
        return AbstractFabric8Mojo.createURLClassLoader(urls);
    }

    private URL pathToUrl(String path) throws MalformedURLException {
        File file = new File(path);
        return file.toURI().toURL();
    }

    protected boolean hasConfigDir() {
        return this.appConfigDir.isDirectory();
    }

    protected boolean isPomProject() {
        return this.isPom(this.getProject());
    }

    protected boolean shouldGenerateForThisProject() {
        return !this.isPomProject() || this.hasConfigDir();
    }

    public Map<String, String> getEnvironmentVariableProperties() throws MojoExecutionException {
        Map rawProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProject().getProperties(), (String)"fabric8.env.", (Function)Strings.toEnvironmentVariableFunction());
        Set entries = rawProperties.entrySet();
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = AbstractFabric8Mojo.unquoteTemplateExpression(value);
            answer.put(key, value);
        }
        if (this.envPropertiesFile != null && this.envPropertiesFile.isFile() && this.envPropertiesFile.exists()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(this.envPropertiesFile));
                Map map = PropertiesHelper.toMap((Properties)properties);
                answer.putAll(map);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load environment properties file: " + this.envPropertiesFile + ". " + e, (Exception)e);
            }
        }
        return answer;
    }

    public static String unquoteTemplateExpression(String value) {
        return value;
    }

    public JsonSchema getEnvironmentVariableJsonSchema() throws IOException, MojoExecutionException {
        JsonSchema schema = JsonSchemas.loadEnvironmentSchemas(this.getCompileClassLoader(), this.getProject().getBuild().getOutputDirectory());
        if (schema == null) {
            this.getLog().info((CharSequence)"No environment schemas found for file: io/fabric8/environment/schema.json");
            schema = new JsonSchema();
        }
        Map<String, String> envs = this.getEnvironmentVariableProperties();
        JsonSchemas.addEnvironmentVariables(schema, envs);
        return schema;
    }

    protected File copyIconToFolder(File appBuildDir) throws MojoExecutionException, IOException {
        File[] icons;
        if (Strings.isNotBlank((String)this.iconRef) && ((icons = appBuildDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                String lower = name.toLowerCase();
                if (lower.startsWith("icon.")) {
                    for (String ext : ICON_EXTENSIONS) {
                        if (!lower.endsWith(ext)) continue;
                        return true;
                    }
                }
                return false;
            }
        })) == null || icons.length == 0)) {
            InputStream in = this.loadPluginResource(this.iconRef);
            if (in == null) {
                for (String ext : ICON_EXTENSIONS) {
                    String name = this.iconRef + ext;
                    in = this.loadPluginResource(name);
                    if (in == null) continue;
                    this.iconRef = name;
                    break;
                }
            }
            if (in == null) {
                this.getLog().warn((CharSequence)("Could not find icon: " + this.iconRef + " on the ClassPath!"));
            } else {
                String fileName = "icon." + Files.getFileExtension((String)this.iconRef);
                File outFile = new File(appBuildDir, fileName);
                Files.copy((InputStream)in, (OutputStream)new FileOutputStream(outFile));
                this.getLog().info((CharSequence)("Generated icon file " + outFile + " from icon reference: " + this.iconRef));
                return outFile;
            }
        }
        return null;
    }

    protected void copyAppConfigFiles(File appBuildDir, File appConfigDir) throws IOException {
        File[] files = appConfigDir.listFiles();
        if (files != null) {
            appBuildDir.mkdirs();
            for (File file : files) {
                if (this.toBeExclude(file.getName())) continue;
                File outFile = new File(appBuildDir, file.getName());
                if (file.isDirectory()) {
                    this.copyAppConfigFiles(outFile, file);
                    continue;
                }
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    protected boolean toBeExclude(String fileName) {
        List<String> excludedFilesList = Arrays.asList(this.filesToBeExcluded);
        Boolean result = excludedFilesList.contains(fileName);
        return result;
    }

    protected void copyReadMe(File appBuildDir) throws IOException {
        MavenProject project = this.getProject();
        AbstractFabric8Mojo.copyReadMe(project.getFile().getParentFile(), appBuildDir);
    }

    protected void copySummaryText(File appBuildDir) throws IOException {
        MavenProject project = this.getProject();
        String description = project.getDescription();
        if (Strings.isNotBlank((String)description)) {
            File summaryMd = new File(appBuildDir, "Summary.md");
            summaryMd.getParentFile().mkdirs();
            if (!summaryMd.exists()) {
                byte[] bytes = description.getBytes();
                Files.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)new FileOutputStream(summaryMd));
            }
        }
    }

    protected void printSummary(Object kubeResource) throws IOException {
        if (kubeResource instanceof Template) {
            Template template = (Template)kubeResource;
            String id = KubernetesHelper.getName((HasMetadata)template);
            this.getLog().info((CharSequence)("  Template " + id + " " + KubernetesHelper.summaryText((Template)template)));
            this.printSummary(template.getObjects());
            return;
        }
        List list = KubernetesHelper.toItemList((Object)kubeResource);
        for (Object object : list) {
            if (object == null) continue;
            if (object instanceof List) {
                this.printSummary(object);
                continue;
            }
            String kind = object.getClass().getSimpleName();
            String id = KubernetesHelper.getObjectId(object);
            this.getLog().info((CharSequence)("    " + kind + " " + id + " " + KubernetesHelper.summaryText(object)));
        }
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }
}

