/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.utils.Files;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="attach", defaultPhase=LifecyclePhase.PACKAGE)
public class AttachMojo
extends AbstractFabric8Mojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.kubernetes.artifactType", defaultValue="json")
    private String artifactType = "json";
    @Parameter(property="fabric8.kubernetes.artifactClassifier", defaultValue="kubernetes")
    private String artifactClassifier = "kubernetes";

    public void execute() throws MojoExecutionException, MojoFailureException {
        File json = this.getKubernetesJson();
        if (Files.isFile((File)json)) {
            this.printSummary(json);
            this.getLog().info((CharSequence)("Attaching kubernetes json file: " + json + " to the build"));
            this.projectHelper.attachArtifact(this.getProject(), this.artifactType, this.artifactClassifier, json);
        }
    }

    protected void printSummary(File json) throws MojoExecutionException {
        try {
            Object savedObjects = KubernetesHelper.loadJson((File)json);
            this.getLog().info((CharSequence)"Generated Kubernetes JSON resources:");
            this.printSummary(savedObjects);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load saved json file " + json + ". Reason: " + e, (Exception)e);
        }
    }
}

