/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EditableKubernetesList;
import io.fabric8.kubernetes.api.model.EditableObjectReference;
import io.fabric8.kubernetes.api.model.EditableQuantity;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.support.Commandline;
import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemaProperty;
import io.fabric8.maven.support.VolumeType;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import io.fabric8.openshift.api.model.EditableDeploymentConfig;
import io.fabric8.openshift.api.model.EditableImageStream;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ParameterBuilder;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.utils.Base64Encoder;
import io.fabric8.utils.Files;
import io.fabric8.utils.Function;
import io.fabric8.utils.Objects;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="json", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class JsonMojo
extends AbstractFabric8Mojo {
    public static final String FABRIC8_PORT_HOST_PREFIX = "docker.port.host.";
    public static final String FABRIC8_PORT_CONTAINER_PREFIX = "docker.port.container.";
    public static final String FABRIC8_PORT_SERVICE = "fabric8.service.port";
    public static final String FABRIC8_CONTAINER_PORT_SERVICE = "fabric8.service.containerPort";
    public static final String FABRIC8_NODE_PORT_SERVICE = "fabric8.service.nodePort";
    public static final String FABRIC8_PROTOCOL_SERVICE = "fabric8.service.protocol";
    public static final String FABRIC8_METRICS_PREFIX = "fabric8.metrics.";
    public static final String FABRIC8_METRICS_SCRAPE = "fabric8.metrics.scrape";
    public static final String FABRIC8_METRICS_SCRAPE_ANNOTATION = "fabric8.metrics.scrape.annotation";
    public static final String FABRIC8_METRICS_PORT = "fabric8.metrics.port";
    public static final String FABRIC8_METRICS_PORT_ANNOTATION = "fabric8.metrics.port.annotation";
    public static final String FABRIC8_METRICS_SCHEME = "fabric8.metrics.scheme";
    public static final String FABRIC8_METRICS_SCHEME_ANNOTATION = "fabric8.metrics.scheme.annotation";
    public static final String FABRIC8_ICON_URL_ANNOTATION = "fabric8.io/iconUrl";
    private static final String SERVICE_REGEX = "^fabric8\\.service\\.(?<name>[^. ]+)\\..+$";
    private static final Pattern SERVICE_PATTERN = Pattern.compile("^fabric8\\.service\\.(?<name>[^. ]+)\\..+$");
    private static final String NAME = "name";
    private static final String ATTRIBUTE_TYPE = "attributeType";
    private static final String VOLUME_MOUNT_PATH = "mountPath";
    private static final String VOLUME_REGEX = "fabric8.volume.(?<name>[^. ]*).(?<attributeType>[^. ]*)";
    private static final Pattern VOLUME_PATTERN = Pattern.compile("fabric8.volume.(?<name>[^. ]*).(?<attributeType>[^. ]*)");
    private static final String PARAM_REGEX = "fabric8.parameter.(?<name>[^. ]*)(.)?(?<attributeType>[^ ]*)";
    private static final Pattern PARAM_PATTERN = Pattern.compile("fabric8.parameter.(?<name>[^. ]*)(.)?(?<attributeType>[^ ]*)");
    private static final String TEMPLATE_NAME = "fabric8.template";
    private static final String PARAMETER_PREFIX = "fabric8.parameter";
    private static final String PARAMETER_NAME_PREFIX = "fabric8.parameter.%s";
    private static final String PARAMETER_PROPERTY = "fabric8.parameter.%s.%s";
    private static final String GENERATE = "generate";
    private static final String FROM = "from";
    private static final String VALUE = "value";
    private static final String DESCRIPTION = "description";
    private static final String CPU = "cpu";
    private static final String MEMORY = "memory";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.kubernetes.artifactType", defaultValue="json")
    private String artifactType = "json";
    @Parameter(property="fabric8.kubernetes.artifactClassifier", defaultValue="kubernetes")
    private String artifactClassifier = "kubernetes";
    @Parameter(property="fabric8.generateJson", defaultValue="true")
    private boolean generateJson;
    @Parameter(property="fabric8.failOnMissingJsonFiles", defaultValue="true")
    private boolean failOnMissingJsonFiles;
    @Parameter(property="fabric8.generateSecurityContextConstraints", defaultValue="false")
    private boolean generateSecurityContextConstraints;
    @Parameter(property="fabric8.includeNamespaceEnvVar", defaultValue="true")
    private boolean includeNamespaceEnvVar;
    @Parameter(property="fabric8.namespaceEnvVar", defaultValue="KUBERNETES_NAMESPACE")
    private String kubernetesNamespaceEnvVar;
    @Parameter(property="fabric8.includePodEnvVar", defaultValue="false")
    private boolean includePodEnvVar;
    @Parameter(property="fabric8.podEnvVar", defaultValue="KUBERNETES_POD")
    private String kubernetesPodEnvVar;
    @Parameter(property="fabric8.provider", defaultValue="fabric8")
    private String provider;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private Map<String, String> podSpecAnnotations;
    @Parameter
    private Map<String, String> rcAnnotations;
    @Parameter
    private Map<String, String> templateAnnotations;
    @Parameter
    private Map<String, String> serviceAnnotations;
    @Parameter
    private List<EnvVar> environmentVariables;
    @Parameter
    private List<ContainerPort> containerPorts;
    @Parameter
    private Map<String, Integer> defaultContainerPortMap;
    @Parameter
    private List<ServicePort> servicePorts;
    @Parameter(property="fabric8.replicas", defaultValue="1")
    private Integer replicaCount;
    @Parameter(property="fabric8.useDeploymentConfig", defaultValue="false")
    private boolean useDeploymentConfig;
    @Parameter(property="fabric8.lastTriggeredImageTag", defaultValue="latest")
    private String lastTriggeredImageTag;
    @Parameter(property="fabric8.deploymentStrategy", defaultValue="Recreate")
    private String deploymentStrategy;
    @Parameter(property="fabric8.extra.json", defaultValue="${basedir}/target/classes/kubernetes-extra.json")
    private File kubernetesExtraJson;
    @Parameter(property="fabric8.templateTempDir", defaultValue="${basedir}/target/fabric8/template-workdir")
    private File templateTempDir;
    @Parameter(property="fabric8.iconUrl")
    private String iconUrl;
    @Parameter(property="fabric8.iconUrlPrefix")
    private String iconUrlPrefix;
    @Parameter(property="fabric8.iconBranch", defaultValue="master")
    private String iconBranch;
    @Parameter(property="fabric8.replicationController.name", defaultValue="${project.artifactId}")
    private String replicationControllerName;
    @Parameter(property="fabric8.label.project", defaultValue="${project.artifactId}")
    private String projectName;
    @Parameter(property="fabric8.combineJson.project", defaultValue="${project.artifactId}")
    private String combineProjectName;
    @Parameter(property="fabric8.label.group", defaultValue="${project.groupId}")
    private String groupName;
    @Parameter(property="fabric8.container.name", defaultValue="${project.artifactId}")
    private String kubernetesContainerName;
    @Parameter(property="fabric8.service.name", defaultValue="${project.artifactId}")
    private String serviceName;
    @Parameter(property="fabric8.service.headless", defaultValue="false")
    private boolean headlessService;
    @Parameter(property="fabric8.service.type")
    private String serviceType;
    @Parameter(property="fabric8.metrics.scrape", defaultValue="false")
    private boolean metricsScrape;
    @Parameter(property="fabric8.metrics.scrape.annotation", defaultValue="prometheus.io/scrape")
    private String metricsScrapeAnnotation;
    @Parameter(property="fabric8.metrics.port")
    private Integer metricsPort;
    @Parameter(property="fabric8.metrics.port.annotation", defaultValue="prometheus.io/port")
    private String metricsPortAnnotation;
    @Parameter(property="fabric8.metrics.scheme")
    private String metricsScheme;
    @Parameter(property="fabric8.metrics.scheme.annotation", defaultValue="prometheus.io/scheme")
    private String metricsSchemeAnnotation;
    @Parameter(property="fabric8.service.port")
    private Integer servicePort;
    @Parameter(property="fabric8.service.containerPort")
    private String serviceContainerPort;
    @Parameter(property="fabric8.service.nodePort")
    private Integer serviceNodePort;
    @Parameter(property="fabric8.service.protocol", defaultValue="TCP")
    private String serviceProtocol;
    @Parameter(property="fabric8.imagePullPolicy")
    private String imagePullPolicy;
    @Parameter(property="fabric8.imagePullPolicySnapshot")
    private String imagePullPolicySnapshot;
    @Parameter(property="fabric8.includeAllEnvironmentVariables", defaultValue="true")
    private boolean includeAllEnvironmentVariables;
    @Parameter(property="fabric8.containerPrivileged")
    protected Boolean containerPrivileged;
    @Parameter(property="fabric8.serviceAccount")
    protected String serviceAccount;
    @Parameter(property="fabric8.serviceAccountCreate")
    private boolean createServiceAccount;
    @Parameter(property="fabric8.templateParametersFile", defaultValue="${basedir}/src/main/fabric8/templateParameters.properties")
    protected File templateParametersPropertiesFile;
    @Parameter(property="fabric8.podSpecAnnotationsFile", defaultValue="${basedir}/src/main/fabric8/podSpecAnnotations.properties")
    protected File podSpecAnnotationsFile;
    @Parameter(property="fabric8.rcAnnotationsFile", defaultValue="${basedir}/src/main/fabric8/rcAnnotations.properties")
    protected File rcAnnotationsFile;
    @Parameter(property="fabric8.templateAnnotationsFile", defaultValue="${basedir}/src/main/fabric8/templateAnnotations.properties")
    protected File templateAnnotationsFile;
    @Parameter(property="fabric8.serviceAnnotationsFile", defaultValue="${basedir}/src/main/fabric8/serviceAnnotations.properties")
    protected File serviceAnnotationsFile;
    @Parameter(property="fabric8.maximumDataUrlSizeK", defaultValue="2")
    private int maximumDataUrlSizeK;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(property="localRepository", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    protected List remoteRepositories;
    @Parameter(property="fabric8.defaultPersistentVolumeClaimRequestsStorage", defaultValue="20")
    private String defaultPersistentVolumeClaimRequestsStorage;
    @Parameter(property="fabric8.removeVersionLabelFromServiceSelector", defaultValue="true")
    private boolean removeVersionLabelFromServiceSelector;
    @Parameter(property="fabric8.resources.limits.cpu", defaultValue="0")
    private String limitsCpu;
    @Parameter(property="fabric8.resources.limits.memory", defaultValue="0")
    private String limitsMemory;
    @Parameter(property="fabric8.resources.requests.cpu", defaultValue="0")
    private String requestsCpu;
    @Parameter(property="fabric8.resources.requests.cpu", defaultValue="0")
    private String requestsMemory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File json = this.getKubernetesJson();
        this.getLog().info((CharSequence)("Configured with file: " + json));
        if (json == null) {
            throw new MojoExecutionException("No kubernetes json file is specified!");
        }
        if (this.shouldGenerateForThisProject() && (!this.isIgnoreProject() || this.combineDependencies)) {
            if (this.generateJson) {
                this.generateKubernetesJson(json);
                if (this.combineDependencies) {
                    this.combineDependentJsonFiles(this.getKubernetesCombineJson() == null ? json : this.getKubernetesCombineJson());
                }
                if (this.kubernetesExtraJson != null && this.kubernetesExtraJson.exists()) {
                    this.combineJsonFiles(json, this.kubernetesExtraJson);
                }
            }
            if (json.exists() && json.isFile()) {
                if (this.useDeploymentConfig) {
                    this.wrapInDeploymentConfigs(json);
                }
                this.addEnvironmentAnnotations(json);
            }
        }
    }

    @Override
    protected boolean shouldGenerateForThisProject() {
        return super.shouldGenerateForThisProject() || this.combineDependencies;
    }

    protected void combineDependentJsonFiles(File json) throws MojoExecutionException {
        try {
            MavenProject project = this.getProject();
            LinkedHashSet<File> jsonFiles = new LinkedHashSet<File>();
            Set dependencyArtifacts = project.getDependencyArtifacts();
            for (Object artifact : dependencyArtifacts) {
                String classifier = artifact.getClassifier();
                String type = artifact.getType();
                File file = artifact.getFile();
                if (!JsonMojo.isKubernetesJsonArtifact(classifier, type)) continue;
                if (file != null) {
                    System.out.println("Found kubernetes JSON dependency: " + artifact);
                    jsonFiles.add(file);
                    continue;
                }
                Set<Artifact> artifacts = this.resolveArtifacts((Artifact)artifact);
                for (Artifact resolvedArtifact : artifacts) {
                    classifier = resolvedArtifact.getClassifier();
                    type = resolvedArtifact.getType();
                    file = resolvedArtifact.getFile();
                    if (!JsonMojo.isKubernetesJsonArtifact(classifier, type) || file == null) continue;
                    System.out.println("Resolved kubernetes JSON dependency: " + artifact);
                    jsonFiles.add(file);
                }
            }
            ArrayList<Object> jsonObjectList = new ArrayList<Object>();
            for (File file : jsonFiles) {
                this.addKubernetesJsonFileToList(jsonObjectList, file);
            }
            if (jsonObjectList.isEmpty()) {
                if (this.failOnMissingJsonFiles) {
                    throw new MojoExecutionException("Could not find any dependent kubernetes JSON files!");
                }
                this.getLog().warn((CharSequence)"Could not find any dependent kubernetes JSON files");
                return;
            }
            Object combinedJson = jsonObjectList.size() == 1 ? jsonObjectList.get(0) : KubernetesHelper.combineJson((Object[])jsonObjectList.toArray());
            if (combinedJson instanceof Template) {
                Template template = (Template)combinedJson;
                String templateName = this.getCombineProjectName();
                KubernetesHelper.setName((HasMetadata)template, (String)templateName);
                this.configureTemplateDescriptionAndIcon(template, this.getIconUrl());
                this.addLabelIntoObjects(template.getObjects(), "package", templateName);
                if (this.pureKubernetes) {
                    combinedJson = this.applyTemplates(template);
                }
            }
            if (this.pureKubernetes) {
                combinedJson = this.filterPureKubernetes(combinedJson);
            }
            json.getParentFile().mkdirs();
            KubernetesHelper.saveJson((File)json, combinedJson);
            this.getLog().info((CharSequence)("Saved as :" + json.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to save combined JSON files " + json + " and " + this.kubernetesExtraJson + " as " + json + ". " + e, e);
        }
    }

    protected void addLabelIntoObjects(List<HasMetadata> objects, String label, String value) {
        for (HasMetadata object : objects) {
            PodTemplateSpec template;
            ReplicationController entity;
            ReplicationControllerSpec spec;
            this.addLabelIfNotExist(object, label, value);
            if (!(object instanceof ReplicationController) || (spec = (entity = (ReplicationController)object).getSpec()) == null || (template = spec.getTemplate()) == null) continue;
            HasMetadata hasMetadata = new HasMetadata(){

                public ObjectMeta getMetadata() {
                    return template.getMetadata();
                }

                public void setMetadata(ObjectMeta objectMeta) {
                    template.setMetadata(objectMeta);
                }

                public String getKind() {
                    return "PodTemplateSpec";
                }

                public String getApiVersion() {
                    return entity.getApiVersion();
                }
            };
            this.addLabelIfNotExist(hasMetadata, label, value);
        }
    }

    protected boolean addLabelIfNotExist(HasMetadata object, String label, String value) {
        Map labels;
        if (object != null && (labels = KubernetesHelper.getOrCreateLabels((HasMetadata)object)).get(label) == null) {
            labels.put(label, value);
            return true;
        }
        return false;
    }

    protected Object applyTemplates(Template template) throws IOException {
        this.overrideTemplateParameters(template);
        return Templates.processTemplatesLocally((Template)template, (boolean)false);
    }

    protected Object filterPureKubernetes(Object dto) throws IOException {
        List items = KubernetesHelper.toItemList((Object)dto);
        ArrayList<HasMetadata> filtered = new ArrayList<HasMetadata>();
        for (HasMetadata item : items) {
            if (!KubernetesHelper.isPureKubernetes((HasMetadata)item)) continue;
            filtered.add(item);
        }
        KubernetesList answer = new KubernetesList();
        answer.setItems(filtered);
        return answer;
    }

    private void addKubernetesJsonFileToList(List<Object> list, File file) {
        block5: {
            if (file.exists() && file.isFile()) {
                try {
                    Object jsonObject = JsonMojo.loadJsonFile(file);
                    if (jsonObject != null) {
                        list.add(jsonObject);
                        break block5;
                    }
                    this.getLog().warn((CharSequence)("No object found for file: " + file));
                }
                catch (MojoExecutionException e) {
                    this.getLog().warn((CharSequence)("Failed to parse file " + file + ". " + (Object)((Object)e)), (Throwable)e);
                }
            } else {
                this.getLog().warn((CharSequence)("Ignoring missing file " + file));
            }
        }
    }

    protected Set<Artifact> resolveArtifacts(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setRemoteRepositories(this.remoteRepositories);
        request.setLocalRepository(this.localRepository);
        ArtifactResolutionResult resolve = this.resolver.resolve(request);
        return resolve.getArtifacts();
    }

    protected void combineJsonFiles(File json, File kubernetesExtraJson) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Combining generated json " + json + " with extra json " + kubernetesExtraJson));
        Object extra = JsonMojo.loadJsonFile(kubernetesExtraJson);
        Object generated = JsonMojo.loadJsonFile(json);
        try {
            Object combinedJson = KubernetesHelper.combineJson((Object[])new Object[]{generated, extra});
            KubernetesHelper.saveJson((File)json, (Object)combinedJson);
            this.getLog().info((CharSequence)("Saved as :" + json.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save combined JSON files " + json + " and " + kubernetesExtraJson + " as " + json + ". " + e, (Exception)e);
        }
    }

    protected void wrapInDeploymentConfigs(File json) throws MojoExecutionException {
        try {
            Object dto = JsonMojo.loadJsonFile(json);
            if (dto instanceof KubernetesList) {
                KubernetesList container = (KubernetesList)dto;
                List<HasMetadata> items = container.getItems();
                items = this.wrapInDeploymentConfigs(items);
                this.getLog().info((CharSequence)"Wrapped in DeploymentConfigs:");
                this.printSummary(items);
                container.setItems(items);
                KubernetesHelper.saveJson((File)json, (Object)container);
            } else if (dto instanceof Template) {
                Template container = (Template)dto;
                List<HasMetadata> items = container.getObjects();
                items = this.wrapInDeploymentConfigs(items);
                this.getLog().info((CharSequence)"Wrapped in DeploymentConfigs:");
                this.printSummary(items);
                container.setObjects(items);
                this.getLog().info((CharSequence)"Template is now:");
                this.printSummary(container.getObjects());
                KubernetesHelper.saveJson((File)json, (Object)container);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save combined JSON files " + json + " and " + this.kubernetesExtraJson + " as " + json + ". " + e, (Exception)e);
        }
    }

    protected List<HasMetadata> wrapInDeploymentConfigs(List<HasMetadata> items) {
        ArrayList<HasMetadata> answer = new ArrayList<HasMetadata>();
        for (HasMetadata item : items) {
            if (item instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)item;
                this.wrapInDeploymentConfigs(answer, replicationController);
                continue;
            }
            answer.add(item);
        }
        return answer;
    }

    protected void wrapInDeploymentConfigs(List<HasMetadata> list, ReplicationController replicationController) {
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
        String name = KubernetesHelper.getName((HasMetadata)replicationController);
        if (Strings.isNotBlank((String)name)) {
            name = Strings.stripSuffix((String)name, (String)"-controller");
        }
        if (Strings.isNullOrBlank((String)name)) {
            name = this.getProject().getArtifactId();
        }
        String deploymentName = name;
        String imageStream = name;
        Map labels = KubernetesHelper.getLabels((HasMetadata)replicationController);
        builder = (DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)builder.withNewMetadata().withName(deploymentName)).withLabels(labels)).endMetadata();
        ReplicationControllerSpec spec = replicationController.getSpec();
        if (spec != null) {
            List containers;
            PodSpec podSpec;
            ArrayList<String> containerNames = new ArrayList<String>();
            PodTemplateSpec podTemplateSpec = spec.getTemplate();
            if (podTemplateSpec != null && (podSpec = podTemplateSpec.getSpec()) != null && (containers = podSpec.getContainers()) != null) {
                for (Container container : containers) {
                    String containerName = container.getName();
                    if (!Strings.isNotBlank((String)containerName)) continue;
                    containerNames.add(containerName);
                }
            }
            this.getOrAddImageStream(list, imageStream, labels);
            builder = (DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.StrategyNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)builder.withNewSpec().withTemplate(podTemplateSpec)).withReplicas(spec.getReplicas())).withSelector(spec.getSelector())).withNewStrategy().withType(this.deploymentStrategy)).endStrategy()).addNewTrigger().withType("ImageChange")).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withContainerNames(containerNames)).withNewFrom().withName(imageStream + ":" + this.lastTriggeredImageTag)).endFrom()).withLastTriggeredImage(this.lastTriggeredImageTag)).endImageChangeParams()).endTrigger()).endSpec();
        }
        EditableDeploymentConfig config = builder.build();
        list.add((HasMetadata)config);
    }

    protected ImageStream getOrAddImageStream(List<HasMetadata> list, String imageStreamName, Map<String, String> labels) {
        for (HasMetadata item : list) {
            ImageStream stream;
            if (!(item instanceof ImageStream) || !Objects.equal((Object)imageStreamName, (Object)KubernetesHelper.getName((HasMetadata)(stream = (ImageStream)item)))) continue;
            return stream;
        }
        EditableImageStream imageStream = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(imageStreamName)).withLabels(labels)).endMetadata()).build();
        list.add((HasMetadata)imageStream);
        return imageStream;
    }

    protected void generateKubernetesJson(File kubernetesJson) throws MojoExecutionException {
        Object result;
        EditableKubernetesList kubernetesList;
        String iconUrl;
        MavenProject project = this.getProject();
        Map<String, String> labelMap = this.getLabels();
        String name = this.getProjectName();
        String group = this.getGroupName();
        if (!labelMap.containsKey("version")) {
            labelMap.put("version", project.getVersion());
        }
        if (!labelMap.containsKey("project") && Strings.isNotBlank((String)name)) {
            labelMap.put("project", name);
        }
        if (!labelMap.containsKey("group") && Strings.isNotBlank((String)group)) {
            labelMap.put("group", group);
        }
        if (!labelMap.containsKey("provider") && Strings.isNotBlank((String)this.provider)) {
            labelMap.put("provider", this.provider);
        }
        Map<String, String> podSpecAnnotations = this.getPodSpecAnnotations();
        Map<String, String> rcAnnotations = this.getRCAnnotations();
        KubernetesListBuilder builder = new KubernetesListBuilder();
        boolean addedServiceAcount = this.addServiceAccountIfIUsingSecretAnnotations(builder, podSpecAnnotations);
        List<Volume> volumes = this.getVolumes();
        List<VolumeMount> volumeMounts = this.getVolumeMounts();
        Boolean containerPrivileged = this.getContainerPrivileged();
        if (addedServiceAcount) {
            this.addServiceConstraints(builder, volumes, containerPrivileged != null && containerPrivileged != false);
        }
        if (Strings.isNotBlank((String)(iconUrl = this.getIconUrl()))) {
            rcAnnotations.put(FABRIC8_ICON_URL_ANNOTATION, iconUrl);
        }
        if (Utils.isNotNullOrEmpty((String)this.getDockerImage())) {
            ((BaseKubernetesListFluent.ReplicationControllerItemsNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.SecurityContextNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((BaseKubernetesListFluent.ReplicationControllerItemsNested)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)builder.addNewReplicationControllerItem().withNewMetadata().withName(KubernetesHelper.validateKubernetesId((String)this.replicationControllerName, (String)"fabric8.replicationController.name"))).withLabels(labelMap)).withAnnotations(rcAnnotations)).endMetadata()).withNewSpec().withReplicas(this.replicaCount)).withSelector(labelMap)).withNewTemplate().withNewMetadata().withLabels(labelMap)).withAnnotations(podSpecAnnotations)).endMetadata()).withNewSpec().withServiceAccountName(this.serviceAccount)).addNewContainer().withName(this.getKubernetesContainerName())).withImage(this.getDockerImage())).withImagePullPolicy(this.getImagePullPolicy())).withNewResources().addToLimits(CPU, new Quantity(this.limitsCpu))).addToLimits(MEMORY, new Quantity(this.limitsMemory))).addToRequests(CPU, new Quantity(this.requestsCpu))).addToRequests(MEMORY, new Quantity(this.requestsMemory))).endResources()).withEnv(this.getEnvironmentVariables())).withNewSecurityContext().withPrivileged(containerPrivileged)).endSecurityContext()).withPorts(this.getContainerPorts())).withVolumeMounts(volumeMounts)).withLivenessProbe(this.getLivenessProbe())).withReadinessProbe(this.getReadinessProbe())).endContainer()).withVolumes(volumes)).endSpec()).endTemplate()).endSpec()).endReplicationControllerItem();
        }
        this.addPersistentVolumeClaims(builder, volumes);
        this.addServices(builder, labelMap, iconUrl);
        Template template = this.getTemplate();
        if (!template.getParameters().isEmpty() || Strings.isNotBlank((String)iconUrl)) {
            this.configureTemplateDescriptionAndIcon(template, iconUrl);
            builder = (KubernetesListBuilder)builder.addToTemplateItems(new Template[]{template});
        }
        if ((kubernetesList = builder.build()).getItems().isEmpty()) {
            this.getLog().warn((CharSequence)"No Kubernetes resources found! Skipping...");
        }
        if ((result = Templates.combineTemplates((KubernetesList)kubernetesList)) instanceof Template) {
            Template resultTemplate = (Template)result;
            this.defaultIconUrl(resultTemplate.getObjects());
            this.configureTemplateDescriptionAndIcon(resultTemplate, iconUrl);
            if (this.pureKubernetes) {
                try {
                    result = this.applyTemplates(resultTemplate);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to process template locally " + e, (Exception)e);
                }
            }
        }
        try {
            this.defaultIconUrl(KubernetesHelper.toItemList((Object)result));
            if (this.pureKubernetes) {
                result = this.filterPureKubernetes(result);
            }
            ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
            String generated = mapper.writeValueAsString(result);
            Files.writeToFile((File)kubernetesJson, (String)generated, (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to generate Kubernetes JSON.", e);
        }
    }

    private void defaultIconUrl(List<HasMetadata> hasMetadatas) {
        String iconUrl = this.getIconUrl();
        if (Strings.isNotBlank((String)iconUrl)) {
            for (HasMetadata entity : hasMetadatas) {
                Map annotations;
                if (!(entity instanceof Service) && !(entity instanceof ServiceAccount) || !Strings.isNullOrBlank((String)((String)(annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)entity)).get(FABRIC8_ICON_URL_ANNOTATION)))) continue;
                annotations.put(FABRIC8_ICON_URL_ANNOTATION, iconUrl);
            }
        }
    }

    private void addServices(KubernetesListBuilder builder, Map<String, String> labelMap, String iconUrl) throws MojoExecutionException {
        MavenProject project = this.getProject();
        Properties properties = this.getProjectAndFabric8Properties(project);
        HashSet<String> serviceNames = new HashSet<String>(Arrays.asList(""));
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String s;
            Matcher m;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(m = SERVICE_PATTERN.matcher(s = (String)key)).matches()) continue;
            String name = m.group(NAME);
            serviceNames.add(name);
        }
        for (String serviceName : serviceNames) {
            String headlessPrefix;
            Boolean tempHeadlessService;
            boolean hasPorts;
            String tempServiceName;
            Map<String, String> serviceAnnotations = this.getServiceAnnotations();
            serviceAnnotations.putAll(this.getMetricsAnnotations(serviceName));
            if (Strings.isNotBlank((String)this.iconUrl)) {
                serviceAnnotations.put(FABRIC8_ICON_URL_ANNOTATION, this.iconUrl);
            }
            HashMap<String, String> selector = new HashMap<String, String>(labelMap);
            if (this.removeVersionLabelFromServiceSelector && selector.remove("version") != null) {
                this.getLog().info((CharSequence)("Removed 'version' label from service selector for service `" + serviceName + "`"));
            }
            if (Strings.isNullOrBlank((String)(tempServiceName = serviceName))) {
                tempServiceName = this.serviceName;
            }
            ServiceBuilder serviceBuilder = (ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(tempServiceName)).withLabels(labelMap)).withAnnotations(serviceAnnotations)).endMetadata();
            ServiceFluent.SpecNested serviceSpecBuilder = (ServiceFluent.SpecNested)serviceBuilder.withNewSpec().withSelector(selector);
            List<ServicePort> servicePorts = this.getServicePorts(serviceName);
            this.getLog().info((CharSequence)("Generated ports: " + servicePorts));
            boolean bl = hasPorts = servicePorts != null && !servicePorts.isEmpty();
            if (hasPorts) {
                serviceSpecBuilder.withPorts(servicePorts);
            }
            if ((tempHeadlessService = Boolean.valueOf(properties.getProperty(headlessPrefix = this.buildServicePrefix(serviceName, "fabric8.service", "headless")))).booleanValue()) {
                serviceSpecBuilder.withClusterIP("None");
                if (!hasPorts && Boolean.parseBoolean(serviceAnnotations.get(this.metricsScrapeAnnotation))) {
                    try {
                        String port = serviceAnnotations.get(this.metricsPortAnnotation);
                        Integer metricsPort = Integer.parseInt(port);
                        if (metricsPort != null) {
                            ServicePort servicePort = new ServicePort();
                            servicePort.setPort(metricsPort);
                            servicePort.setTargetPort(new IntOrString(metricsPort));
                            serviceSpecBuilder.withPorts(Arrays.asList(servicePort));
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (Strings.isNotBlank((String)this.serviceType)) {
                serviceSpecBuilder.withType(this.serviceType);
            }
            serviceSpecBuilder.endSpec();
            if (!tempHeadlessService.booleanValue() && !hasPorts) continue;
            builder = (KubernetesListBuilder)builder.addToServiceItems(new Service[]{serviceBuilder.build()});
        }
    }

    private Map<? extends String, ? extends String> getMetricsAnnotations(String serviceName) {
        String tempMetricsScheme;
        boolean tempMetricsScrape;
        HashMap<String, String> metricsAnnotations = new HashMap<String, String>();
        Integer tempMetricsPort = null;
        if (Strings.isNotBlank((String)serviceName)) {
            Properties properties = this.getProjectAndFabric8Properties(this.getProject());
            tempMetricsScrape = Boolean.parseBoolean(properties.getProperty(this.buildServicePrefix(serviceName, "fabric8.service", "metrics.scrape")));
            tempMetricsScheme = properties.getProperty(this.buildServicePrefix(serviceName, "fabric8.service", "metrics.scheme"));
            String port = properties.getProperty(this.buildServicePrefix(serviceName, "fabric8.service", "metrics.port"));
            if (port != null) {
                tempMetricsPort = Integer.parseInt(port);
            }
        } else {
            tempMetricsScrape = this.metricsScrape;
            tempMetricsScheme = this.metricsScheme;
            tempMetricsPort = this.metricsPort;
        }
        if (tempMetricsScrape) {
            metricsAnnotations.put(this.metricsScrapeAnnotation, Boolean.toString(tempMetricsScrape));
            if (tempMetricsPort != null) {
                metricsAnnotations.put(this.metricsPortAnnotation, tempMetricsPort.toString());
            }
            if (tempMetricsScheme != null) {
                metricsAnnotations.put(this.metricsSchemeAnnotation, tempMetricsScheme);
            }
        }
        return metricsAnnotations;
    }

    protected void addPersistentVolumeClaims(KubernetesListBuilder builder, List<Volume> volumes) {
        for (Volume volume : volumes) {
            PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
            if (persistentVolumeClaim == null) continue;
            String name = volume.getName();
            String claimName = persistentVolumeClaim.getClaimName();
            Boolean readOnly = persistentVolumeClaim.getReadOnly();
            if (Strings.isNotBlank((String)claimName)) {
                String requestStorageProperty;
                String accessModes = readOnly != null && readOnly != false ? "ReadOnly" : "ReadWriteMany";
                Properties properties = this.getProjectAndFabric8Properties(this.getProject());
                String amount = properties.getProperty(requestStorageProperty = String.format("fabric8.volume.%s.%s", name, "requestStorage"));
                if (Strings.isNullOrBlank((String)amount)) {
                    amount = this.defaultPersistentVolumeClaimRequestsStorage;
                    this.getLog().info((CharSequence)("No maven property defined for `" + requestStorageProperty + "` so defaulting the requestStorage to " + amount));
                } else {
                    this.getLog().debug((CharSequence)("Maven property `" + requestStorageProperty + "` = " + amount));
                }
                HashMap<String, EditableQuantity> requests = new HashMap<String, EditableQuantity>();
                EditableQuantity requestLimit = ((QuantityBuilder)new QuantityBuilder().withAmount(amount)).build();
                requests.put("storage", requestLimit);
                ((BaseKubernetesListFluent.PersistentVolumeClaimItemsNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((BaseKubernetesListFluent.PersistentVolumeClaimItemsNested)((PersistentVolumeClaimFluent.MetadataNested)builder.addNewPersistentVolumeClaimItem().withNewMetadata().withName(claimName)).endMetadata()).withNewSpec().withAccessModes(new String[]{accessModes})).withVolumeName(claimName)).withNewResources().withRequests(requests)).endResources()).endSpec()).endPersistentVolumeClaimItem();
                continue;
            }
            this.getLog().warn((CharSequence)("No claimName for persistent volume " + volume));
        }
    }

    protected boolean addServiceAccountIfIUsingSecretAnnotations(KubernetesListBuilder builder, Map<String, String> annotations) {
        HashSet<String> secretAnnotations = new HashSet<String>(Arrays.asList("fabric8.io/secret-ssh-key", "fabric8.io/secret-ssh-public-key", "fabric8.io/secret-gpg-key"));
        Set<Map.Entry<String, String>> entries = annotations.entrySet();
        TreeSet<String> secretNameSet = new TreeSet<String>();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!secretAnnotations.contains(key)) continue;
            List<String> secretNames = JsonMojo.parseSecretNames(value);
            secretNameSet.addAll(secretNames);
        }
        ArrayList<EditableObjectReference> secrets = new ArrayList<EditableObjectReference>();
        for (String secretName : secretNameSet) {
            EditableObjectReference secretRef = ((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName(secretName)).build();
            secrets.add(secretRef);
        }
        if (!secrets.isEmpty() || this.createServiceAccount) {
            if (Strings.isNullOrBlank((String)this.serviceAccount)) {
                this.serviceAccount = this.getProject().getArtifactId();
            }
            ((BaseKubernetesListFluent.ServiceAccountItemsNested)((BaseKubernetesListFluent.ServiceAccountItemsNested)((ServiceAccountFluent.MetadataNested)builder.addNewServiceAccountItem().withNewMetadata().withName(this.serviceAccount)).endMetadata()).withSecrets(secrets)).endServiceAccountItem();
            return true;
        }
        return false;
    }

    protected void addServiceConstraints(KubernetesListBuilder builder, List<Volume> volumes, boolean containerPrivileged) {
        boolean hostVolume;
        if (this.generateSecurityContextConstraints && ((hostVolume = this.hasHostVolume(volumes)) || containerPrivileged)) {
            ((BaseKubernetesListFluent.SecurityContextConstraintsItemsNested)((BaseKubernetesListFluent.SecurityContextConstraintsItemsNested)((SecurityContextConstraintsFluent.SeLinuxContextNested)((BaseKubernetesListFluent.SecurityContextConstraintsItemsNested)((SecurityContextConstraintsFluent.RunAsUserNested)((BaseKubernetesListFluent.SecurityContextConstraintsItemsNested)((BaseKubernetesListFluent.SecurityContextConstraintsItemsNested)((BaseKubernetesListFluent.SecurityContextConstraintsItemsNested)((SecurityContextConstraintsFluent.MetadataNested)builder.addNewSecurityContextConstraintsItem().withNewMetadata().withName(this.serviceAccount)).endMetadata()).withAllowHostDirVolumePlugin(Boolean.valueOf(hostVolume))).withAllowPrivilegedContainer(Boolean.valueOf(containerPrivileged))).withNewRunAsUser().withType("RunAsAny")).endRunAsUser()).withNewSeLinuxContext().withType("RunAsAny")).endSeLinuxContext()).withUsers(new String[]{"system:serviceaccount:" + this.getNamespace() + ":" + this.serviceAccount})).endSecurityContextConstraintsItem();
        }
    }

    protected boolean hasHostVolume(List<Volume> volumes) {
        if (volumes != null) {
            for (Volume volume : volumes) {
                HostPathVolumeSource hostPath = volume.getHostPath();
                if (hostPath == null || !Strings.isNotBlank((String)hostPath.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> parseSecretNames(String value) {
        ArrayList<String> answer = new ArrayList<String>();
        String[] split = value.split("\\[|\\]");
        if (split != null && split.length > 0) {
            for (int i = 0; i < split.length; i += 2) {
                String name = split[i];
                if (name.startsWith(",")) {
                    name = name.substring(1);
                }
                JsonMojo.splitCommas(name, answer);
            }
        } else {
            JsonMojo.splitCommas(value, answer);
        }
        return answer;
    }

    private static void splitCommas(String value, List<String> answer) {
        String[] split = value.split(",");
        if (split != null && split.length > 0) {
            answer.addAll(Arrays.asList(split));
        } else {
            answer.add(value);
        }
    }

    protected void configureTemplateDescriptionAndIcon(Template template, String iconUrl) {
        Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)template);
        this.addDocumentationAnnotations(template, annotations);
        if (Strings.isNotBlank((String)iconUrl)) {
            annotations.put(this.getTemplateKey(template, "iconUrl"), iconUrl);
        }
    }

    protected String getTemplateKey(Template template, String key) {
        String name = KubernetesHelper.getName((HasMetadata)template);
        if (Strings.isNullOrBlank((String)name)) {
            name = this.getProject().getArtifactId();
        }
        return "fabric8." + name + "/" + key;
    }

    protected void addDocumentationAnnotations(Template template, Map<String, String> annotations) {
        try {
            this.copySummaryText(this.templateTempDir);
            this.copyReadMe(this.templateTempDir);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to copy documentation: " + e), (Throwable)e);
        }
        File summary = new File(this.templateTempDir, "Summary.md");
        if (summary.exists() && summary.isFile()) {
            try {
                String text = Files.toString((File)summary);
                annotations.put(this.getTemplateKey(template, "summary"), text);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to load " + summary + ". " + e), (Throwable)e);
            }
        }
        String description = null;
        File readme = new File(this.templateTempDir, "ReadMe.md");
        if (readme.exists() && readme.isFile()) {
            try {
                description = Files.toString((File)readme);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to load " + readme + ". " + e), (Throwable)e);
            }
        }
        if (description == null) {
            description = this.getProject().getDescription();
        }
        if (Strings.isNotBlank(description)) {
            annotations.put(DESCRIPTION, description);
        }
    }

    protected String getIconUrl() {
        String embeddedIcon;
        String answer = this.iconUrl;
        if (Strings.isNullOrBlank((String)answer)) {
            try {
                if (this.templateTempDir != null) {
                    this.templateTempDir.mkdirs();
                    File iconFile = this.copyIconToFolder(this.templateTempDir);
                    if (iconFile == null) {
                        this.copyAppConfigFiles(this.templateTempDir, this.appConfigDir);
                        for (String ext : ICON_EXTENSIONS) {
                            File file = new File(this.templateTempDir, "icon" + ext);
                            if (!file.exists() || !file.isFile()) continue;
                            iconFile = file;
                            break;
                        }
                    }
                    if (iconFile != null) {
                        answer = this.convertIconFileToURL(iconFile);
                    }
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to load icon file: " + e), (Throwable)e);
            }
        }
        if (Strings.isNullOrBlank((String)answer) && (embeddedIcon = this.embeddedIconsInConsole(this.iconRef, "img/icons/")) != null) {
            return embeddedIcon;
        }
        if (Strings.isNullOrBlank((String)answer)) {
            this.getLog().debug((CharSequence)"No icon file found for this project");
        } else {
            this.getLog().info((CharSequence)("Icon URL: " + answer));
        }
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String convertIconFileToURL(File iconFile) throws IOException {
        long length = iconFile.length();
        int sizeK = Math.round(length / 1024L);
        byte[] bytes = Files.readBytes((File)iconFile);
        byte[] encoded = Base64Encoder.encode((byte[])bytes);
        int base64SizeK = Math.round(encoded.length / 1024);
        if (base64SizeK < this.maximumDataUrlSizeK) {
            String mimeType = Files.guessMediaType((File)iconFile);
            return "data:" + mimeType + ";charset=UTF-8;base64," + new String(encoded);
        }
        File iconSourceFile = new File(this.appConfigDir, iconFile.getName());
        if (iconSourceFile.exists()) {
            String url;
            Scm scm;
            File rootProjectFolder = this.getRootProjectFolder();
            if (rootProjectFolder == null) return null;
            String relativePath = Files.getRelativePath((File)rootProjectFolder, (File)iconSourceFile);
            String relativeParentPath = Files.getRelativePath((File)rootProjectFolder, (File)this.getProject().getBasedir());
            String urlPrefix = this.iconUrlPrefix;
            if (Strings.isNullOrBlank((String)urlPrefix) && (scm = this.getProject().getScm()) != null && (url = scm.getUrl()) != null) {
                String[] prefixes;
                for (String prefix : prefixes = new String[]{"http://github.com/", "https://github.com/"}) {
                    if (!url.startsWith(prefix)) continue;
                    url = URLUtils.pathJoin((String[])new String[]{"https://cdn.rawgit.com/", url.substring(prefix.length())});
                    break;
                }
                if (url.endsWith(relativeParentPath)) {
                    url = url.substring(0, url.length() - relativeParentPath.length());
                }
                urlPrefix = url;
            }
            if (!Strings.isNullOrBlank((String)urlPrefix)) return URLUtils.pathJoin((String[])new String[]{urlPrefix, this.iconBranch, relativePath});
            this.getLog().warn((CharSequence)"No iconUrlPrefix defined or could be found via SCM in the pom.xml so cannot add an icon URL!");
            return null;
        } else {
            String embeddedIcon = this.embeddedIconsInConsole(this.iconRef, "img/icons/");
            if (embeddedIcon != null) {
                return embeddedIcon;
            }
            this.getLog().warn((CharSequence)("Cannot find url for icon to use " + this.iconUrl));
        }
        return null;
    }

    protected String embeddedIconsInConsole(String iconRef, String prefix) {
        if (iconRef == null) {
            return null;
        }
        if (iconRef.startsWith("icons/")) {
            iconRef = iconRef.substring(6);
        }
        if (iconRef.contains("fabric8")) {
            return "img/fabric8_icon.svg";
        }
        if (iconRef.contains("activemq")) {
            return prefix + "activemq.svg";
        }
        if (iconRef.contains("apiman")) {
            return prefix + "apiman.png";
        }
        if (iconRef.contains("api-registry")) {
            return prefix + "api-registry.svg";
        }
        if (iconRef.contains("brackets")) {
            return prefix + "brackets.svg";
        }
        if (iconRef.contains("camel")) {
            return prefix + "camel.svg";
        }
        if (iconRef.contains("chaos-monkey")) {
            return prefix + "chaos-monkey.png";
        }
        if (iconRef.contains("docker-registry")) {
            return prefix + "docker-registry.png";
        }
        if (iconRef.contains("elasticsearch")) {
            return prefix + "elasticsearch.png";
        }
        if (iconRef.contains("fluentd")) {
            return prefix + "fluentd.png";
        }
        if (iconRef.contains("forge")) {
            return prefix + "forge.svg";
        }
        if (iconRef.contains("gerrit")) {
            return prefix + "gerrit.png";
        }
        if (iconRef.contains("gitlab")) {
            return prefix + "gitlab.svg";
        }
        if (iconRef.contains("gogs")) {
            return prefix + "gogs.png";
        }
        if (iconRef.contains("grafana")) {
            return prefix + "grafana.png";
        }
        if (iconRef.contains("hubot-irc")) {
            return prefix + "hubot-irc.png";
        }
        if (iconRef.contains("hubot-letschat")) {
            return prefix + "hubot-letschat.png";
        }
        if (iconRef.contains("hubot-notifier")) {
            return prefix + "hubot-notifier.png";
        }
        if (iconRef.contains("hubot-slack")) {
            return prefix + "hubot-slack.png";
        }
        if (iconRef.contains("image-linker")) {
            return prefix + "image-linker.svg";
        }
        if (iconRef.contains("javascript")) {
            return prefix + "javascript.png";
        }
        if (iconRef.contains("java")) {
            return prefix + "java.svg";
        }
        if (iconRef.contains("jenkins")) {
            return prefix + "jenkins.svg";
        }
        if (iconRef.contains("jetty")) {
            return prefix + "jetty.svg";
        }
        if (iconRef.contains("karaf")) {
            return prefix + "karaf.svg";
        }
        if (iconRef.contains("keycloak")) {
            return prefix + "keycloak.svg";
        }
        if (iconRef.contains("kibana")) {
            return prefix + "kibana.svg";
        }
        if (iconRef.contains("kiwiirc")) {
            return prefix + "kiwiirc.png";
        }
        if (iconRef.contains("letschat")) {
            return prefix + "letschat.png";
        }
        if (iconRef.contains("mule")) {
            return prefix + "mule.svg";
        }
        if (iconRef.contains("nexus")) {
            return prefix + "nexus.png";
        }
        if (iconRef.contains("node")) {
            return prefix + "node.svg";
        }
        if (iconRef.contains("orion")) {
            return prefix + "orion.png";
        }
        if (iconRef.contains("prometheus")) {
            return prefix + "prometheus.png";
        }
        if (iconRef.contains("django") || iconRef.contains("python")) {
            return prefix + "python.png";
        }
        if (iconRef.contains("spring-boot")) {
            return prefix + "spring-boot.svg";
        }
        if (iconRef.contains("taiga")) {
            return prefix + "taiga.png";
        }
        if (iconRef.contains("tomcat")) {
            return prefix + "tomcat.svg";
        }
        if (iconRef.contains("tomee")) {
            return prefix + "tomee.svg";
        }
        if (iconRef.contains("vertx")) {
            return prefix + "vertx.svg";
        }
        if (iconRef.contains("wildfly")) {
            return prefix + "wildfly.svg";
        }
        if (iconRef.contains("weld")) {
            return prefix + "weld.svg";
        }
        if (iconRef.contains("zipkin")) {
            return prefix + "zipkin.png";
        }
        return null;
    }

    protected Probe getLivenessProbe() {
        return this.getProbe("fabric8.livenessProbe");
    }

    protected Probe getReadinessProbe() {
        return this.getProbe("fabric8.readinessProbe");
    }

    protected Probe getProbe(String prefix) {
        HTTPGetAction httpGetAction;
        Integer timeoutSeconds;
        Probe probe = new Probe();
        Properties properties = this.getProjectAndFabric8Properties(this.getProject());
        Integer initialDelaySeconds = PropertiesHelper.getInteger((Properties)properties, (String)(prefix + ".initialDelaySeconds"));
        if (initialDelaySeconds != null) {
            probe.setInitialDelaySeconds(initialDelaySeconds);
        }
        if ((timeoutSeconds = PropertiesHelper.getInteger((Properties)properties, (String)(prefix + ".timeoutSeconds"))) != null) {
            probe.setTimeoutSeconds(timeoutSeconds);
        }
        if ((httpGetAction = this.getHTTPGetAction(prefix, properties)) != null) {
            probe.setHttpGet(httpGetAction);
            return probe;
        }
        ExecAction execAction = this.getExecAction(prefix, properties);
        if (execAction != null) {
            probe.setExec(execAction);
            return probe;
        }
        TCPSocketAction tcpSocketAction = this.getTCPSocketAction(prefix, properties);
        if (tcpSocketAction != null) {
            probe.setTcpSocket(tcpSocketAction);
            return probe;
        }
        return null;
    }

    private HTTPGetAction getHTTPGetAction(String prefix, Properties properties) {
        HTTPGetAction action = null;
        String httpGetPath = properties.getProperty(prefix + ".httpGet.path");
        String httpGetPort = properties.getProperty(prefix + ".httpGet.port");
        String httpGetHost = properties.getProperty(prefix + ".httpGet.host");
        String httpGetScheme = properties.getProperty(prefix + ".httpGet.scheme");
        if (Strings.isNotBlank((String)httpGetPath)) {
            action = new HTTPGetAction();
            action.setPath(httpGetPath);
            action.setHost(httpGetHost);
            if (Strings.isNotBlank((String)httpGetScheme)) {
                action.setScheme(httpGetScheme.toUpperCase());
            }
            if (Strings.isNotBlank((String)httpGetPort)) {
                IntOrString httpGetPortIntOrString = KubernetesHelper.createIntOrString((String)httpGetPort);
                action.setPort(httpGetPortIntOrString);
            }
        }
        return action;
    }

    private TCPSocketAction getTCPSocketAction(String prefix, Properties properties) {
        TCPSocketAction action = null;
        String port = properties.getProperty(prefix + ".port");
        if (Strings.isNotBlank((String)port)) {
            IntOrString portObj = new IntOrString();
            try {
                Integer portInt = Integer.parseInt(port);
                portObj.setIntVal(portInt);
            }
            catch (NumberFormatException e) {
                portObj.setStrVal(port);
            }
            action = new TCPSocketAction(portObj);
        }
        return action;
    }

    private ExecAction getExecAction(String prefix, Properties properties) {
        List<String> splitCommandLine;
        ExecAction action = null;
        String execCmd = properties.getProperty(prefix + ".exec");
        if (Strings.isNotBlank((String)execCmd) && !(splitCommandLine = Commandline.translateCommandline(execCmd)).isEmpty()) {
            action = new ExecAction(splitCommandLine);
        }
        return action;
    }

    public Boolean getContainerPrivileged() {
        return this.containerPrivileged;
    }

    public String getImagePullPolicy() {
        MavenProject project = this.getProject();
        String pullPolicy = this.imagePullPolicy;
        if (project != null) {
            String version = project.getVersion();
            if (Strings.isNullOrBlank((String)pullPolicy) && version != null && version.endsWith("SNAPSHOT")) {
                pullPolicy = this.imagePullPolicySnapshot;
            }
        }
        return pullPolicy;
    }

    public String getKubernetesContainerName() {
        if (Strings.isNullOrBlank((String)this.kubernetesContainerName)) {
            String[] paths;
            String groupPrefix = null;
            MavenProject project = this.getProject();
            String imageName = this.getDockerImage();
            if (Strings.isNotBlank((String)imageName) && (paths = imageName.split("/")) != null) {
                if (paths.length == 2) {
                    groupPrefix = paths[0];
                } else if (paths.length == 3) {
                    groupPrefix = paths[1];
                }
            }
            if (Strings.isNullOrBlank(groupPrefix)) {
                groupPrefix = project.getGroupId();
            }
            this.kubernetesContainerName = groupPrefix + "-" + project.getArtifactId();
        }
        return this.kubernetesContainerName;
    }

    public void setKubernetesContainerName(String kubernetesContainerName) {
        this.kubernetesContainerName = kubernetesContainerName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCombineProjectName() {
        return this.combineProjectName;
    }

    public void setCombineProjectName(String combineProjectName) {
        this.combineProjectName = combineProjectName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Map<String, Integer> getDefaultContainerPortMap() {
        if (this.defaultContainerPortMap == null) {
            this.defaultContainerPortMap = new HashMap<String, Integer>();
        }
        if (this.defaultContainerPortMap.isEmpty()) {
            this.defaultContainerPortMap.put("jolokia", 8778);
            this.defaultContainerPortMap.put("web", 8080);
        }
        return this.defaultContainerPortMap;
    }

    public void setDefaultContainerPortMap(Map<String, Integer> defaultContainerPortMap) {
        this.defaultContainerPortMap = defaultContainerPortMap;
    }

    public List<ContainerPort> getContainerPorts() {
        if (this.containerPorts == null) {
            this.containerPorts = new ArrayList<ContainerPort>();
        }
        if (this.containerPorts.isEmpty()) {
            ContainerPort port;
            Integer portNumber;
            String portText;
            String name;
            HashMap<String, ContainerPort> portMap = new HashMap<String, ContainerPort>();
            Properties properties1 = this.getProjectAndFabric8Properties(this.getProject());
            Map hostPorts = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)FABRIC8_PORT_HOST_PREFIX);
            Properties properties = this.getProjectAndFabric8Properties(this.getProject());
            Map containerPortsMap = PropertiesHelper.findPropertiesWithPrefix((Properties)properties, (String)FABRIC8_PORT_CONTAINER_PREFIX);
            for (Map.Entry entry : containerPortsMap.entrySet()) {
                name = (String)entry.getKey();
                portText = (String)entry.getValue();
                portNumber = this.parsePort(portText, FABRIC8_PORT_CONTAINER_PREFIX + name);
                if (portNumber == null) continue;
                port = JsonMojo.getOrCreatePort(portMap, name);
                port.setContainerPort(portNumber);
                port.setName(name);
            }
            for (Map.Entry entry : hostPorts.entrySet()) {
                name = (String)entry.getKey();
                portText = (String)entry.getValue();
                portNumber = this.parsePort(portText, FABRIC8_PORT_HOST_PREFIX + name);
                if (portNumber == null) continue;
                port = JsonMojo.getOrCreatePort(portMap, name);
                port.setHostPort(portNumber);
                if (port.getContainerPort() != null) continue;
                port.setContainerPort(this.getDefaultContainerPortMap().get(name));
            }
            this.getLog().info((CharSequence)("Generated port mappings: " + portMap));
            this.getLog().debug((CharSequence)("from host ports: " + hostPorts));
            this.getLog().debug((CharSequence)("from containerPorts ports: " + this.containerPorts));
            this.containerPorts.addAll(portMap.values());
        }
        return this.containerPorts;
    }

    protected static ContainerPort getOrCreatePort(Map<String, ContainerPort> portMap, String name) {
        ContainerPort answer = portMap.get(name);
        if (answer == null) {
            answer = new ContainerPort();
            portMap.put(name, answer);
            answer.setName(name);
        }
        return answer;
    }

    private String buildServicePrefix(String name, String prefix, String suffix) {
        String servicePrefix = prefix;
        if (Strings.isNotBlank((String)name)) {
            servicePrefix = servicePrefix + "." + name;
        }
        return servicePrefix + "." + suffix;
    }

    private List<ServicePort> getServicePorts(String serviceName) throws MojoExecutionException {
        String tempServiceProtocol;
        Integer tempNodePort;
        String tempContainerPort;
        Integer tempPort;
        Object containerPort;
        String servicePortPrefix = this.buildServicePrefix(serviceName, "fabric8.service", "port");
        String serviceContainerPortPrefix = this.buildServicePrefix(serviceName, "fabric8.service", "containerPort");
        String serviceNodePortPrefix = this.buildServicePrefix(serviceName, "fabric8.service", "nodePort");
        String serviceProtocolPrefix = this.buildServicePrefix(serviceName, "fabric8.service", "protocol");
        Properties properties1 = this.getProjectAndFabric8Properties(this.getProject());
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        Map servicePortProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)(servicePortPrefix + "."));
        Map serviceContainerPortProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)(serviceContainerPortPrefix + "."));
        Map serviceNodePortProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)(serviceNodePortPrefix + "."));
        Map serviceProtocolProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)(serviceProtocolPrefix + "."));
        for (Map.Entry entry : servicePortProperties.entrySet()) {
            String portProtocol;
            IntOrString nodePortSpec;
            Integer nodePortInt;
            String name = (String)entry.getKey();
            String servicePortText = (String)entry.getValue();
            Integer servicePortNumber = this.parsePort(servicePortText, servicePortPrefix + name);
            if (servicePortNumber == null) continue;
            containerPort = (String)serviceContainerPortProperties.get(name);
            if (Strings.isNullOrBlank((String)containerPort)) {
                this.getLog().warn((CharSequence)("Missing container port for service - need to specify " + serviceContainerPortPrefix + name + " property"));
                continue;
            }
            ServicePort servicePort = new ServicePort();
            servicePort.setName(name);
            servicePort.setPort(servicePortNumber);
            IntOrString containerPortSpec = this.getPortSpec((String)containerPort, serviceContainerPortPrefix, name);
            servicePort.setTargetPort(containerPortSpec);
            String nodePort = (String)serviceNodePortProperties.get(name);
            if (nodePort != null && (nodePortInt = (nodePortSpec = this.getPortSpec(nodePort, serviceNodePortPrefix, name)).getIntVal()) != null) {
                servicePort.setNodePort(nodePortInt);
            }
            if ((portProtocol = (String)serviceProtocolProperties.get(name)) != null) {
                servicePort.setProtocol(portProtocol);
            }
            servicePorts.add(servicePort);
        }
        if (Strings.isNotBlank((String)serviceName)) {
            tempPort = this.parsePort(properties1.getProperty(servicePortPrefix), servicePortPrefix);
            tempContainerPort = properties1.getProperty(serviceContainerPortPrefix);
            tempNodePort = this.parsePort(properties1.getProperty(serviceNodePortPrefix), serviceNodePortPrefix);
            tempServiceProtocol = properties1.getProperty(serviceProtocolPrefix, "TCP");
        } else {
            tempPort = this.servicePort;
            tempContainerPort = this.serviceContainerPort;
            tempNodePort = this.serviceNodePort;
            tempServiceProtocol = this.serviceProtocol;
        }
        if (tempContainerPort != null || tempPort != null) {
            if (servicePorts.size() > 0) {
                throw new MojoExecutionException("Multi-port services must use the " + servicePortPrefix + "<name> format");
            }
            ServicePort actualServicePort = new ServicePort();
            containerPort = this.getPortSpec(tempContainerPort, serviceContainerPortPrefix, null);
            actualServicePort.setTargetPort(containerPort);
            actualServicePort.setPort(tempPort);
            if (tempNodePort != null) {
                actualServicePort.setNodePort(tempNodePort);
            }
            if (tempServiceProtocol != null) {
                actualServicePort.setProtocol(tempServiceProtocol);
                servicePorts.add(actualServicePort);
            }
        }
        return servicePorts;
    }

    private IntOrString getPortSpec(String portText, String portServicePrefix, String name) {
        Integer portNumber;
        IntOrString portSpec = new IntOrString();
        String portServiceName = portServicePrefix;
        if (name != null) {
            portServiceName = portServicePrefix + name;
        }
        if ((portNumber = this.parsePort(portText, portServiceName)) != null) {
            portSpec.setIntVal(portNumber);
        } else {
            portSpec.setStrVal(portText);
        }
        return portSpec;
    }

    protected static EnvVar getOrCreateEnv(Map<String, EnvVar> envMap, String name) {
        EnvVar answer = envMap.get(name);
        if (answer == null) {
            answer = new EnvVar();
            envMap.put(name, answer);
        }
        return answer;
    }

    protected Integer parsePort(String portText, String propertyName) {
        if (Strings.isNotBlank((String)portText)) {
            try {
                return Integer.parseInt(portText);
            }
            catch (NumberFormatException e) {
                this.getLog().debug((CharSequence)("Failed to parse port text: " + portText + " from maven property " + propertyName + ". " + e), (Throwable)e);
            }
        }
        return null;
    }

    public void setContainerPorts(List<ContainerPort> ports) {
        this.containerPorts = ports;
    }

    public void setServicePorts(List<ServicePort> ports) {
        this.servicePorts = ports;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        if (this.labels.isEmpty()) {
            this.labels = PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProjectAndFabric8Properties(this.getProject()), (String)"fabric8.label.", (Function)Strings.toLowerCaseFunction());
        }
        return this.labels;
    }

    public Map<String, String> getPodSpecAnnotations() throws MojoExecutionException {
        if (this.podSpecAnnotations == null) {
            this.podSpecAnnotations = this.loadAnnotations(this.podSpecAnnotationsFile, "fabric8.annotations.podSpec.", "PodSpec");
        }
        return this.podSpecAnnotations;
    }

    public Map<String, String> getRCAnnotations() throws MojoExecutionException {
        if (this.rcAnnotations == null) {
            this.rcAnnotations = this.loadAnnotations(this.rcAnnotationsFile, "fabric8.annotations.rc.", "RC");
        }
        return this.rcAnnotations;
    }

    public Map<String, String> getTemplateAnnotations() throws MojoExecutionException {
        if (this.templateAnnotations == null) {
            this.templateAnnotations = this.loadAnnotations(this.templateAnnotationsFile, "fabric8.annotations.template.", "Template");
        }
        return this.templateAnnotations;
    }

    public Map<String, String> getServiceAnnotations() throws MojoExecutionException {
        Map<String, String> serviceAnnotations = this.loadAnnotations(this.serviceAnnotationsFile, "fabric8.annotations.service.", "Service");
        return serviceAnnotations;
    }

    protected Map<String, String> loadAnnotations(File annotationsFile, String propertiesPrefix, String annotationsName) throws MojoExecutionException {
        Map answer = PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProjectAndFabric8Properties(this.getProject()), (String)propertiesPrefix, (Function)Strings.toLowerCaseFunction());
        if (annotationsFile != null && annotationsFile.exists() && annotationsFile.isFile()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(annotationsFile));
                Map fileAnnotations = PropertiesHelper.toMap((Properties)properties);
                answer.putAll(fileAnnotations);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load podSpecAnnotationsFile properties file " + this.podSpecAnnotationsFile + ". " + e, (Exception)e);
            }
        }
        HashMap<String, String> newAnswer = new HashMap<String, String>();
        for (String key : answer.keySet()) {
            int lastDot = key.lastIndexOf(".");
            if (!key.contains("/") && lastDot > 0) {
                String namespace = key.substring(0, lastDot);
                String name = key.substring(lastDot + 1);
                newAnswer.put(namespace + "/" + name, (String)answer.get(key));
                continue;
            }
            newAnswer.put(key, (String)answer.get(key));
        }
        return newAnswer;
    }

    public List<EnvVar> getEnvironmentVariables() throws MojoExecutionException {
        if (this.environmentVariables == null) {
            this.environmentVariables = new ArrayList<EnvVar>();
        }
        if (this.environmentVariables.isEmpty()) {
            HashMap<String, EnvVar> envMap = new HashMap<String, EnvVar>();
            Map<String, String> envs = this.getExportedEnvironmentVariables();
            for (Map.Entry<String, String> entry : envs.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (name == null) continue;
                EnvVar env = JsonMojo.getOrCreateEnv(envMap, name);
                env.setName(name);
                if (env.getValue() != null) continue;
                env.setValue(value);
            }
            this.getLog().info((CharSequence)("Generated env mappings: " + envMap));
            this.getLog().debug((CharSequence)("from envs: " + envs));
            this.environmentVariables.addAll(envMap.values());
        }
        if (this.includeNamespaceEnvVar) {
            this.environmentVariables.add((EnvVar)((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName(this.kubernetesNamespaceEnvVar)).withNewValueFrom().withNewFieldRef().withFieldPath("metadata.namespace")).endFieldRef()).endValueFrom()).build());
        }
        if (this.includePodEnvVar) {
            this.environmentVariables.add((EnvVar)((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName(this.kubernetesPodEnvVar)).withNewValueFrom().withNewFieldRef().withFieldPath("metadata.name")).endFieldRef()).endValueFrom()).build());
        }
        return this.environmentVariables;
    }

    public Map<String, String> getExportedEnvironmentVariables() throws MojoExecutionException {
        if (this.includeAllEnvironmentVariables) {
            try {
                JsonSchema schema = this.getEnvironmentVariableJsonSchema();
                TreeMap<String, String> answer = new TreeMap<String, String>();
                Map<String, JsonSchemaProperty> properties = schema.getProperties();
                Set<Map.Entry<String, JsonSchemaProperty>> entries = properties.entrySet();
                for (Map.Entry<String, JsonSchemaProperty> entry : entries) {
                    String name = entry.getKey();
                    String value = entry.getValue().getDefaultValue();
                    if (value == null) {
                        value = "";
                    }
                    answer.put(name, value);
                }
                Map<String, String> mavenEnvVars = this.getEnvironmentVariableProperties();
                answer.putAll(mavenEnvVars);
                return answer;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load environment variable json schema files: " + e, (Exception)e);
            }
        }
        return this.getEnvironmentVariableProperties();
    }

    public List<VolumeMount> getVolumeMounts() {
        ArrayList<VolumeMount> volumeMount = new ArrayList<VolumeMount>();
        MavenProject project = this.getProject();
        for (Map.Entry<Object, Object> entry : this.getProjectAndFabric8Properties(project).entrySet()) {
            String s;
            Matcher m;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(m = VOLUME_PATTERN.matcher(s = (String)key)).matches()) continue;
            String name = m.group(NAME);
            String type = m.group(ATTRIBUTE_TYPE);
            if (!type.equals(VOLUME_MOUNT_PATH)) continue;
            String path = String.valueOf(entry.getValue());
            volumeMount.add((VolumeMount)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(name)).withMountPath(path)).withReadOnly(Boolean.valueOf(false))).build());
        }
        return volumeMount;
    }

    public List<Volume> getVolumes() {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        MavenProject project = this.getProject();
        Properties properties = this.getProjectAndFabric8Properties(project);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String s;
            Matcher m;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(m = VOLUME_PATTERN.matcher(s = (String)key)).matches()) continue;
            String name = m.group(NAME);
            String type = m.group(ATTRIBUTE_TYPE);
            VolumeType volumeType = VolumeType.typeFor(type);
            if (volumeType == null) continue;
            volumes.add(volumeType.fromProperties(name, properties));
        }
        return volumes;
    }

    public Template getTemplate() throws MojoExecutionException {
        ArrayList<io.fabric8.openshift.api.model.Parameter> parameters = new ArrayList<io.fabric8.openshift.api.model.Parameter>();
        MavenProject project = this.getProject();
        Properties projectProperties = this.getProjectAndFabric8Properties(this.getProject());
        HashSet<String> paramNames = new HashSet<String>();
        if (this.templateParametersPropertiesFile != null && this.templateParametersPropertiesFile.isFile() && this.templateParametersPropertiesFile.exists()) {
            String valuePostfix = ".value";
            String descriptionPostfix = ".description";
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(this.templateParametersPropertiesFile));
                Set<Object> keys = properties.keySet();
                Properties prefixedProperties = new Properties();
                for (Object key : keys) {
                    if (key == null) continue;
                    String name = key.toString();
                    String value = properties.getProperty(name);
                    prefixedProperties.put("fabric8.parameter." + name, value);
                }
                this.loadParametersFromProperties(prefixedProperties, parameters, paramNames);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load templateParameters properties file " + this.templateParametersPropertiesFile + ". " + e, (Exception)e);
            }
        }
        this.loadParametersFromProperties(projectProperties, parameters, paramNames);
        String templateName = projectProperties.containsKey(TEMPLATE_NAME) ? String.valueOf(projectProperties.getProperty(TEMPLATE_NAME)) : project.getArtifactId();
        return ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(templateName)).withAnnotations(this.getTemplateAnnotations())).endMetadata()).withParameters(parameters)).build();
    }

    protected void loadParametersFromProperties(Properties properties, List<io.fabric8.openshift.api.model.Parameter> parameters, Set<String> paramNames) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name;
            String s;
            Matcher m;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(m = PARAM_PATTERN.matcher(s = (String)key)).matches() || !paramNames.add(name = m.group(NAME))) continue;
            String value = properties.getProperty(String.format(PARAMETER_PROPERTY, name, VALUE));
            String from = properties.getProperty(String.format(PARAMETER_PROPERTY, name, FROM));
            String description = properties.getProperty(String.format(PARAMETER_PROPERTY, name, DESCRIPTION));
            String generate = properties.getProperty(String.format(PARAMETER_PROPERTY, name, GENERATE));
            if (Strings.isNullOrBlank((String)value) && Strings.isNullOrBlank((String)from)) {
                value = properties.getProperty(String.format(PARAMETER_NAME_PREFIX, name));
            }
            this.getLog().info((CharSequence)("Found Template parameter: " + name + this.labelValueOrBlank(VALUE, value) + this.labelValueOrBlank(FROM, from) + this.labelValueOrBlank(GENERATE, generate) + this.labelValueOrBlank(DESCRIPTION, description)));
            parameters.add((io.fabric8.openshift.api.model.Parameter)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)new ParameterBuilder().withName(name)).withFrom(from)).withValue(value)).withGenerate(generate)).withDescription(description)).build());
        }
    }

    private String labelValueOrBlank(String label, String value) {
        if (Strings.isNotBlank((String)value)) {
            return " " + label + ": " + value;
        }
        return "";
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    protected static void addIfNotDefined(Map<String, Object> variables, String key, String value) {
        if (!variables.containsKey(key)) {
            variables.put(key, value);
        }
    }
}

