/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.utils.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractNamespacedMojo
extends AbstractMojo {
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.domain", defaultValue="${env.KUBERNETES_DOMAIN}")
    protected String routeDomain;
    @Parameter(property="fabric8.apply.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    private KubernetesClient kubernetes;

    public KubernetesClient getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = new KubernetesClient();
        }
        if (Strings.isNotBlank((String)this.namespace)) {
            this.kubernetes.setNamespace(this.namespace);
        }
        return this.kubernetes;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.getKubernetes());
        controller.setThrowExceptionOnError(this.failOnError);
        controller.setRecreateMode(this.recreate);
        this.getLog().debug((CharSequence)("Using recreate mode: " + this.recreate));
        return controller;
    }

    protected String getNamespace() {
        return this.getKubernetes().getNamespace();
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    public void setRouteDomain(String routeDomain) {
        this.routeDomain = routeDomain;
    }

    public boolean isRecreate() {
        return this.recreate;
    }

    public void setRecreate(boolean recreate) {
        this.recreate = recreate;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

