/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.databind.node.TextNode;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder;
import io.fabric8.kubernetes.internal.HasMetadataComparator;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemaProperty;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.DomHelper;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Mojo(name="migrate", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.INSTALL)
public class MigrateMojo
extends AbstractFabric8Mojo {
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.migrate.outputDir", defaultValue="${basedir}/src/main/fabric8")
    protected File outputDir;
    private Map<String, String> kindAliases = new HashMap<String, String>();
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.migrate.outputDir", defaultValue="true")
    private boolean updatePom;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.migrate.updateExecutions", defaultValue="true")
    private boolean updateExecutions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        File json = this.getKubernetesJson();
        if (Files.isFile((File)json)) {
            try {
                String[] stringArray;
                Object dto = KubernetesHelper.loadJson((File)json);
                if (dto == null) {
                    throw new MojoFailureException("Cannot load kubernetes json: " + json);
                }
                TreeSet<ConfigMap> entities = new TreeSet<ConfigMap>((Comparator<ConfigMap>)new HasMetadataComparator());
                ConfigMap parameterConfigMap = null;
                if (dto instanceof Template) {
                    List parameters;
                    Template template = (Template)dto;
                    List list = template.getObjects();
                    if (list != null) {
                        entities.addAll(list);
                    }
                    if ((parameters = template.getParameters()) != null && parameters.size() > 0) {
                        JsonSchema schema = new JsonSchema();
                        TreeMap<String, String> configMapData = new TreeMap<String, String>();
                        for (Parameter parameter : parameters) {
                            String description;
                            Boolean required;
                            String name = parameter.getName();
                            String value = parameter.getValue();
                            if (value == null) {
                                value = "";
                            }
                            String key = this.convertToConfigMapKey(name);
                            JsonSchemaProperty property = schema.getOrCreateProperty(key);
                            String generate = parameter.getGenerate();
                            if (Strings.isNotBlank((String)generate)) {
                                property.setGenerate(generate);
                            }
                            if ((required = parameter.getRequired()) != null && required.booleanValue()) {
                                schema.addRequired(name);
                            }
                            if (Strings.isNotBlank((String)(description = parameter.getDescription()))) {
                                property.setDescription(description);
                            }
                            if (Strings.isNotBlank((String)value)) {
                                property.setDefaultValue(value);
                            }
                            configMapData.put(key, value);
                        }
                        String jsonSchemaJson = KubernetesHelper.toPrettyJson((Object)schema);
                        this.getLog().info((CharSequence)("Generated ConfigMap JSON Schema: " + jsonSchemaJson));
                        parameterConfigMap = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadataLike(template.getMetadata()).addToAnnotations("fabric8.io/json-schema", jsonSchemaJson)).endMetadata()).build();
                        parameterConfigMap.setData(configMapData);
                        this.migrateEntity((HasMetadata)parameterConfigMap, parameterConfigMap);
                        entities.add(parameterConfigMap);
                    }
                } else {
                    entities.addAll(KubernetesHelper.toItemList((Object)dto));
                }
                this.outputDir.mkdirs();
                for (HasMetadata hasMetadata : entities) {
                    HasMetadata hasMetadata2 = this.migrateEntity(hasMetadata, parameterConfigMap);
                    String name = KubernetesHelper.getName((HasMetadata)hasMetadata2);
                    String kind = this.shortenKind(KubernetesHelper.getKind((HasMetadata)hasMetadata2).toLowerCase());
                    File outFile = new File(this.outputDir, name + "-" + kind + ".yml");
                    if (hasMetadata2 instanceof ConfigMap || hasMetadata2 instanceof Secret) {
                        KubernetesHelper.saveYaml((Object)hasMetadata2, (File)outFile);
                    } else {
                        KubernetesHelper.saveYamlNotEmpty((HasMetadata)hasMetadata2, (File)outFile);
                    }
                    this.getLog().info((CharSequence)("Generated migration file: " + outFile));
                }
                this.tryAddFilesToGit(".");
                File basedir = this.getProject().getBasedir();
                if (this.updatePom) {
                    this.updatePomFile(new File(basedir, "pom.xml"));
                }
                for (String fileName : stringArray = new String[]{"uses.fmp2", "src/main/fabric8/templateParameters.properties", "src/main/fabric8/env.properties", "src/main/fabric8/kubernetes.json"}) {
                    File file = new File(basedir, fileName);
                    if (!file.exists()) continue;
                    file.delete();
                }
                this.deleteModelProcessorJavaFiles(new File(basedir, "src/main/java"));
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private void deleteModelProcessorJavaFiles(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    String name = file.getName().toLowerCase();
                    if (!name.endsWith(".java")) continue;
                    try {
                        String text = IOHelpers.readFully((File)file);
                        if (!text.contains("@KubernetesModelProcessor")) continue;
                        file.delete();
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Failed to load file " + file + ". " + e), (Throwable)e);
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.deleteModelProcessorJavaFiles(file);
            }
        }
    }

    private void tryAddFilesToGit(String filePattern) {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        try {
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).findGitDir()).build();
            Git git = new Git(repository);
            git.add().addFilepattern(filePattern).call();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to add generated files to the git repository: " + e), (Throwable)e);
        }
    }

    protected void updatePomFile(File pom) throws MojoExecutionException {
        NodeList childNodes;
        Document doc;
        boolean updated = false;
        try {
            doc = XmlUtils.parseDoc((File)pom);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to parse pom " + pom + ". " + e), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Element properties = DomHelper.firstChild((Element)doc.getDocumentElement(), (String)"properties");
        if (properties != null && (childNodes = properties.getChildNodes()) != null) {
            boolean lastRemoved = false;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item instanceof Element) {
                    Element property = (Element)item;
                    String tagName = property.getTagName();
                    String value = property.getTextContent();
                    propertyMap.put(tagName, value);
                    if (!this.removePropertyName(tagName, value)) continue;
                    properties.removeChild(property);
                    --i;
                    lastRemoved = true;
                    updated = true;
                    continue;
                }
                if (!(item instanceof Text)) continue;
                Text text = (Text)item;
                if (!lastRemoved) continue;
                properties.removeChild(text);
                --i;
                lastRemoved = false;
            }
        }
        if (this.removeProfiles(doc, "docker-build", "docker-push", "jube")) {
            updated = true;
        }
        if (this.removePlugin(doc, "io.fabric8.jube", "jube-maven-plugin")) {
            updated = true;
        }
        if (this.migrateDockerMavenPluginConfiguration(doc, propertyMap)) {
            updated = true;
        }
        if (updated) {
            this.getLog().info((CharSequence)("Updating the pom " + pom));
            try {
                DomHelper.save((Document)doc, (File)pom);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to update pom " + pom + ". " + e), (Throwable)e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private boolean removeProfiles(Document doc, String ... profileIds) {
        NodeList childNodes;
        HashSet<String> profileIdSet = new HashSet<String>(Arrays.asList(profileIds));
        boolean updated = false;
        Element profiles = DomHelper.firstChild((Element)doc.getDocumentElement(), (String)"profiles");
        if (profiles != null && (childNodes = profiles.getChildNodes()) != null) {
            boolean lastRemoved = false;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item instanceof Element) {
                    String id;
                    Element profile = (Element)item;
                    Element idElement = DomHelper.firstChild((Element)profile, (String)"id");
                    if (idElement == null || (id = idElement.getTextContent()) == null || !profileIdSet.contains(id)) continue;
                    profiles.removeChild(profile);
                    --i;
                    lastRemoved = true;
                    updated = true;
                    continue;
                }
                if (!(item instanceof Text)) continue;
                Text text = (Text)item;
                if (!lastRemoved) continue;
                profiles.removeChild(text);
                --i;
                lastRemoved = false;
            }
        }
        return updated;
    }

    private boolean migrateDockerMavenPluginConfiguration(Document doc, Map<String, String> propertyMap) {
        Element fmpPlugin;
        boolean updated = false;
        Element configuration = null;
        Element dmpPlugin = this.findPlugin(doc, "io.fabric8", "docker-maven-plugin");
        if (dmpPlugin != null) {
            Node nextSibling;
            configuration = DomHelper.firstChild((Element)dmpPlugin, (String)"configuration");
            if (configuration != null) {
                DomHelper.detach((Node)configuration);
            }
            if ((nextSibling = dmpPlugin.getNextSibling()) instanceof TextNode) {
                DomHelper.detach((Node)nextSibling);
            }
            DomHelper.detach((Node)dmpPlugin);
            updated = true;
        }
        if ((fmpPlugin = this.findPlugin(doc, "io.fabric8", "fabric8-maven-plugin")) == null) {
            if (configuration != null) {
                fmpPlugin = this.findOrAddPlugin(doc, "io.fabric8", "fabric8-maven-plugin", "${fabric8.maven.plugin.version}", configuration);
                updated = true;
            }
        } else if (configuration != null) {
            Element oldConfig = DomHelper.firstChild((Element)fmpPlugin, (String)"configuration");
            DomHelper.detach((Node)oldConfig);
            fmpPlugin.appendChild(configuration);
            if (oldConfig == null) {
                fmpPlugin.appendChild(doc.createTextNode("\n      "));
            }
        }
        if (this.updateExecutions && fmpPlugin != null) {
            String[] goalNames;
            Element executions = DomHelper.firstChild((Element)fmpPlugin, (String)"executions");
            if (executions == null) {
                executions = DomHelper.addChildElement((Node)fmpPlugin, (String)"executions");
                fmpPlugin.appendChild(doc.createTextNode("\n      "));
            } else {
                DomHelper.removeChildren((Element)executions);
            }
            executions.appendChild(doc.createTextNode("\n        "));
            Element execution = DomHelper.addChildElement((Node)executions, (String)"execution");
            execution.appendChild(doc.createTextNode("\n          "));
            DomHelper.addChildElement((Node)execution, (String)"id", (String)"fmp");
            execution.appendChild(doc.createTextNode("\n          "));
            Element goals = DomHelper.addChildElement((Node)execution, (String)"goals");
            execution.appendChild(doc.createTextNode("\n          "));
            for (String goalName : goalNames = new String[]{"resource", "helm", "build"}) {
                goals.appendChild(doc.createTextNode("\n            "));
                DomHelper.addChildElement((Node)goals, (String)"goal", (String)goalName);
            }
            goals.appendChild(doc.createTextNode("\n          "));
            executions.appendChild(doc.createTextNode("\n      "));
            updated = true;
        }
        return updated;
    }

    private boolean removePlugin(Document doc, String groupId, String artifactId) {
        Element plugin = this.findPlugin(doc, groupId, artifactId);
        if (plugin != null) {
            Node nextSibling = plugin.getNextSibling();
            DomHelper.detach((Node)plugin);
            if (nextSibling instanceof TextNode) {
                DomHelper.detach((Node)nextSibling);
            }
            return true;
        }
        return false;
    }

    private Element findOrAddPlugin(Document doc, String groupId, String artifactId, String version, Element configuration) {
        Element plugins;
        Element plugin = this.findPlugin(doc, groupId, artifactId);
        if (plugin != null) {
            return plugin;
        }
        Element documentElement = doc.getDocumentElement();
        Element build = DomHelper.firstChild((Element)documentElement, (String)"build");
        if (build == null) {
            build = DomHelper.addChildElement((Node)documentElement, (String)"build");
        }
        if ((plugins = DomHelper.firstChild((Element)build, (String)"plugins")) == null) {
            plugins = DomHelper.addChildElement((Node)build, (String)"plugins");
        }
        plugins.appendChild(doc.createTextNode("\n      "));
        plugin = DomHelper.addChildElement((Node)plugins, (String)"plugin");
        plugin.appendChild(doc.createTextNode("\n        "));
        DomHelper.addChildElement((Node)plugin, (String)"groupId", (String)groupId);
        plugin.appendChild(doc.createTextNode("\n        "));
        DomHelper.addChildElement((Node)plugin, (String)"artifactId", (String)artifactId);
        plugin.appendChild(doc.createTextNode("\n        "));
        DomHelper.addChildElement((Node)plugin, (String)"version", (String)version);
        plugin.appendChild(doc.createTextNode("\n        "));
        if (configuration != null) {
            plugin.appendChild(configuration);
        }
        plugin.appendChild(doc.createTextNode("\n      "));
        plugins.appendChild(doc.createTextNode("\n      "));
        return plugin;
    }

    private Element findPlugin(Document doc, String groupId, String artifactId) {
        NodeList childNodes;
        Element plugins;
        Element build = DomHelper.firstChild((Element)doc.getDocumentElement(), (String)"build");
        if (build != null && (plugins = DomHelper.firstChild((Element)build, (String)"plugins")) != null && (childNodes = plugins.getChildNodes()) != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element plugin;
                Node item = childNodes.item(i);
                if (!(item instanceof Element) || !Objects.equals(DomHelper.firstChildTextContent((Element)(plugin = (Element)item), (String)"groupId"), groupId) || !Objects.equals(DomHelper.firstChildTextContent((Element)plugin, (String)"artifactId"), artifactId)) continue;
                return plugin;
            }
        }
        return null;
    }

    private boolean removePropertyName(String tagName, String value) {
        return tagName.startsWith("docker.port.") || tagName.startsWith("fabric8.") || tagName.equals("docker.maven.plugin.version") || tagName.equals("jube.version");
    }

    protected String convertToConfigMapKey(String name) {
        return name.toLowerCase().replace('_', '-');
    }

    protected HasMetadata migrateEntity(HasMetadata entity, ConfigMap parameterConfigMap) {
        this.migrateMetadata(entity.getMetadata());
        if (entity instanceof ReplicationController) {
            ReplicationController rc = (ReplicationController)entity;
            ReplicationControllerSpec rcSpec = rc.getSpec();
            Deployment deployment = new Deployment();
            deployment.setMetadata(entity.getMetadata());
            if (rcSpec != null) {
                PodTemplateSpec template;
                List containers;
                PodSpec podSpec;
                PodTemplateSpec podTemplateSpec;
                DeploymentSpec deploymentSpec = new DeploymentSpec();
                LinkedHashMap selector = rcSpec.getSelector();
                if (selector != null) {
                    selector = new LinkedHashMap(selector);
                    selector.remove("version");
                }
                this.migrateLabels(selector);
                deploymentSpec.setReplicas(rcSpec.getReplicas());
                if (selector != null) {
                    deploymentSpec.setSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(selector)).build());
                }
                if ((podTemplateSpec = rcSpec.getTemplate()) != null && (podSpec = podTemplateSpec.getSpec()) != null && (containers = podSpec.getContainers()) != null) {
                    for (Container container : containers) {
                        this.migrateContainer(container, parameterConfigMap);
                    }
                }
                if ((template = rcSpec.getTemplate()) != null) {
                    this.migrateMetadata(template.getMetadata());
                    deploymentSpec.setTemplate(template);
                }
                deployment.setSpec(deploymentSpec);
            }
            return deployment;
        }
        return entity;
    }

    protected void migrateContainer(Container container, ConfigMap parameterConfigMap) {
        Map parameters;
        MavenProject project;
        String version;
        String image = container.getImage();
        if (image != null && (version = (project = this.getProject()).getVersion()) != null) {
            String label = ":" + version;
            if (image.endsWith(label)) {
                image = Strings.stripSuffix((String)image, (String)label) + ":${project.version}";
                container.setImage(image);
            } else {
                this.getLog().warn((CharSequence)("Image does not end with " + label + " as image is: " + image));
            }
        }
        if (parameterConfigMap != null && (parameters = parameterConfigMap.getData()) != null) {
            String configMapName = KubernetesHelper.getName((HasMetadata)parameterConfigMap);
            List env = container.getEnv();
            for (EnvVar envVar : env) {
                String variableName;
                String expression;
                String value = envVar.getValue();
                if (value == null) continue;
                String name = envVar.getName();
                if (!value.startsWith("${") || !value.endsWith("}") || !parameters.containsKey(expression = this.convertToConfigMapKey(variableName = Strings.stripPrefix((String)Strings.stripSuffix((String)name, (String)"}"), (String)"${")))) continue;
                envVar.setValue(null);
                envVar.setValueFrom(((EnvVarSourceBuilder)((EnvVarSourceFluent.ConfigMapKeyRefNested)((EnvVarSourceFluent.ConfigMapKeyRefNested)new EnvVarSourceBuilder().withNewConfigMapKeyRef().withName(configMapName)).withKey(expression)).endConfigMapKeyRef()).build());
            }
        }
    }

    protected void migrateMetadata(ObjectMeta metadata) {
        if (metadata == null) {
            return;
        }
        Map annotations = metadata.getAnnotations();
        if (annotations != null) {
            annotations.remove("fabric8.io/build-id");
            annotations.remove("fabric8.io/build-url");
            annotations.remove("fabric8.io/git-branch");
            annotations.remove("fabric8.io/git-commit");
            annotations.remove("fabric8.io/git-url");
        }
        this.migrateLabels(metadata.getLabels());
    }

    private void migrateLabels(Map<String, String> labels) {
        if (labels != null) {
            MavenProject project = this.getProject();
            boolean alwaysUseArtifactIdForProject = true;
            if (alwaysUseArtifactIdForProject) {
                if (labels.containsKey("project")) {
                    labels.put("project", "${project.artifactId}");
                }
            } else {
                this.replaceKeyValueWith(labels, "project", project.getArtifactId(), "${project.artifactId}");
            }
            this.replaceKeyValueWith(labels, "version", project.getVersion(), "${project.version}");
        }
    }

    private void replaceKeyValueWith(Map<String, String> labels, String key, String oldValue, String newValue) {
        String value = labels.get(key);
        if (Objects.equals(value, oldValue)) {
            labels.put(key, newValue);
        }
    }

    private void init() {
        this.kindAliases.put("configmap", "cm");
        this.kindAliases.put("deploymentconfig", "dc");
        this.kindAliases.put("replicationcontroller", "rc");
        this.kindAliases.put("replicaset", "rs");
        this.kindAliases.put("service", "svc");
        this.kindAliases.put("serviceaccount", "sa");
    }

    private String shortenKind(String kind) {
        String answer = this.kindAliases.get(kind);
        if (answer == null) {
            return kind;
        }
        return answer;
    }
}

