/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.support.DefaultExcludedEnvVariablesEnum;
import io.fabric8.maven.support.DockerCommandPlainPrint;
import io.fabric8.maven.support.OrderedProperties;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import io.fabric8.utils.TablePrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="create-env", defaultPhase=LifecyclePhase.COMPILE)
public class CreateEnvMojo
extends AbstractFabric8Mojo {
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";
    private static final String DOCKE_ENV_PREFIX = "docker.env.";
    private static final String DOCKER_NAME = "docker.name";
    private static final String EXEC_ENV_SCRIPT = "environmentScript";
    @Parameter(property="fabric8.envFile", defaultValue="env.properties")
    private String envPropertiesFileName;
    @Parameter(property="fabric8.envScript", defaultValue="env.sh")
    private String envScriptFileName;
    @Parameter(property="fabric8.dockerRunScript", defaultValue="docker-run.sh")
    private String dockerRunScriptFileName;
    @Parameter(property="docker.image")
    private String name;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String scriptFileAbsolutePath;
            String basedir = System.getProperty("basedir", ".");
            File propertiesFile = new File(basedir + "/target/" + this.envPropertiesFileName).getCanonicalFile();
            File scriptFile = new File(basedir + "/target/" + this.envScriptFileName).getCanonicalFile();
            File dockerRunFile = new File(basedir + "/target/" + this.dockerRunScriptFileName).getCanonicalFile();
            Object config = this.loadKubernetesJson();
            List list = KubernetesHelper.toItemList((Object)config);
            Map<String, String> env = this.getEnvFromConfig(list);
            String namespace = this.getNamespace();
            env.putAll(this.getNamespaceServiceEnv(namespace));
            this.removeDefaultEnv(env);
            this.expandEnvironmentVariable(env);
            this.displayEnv(env);
            if (this.name == null) {
                this.name = this.findFirstImageName(list);
            }
            StringBuilder sb = new StringBuilder();
            List<VolumeMount> volumeMount = this.getVolumeMountsFromConfig(list);
            List<ContainerPort> containerPort = this.getContainerPortsFromConfig(list);
            DockerCommandPlainPrint dockerCommandPlainPrint = new DockerCommandPlainPrint(sb);
            dockerCommandPlainPrint.appendParameters(env, "-e");
            dockerCommandPlainPrint.appendContainerPorts(containerPort, "-p");
            dockerCommandPlainPrint.appendVolumeMounts(volumeMount, "-v");
            dockerCommandPlainPrint.appendImageName(this.name);
            this.displayVolumes(volumeMount);
            this.displayContainerPorts(containerPort);
            this.displayDockerRunCommand(dockerCommandPlainPrint);
            Properties properties = this.getProject().getProperties();
            if (properties == null) {
                properties = new Properties();
            }
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null) {
                    this.getLog().warn((CharSequence)"Ignoring null key!");
                    continue;
                }
                if (value == null) {
                    this.getLog().warn((CharSequence)("Ignoring null value for key: " + key));
                    continue;
                }
                properties.setProperty(DOCKE_ENV_PREFIX + key, value);
            }
            if (this.name != null) {
                properties.setProperty(DOCKER_NAME, this.name);
            }
            if ((scriptFileAbsolutePath = scriptFile.getAbsolutePath()) != null) {
                properties.setProperty(EXEC_ENV_SCRIPT, scriptFileAbsolutePath);
            }
            OrderedProperties envProperties = new OrderedProperties();
            Set<Map.Entry<String, String>> entries = env.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null) {
                    this.getLog().warn((CharSequence)"Ignoring null key!");
                    continue;
                }
                if (value == null) {
                    this.getLog().warn((CharSequence)("Ignoring null value for key: " + key));
                    continue;
                }
                envProperties.put(key, value);
            }
            CreateEnvMojo.saveEnvScript(env, scriptFile);
            CreateEnvMojo.saveDockerRunScript(dockerCommandPlainPrint, dockerRunFile);
            CreateEnvMojo.saveProperties(envProperties, propertiesFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, (Exception)e);
        }
    }

    protected String findFirstImageName(List<HasMetadata> list) {
        for (HasMetadata hasMetadata : list) {
            List containers;
            PodSpec podSpec;
            PodTemplateSpec podTemplateSpec;
            ReplicationController rc;
            ReplicationControllerSpec spec;
            if (!(hasMetadata instanceof ReplicationController) || (spec = (rc = (ReplicationController)hasMetadata).getSpec()) == null || (podTemplateSpec = spec.getTemplate()) == null || (podSpec = podTemplateSpec.getSpec()) == null || (containers = podSpec.getContainers()) == null) continue;
            for (Container container : containers) {
                String image = container.getImage();
                if (!Strings.isNotBlank((String)image)) continue;
                return image;
            }
        }
        return null;
    }

    Map<String, String> getNamespaceServiceEnv(String namespace) {
        HashMap<String, String> result = new HashMap<String, String>();
        KubernetesClient kubernetes = this.getKubernetes();
        ServiceList serviceList = kubernetes.getServices(namespace);
        RouteList routeList = kubernetes.getRoutes(namespace);
        for (Service service : serviceList.getItems()) {
            String serviceName = KubernetesHelper.getName((HasMetadata)service);
            String id = serviceName.toUpperCase().replace("-", "_");
            Route route = CreateEnvMojo.findRoute(serviceName, routeList);
            RouteSpec spec = null;
            if (route != null) {
                spec = route.getSpec();
            }
            ServiceSpec serviceSpec = service.getSpec();
            if (spec != null) {
                result.put(id + HOST_SUFFIX, spec.getHost());
            } else if (serviceSpec != null) {
                result.put(id + HOST_SUFFIX, serviceSpec.getClusterIP());
            }
            if (serviceSpec == null) continue;
            List ports = serviceSpec.getPorts();
            for (ServicePort port : ports) {
                result.put(id + PORT_SUFFIX, String.valueOf(port.getPort()));
                result.put(id + PROTO_SUFFIX, port.getProtocol());
                result.put(id + PORT_SUFFIX + "_" + port.getPort() + PROTO_SUFFIX, port.getProtocol());
            }
        }
        return result;
    }

    private Map<String, String> getEnvFromConfig(List<HasMetadata> entities) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                for (Container container : pod.getSpec().getContainers()) {
                    if (!container.getImage().equals(this.name)) continue;
                    result.putAll(CreateEnvMojo.mapFromEnv(container.getEnv()));
                }
                continue;
            }
            if (!(entity instanceof ReplicationController)) continue;
            ReplicationController replicationController = (ReplicationController)entity;
            for (Container container : replicationController.getSpec().getTemplate().getSpec().getContainers()) {
                if (!container.getImage().equals(this.name)) continue;
                result.putAll(CreateEnvMojo.mapFromEnv(container.getEnv()));
            }
        }
        return result;
    }

    protected void expandEnvironmentVariable(Map<String, String> env) {
        MavenProject project = this.getProject();
        if (project != null) {
            Properties properties = project.getProperties();
            properties.putAll((Map<?, ?>)project.getProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String envValue = entry.getValue();
                if (envValue == null || envValue.isEmpty() || !envValue.startsWith("${") || !envValue.endsWith("}")) continue;
                String parameterName = envValue.substring(2, envValue.length() - 1);
                String name = "fabric8.create-env." + parameterName;
                String propertyValue = properties.getProperty(name);
                if (Strings.isNotBlank((String)propertyValue)) {
                    this.getLog().info((CharSequence)("Overriding environment variable " + parameterName + " with value: " + propertyValue));
                    entry.setValue(propertyValue);
                    continue;
                }
                this.getLog().info((CharSequence)("No property defined for environment variable: " + parameterName));
            }
        }
    }

    private List<VolumeMount> getVolumeMountsFromConfig(List<HasMetadata> entities) throws IOException {
        ArrayList<VolumeMount> volumeList = new ArrayList<VolumeMount>();
        for (HasMetadata entity : entities) {
            if (!(entity instanceof ReplicationController)) continue;
            ReplicationController replicationController = (ReplicationController)entity;
            for (Container container : replicationController.getSpec().getTemplate().getSpec().getContainers()) {
                if (!container.getImage().equals(this.name) || container.getVolumeMounts().isEmpty()) continue;
                return container.getVolumeMounts();
            }
        }
        return volumeList;
    }

    private List<ContainerPort> getContainerPortsFromConfig(List<HasMetadata> entities) throws IOException {
        ArrayList<ContainerPort> containerPortList = new ArrayList<ContainerPort>();
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                for (Container container : pod.getSpec().getContainers()) {
                    if (!container.getImage().equals(this.name) || container.getPorts().isEmpty()) continue;
                    containerPortList.addAll(container.getPorts());
                }
                continue;
            }
            if (!(entity instanceof ReplicationController)) continue;
            ReplicationController replicationController = (ReplicationController)entity;
            for (Container container : replicationController.getSpec().getTemplate().getSpec().getContainers()) {
                if (!container.getImage().equals(this.name) || container.getPorts().isEmpty()) continue;
                containerPortList.addAll(container.getPorts());
            }
        }
        return containerPortList;
    }

    private void displayEnv(Map<String, String> map) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"Name", "Value"});
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            table.row(new String[]{name, value});
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Generated Environment variables:");
        this.getLog().info((CharSequence)"-------------------------------");
        List lines = table.asTextLines();
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }

    private void displayVolumes(List<VolumeMount> volumeMount) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"Name", "Mount Path", "Read Only"});
        for (VolumeMount vol : volumeMount) {
            String name = vol.getName();
            String mounthPath = vol.getMountPath();
            String ro = String.valueOf(Boolean.FALSE);
            if (vol.getReadOnly().booleanValue()) {
                ro = String.valueOf(Boolean.TRUE);
            }
            table.row(new String[]{name, mounthPath, ro});
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Volumes Summary:");
        this.getLog().info((CharSequence)"-------------------------------");
        List lines = table.asTextLines();
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }

    private void displayContainerPorts(List<ContainerPort> containerPort) {
        TablePrinter table = new TablePrinter();
        table.columns(new String[]{"Host IP", "Host Port", "Container Port"});
        for (ContainerPort port : containerPort) {
            String hostIp = port.getHostIP();
            String hostPort = "";
            String contPort = "";
            if (port.getHostPort() != null) {
                hostPort = String.valueOf(port.getHostPort());
            }
            if (port.getContainerPort() != null) {
                contPort = String.valueOf(port.getContainerPort());
            }
            table.row(new String[]{hostIp, hostPort, contPort});
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Container Ports Summary:");
        this.getLog().info((CharSequence)"-------------------------------");
        List lines = table.asTextLines();
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }

    private void removeDefaultEnv(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!DefaultExcludedEnvVariablesEnum.contains(entry.getKey())) continue;
            it.remove();
        }
    }

    private void displayDockerRunCommand(DockerCommandPlainPrint dockerCommandPlainPrint) {
        this.getLog().info((CharSequence)"Docker Run Command:");
        this.getLog().info((CharSequence)"-------------------------------");
        this.getLog().info((CharSequence)dockerCommandPlainPrint.getDockerPlainTextCommand().toString());
    }

    private Object loadKubernetesJson() throws MojoFailureException, IOException {
        File json = this.getKubernetesJson();
        if (!Files.isFile((File)json)) {
            if (Files.isFile((File)this.kubernetesSourceJson)) {
                json = this.kubernetesSourceJson;
            } else {
                throw new MojoFailureException("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson);
            }
        }
        return KubernetesHelper.loadJson((File)json);
    }

    private static Map<String, String> mapFromEnv(List<EnvVar> envVars) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (EnvVar envVar : envVars) {
            result.put(envVar.getName(), envVar.getValue());
        }
        return result;
    }

    private static void saveProperties(Properties properties, File propertiesFile) throws IOException {
        try (FileWriter writer = new FileWriter(propertiesFile);){
            properties.store(writer, "Generated Environment Variables");
        }
    }

    private static void saveEnvScript(Map<String, String> map, File scroptFile) throws IOException {
        try (FileWriter writer = new FileWriter(scroptFile);){
            writer.append("#!/bin/bash").append("\n");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().contains(" ")) {
                    writer.append("export ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
                    continue;
                }
                writer.append("export ").append(entry.getKey()).append("=").append("\"").append(entry.getValue()).append("\"").append("\n");
            }
            writer.flush();
        }
    }

    private static void saveDockerRunScript(DockerCommandPlainPrint printer, File scriptFile) throws IOException {
        try (FileWriter writer = new FileWriter(scriptFile);){
            writer.append("#!/bin/bash").append("\n");
            writer.append(printer.getDockerPlainTextCommand().toString()).append("\n");
            writer.flush();
        }
    }

    private static Route findRoute(String serviceId, RouteList routeList) {
        for (Route route : routeList.getItems()) {
            String name;
            ObjectReference to;
            RouteSpec spec = route.getSpec();
            if (spec == null || (to = spec.getTo()) == null || !serviceId.equals(name = to.getName())) continue;
            return route;
        }
        return null;
    }
}

