/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectRepositories;
import io.fabric8.devops.ProjectRepository;
import io.fabric8.devops.connector.DevOpsConnector;
import io.fabric8.devops.connector.DevOpsConnectors;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="apply-projects", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyProjectsMojo
extends AbstractNamespacedMojo {
    @Parameter(property="fabric8.projectsFile", defaultValue="${basedir}/src/main/fabric8/projects.yml")
    protected File projectsFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List projects;
        KubernetesClient kubernetes = this.getKubernetes();
        try {
            projects = ProjectRepositories.loadProjectRepositories((File)this.projectsFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load projects YAML file: " + this.projectsFile + ". " + e, (Exception)e);
        }
        for (ProjectRepository project : projects) {
            DevOpsConnector connector = DevOpsConnectors.createDevOpsConnector((ProjectRepository)project);
            String namespace = this.getNamespace();
            connector.setNamespace(namespace);
            ProjectConfig config = connector.getProjectConfig();
            String flow = config != null ? config.getFlow() : null;
            this.getLog().info((CharSequence)("Updating project " + project.getUser() + "/" + project.getRepoName() + " at " + project.getGitUrl() + " and flow " + flow + " in namespace: " + namespace));
            this.getLog().debug((CharSequence)("Using connector: " + connector));
            try {
                connector.execute();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to update DevOps resources: " + e), (Throwable)e);
                throw new MojoExecutionException("Failed to update DevOps resources: " + e, e);
            }
        }
    }
}

