/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.repo.git.CreateWebhookDTO;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.repo.git.WebHookDTO;
import io.fabric8.repo.git.WebhookConfig;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.JsonHelper;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-gogs-webhook", requiresProject=false)
public class CreateGogsWebhook
extends AbstractNamespacedMojo {
    @Parameter(property="webhookUrl", required=true)
    private String webhookUrl;
    @Parameter(property="repo", required=true)
    private String repo;
    @Parameter(property="gogsUsername", defaultValue="${JENKINS_GOGS_USER}")
    private String gogsUsername;
    @Parameter(property="gogsPassword", defaultValue="${JENKINS_GOGS_PASSWORD}")
    private String gogsPassword;
    @Parameter(property="secret", defaultValue="secret101")
    private String secret;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            KubernetesClient kubernetes = this.getKubernetes();
            Log log = this.getLog();
            String gogsUser = this.gogsUsername;
            String gogsPwd = this.gogsPassword;
            String repoName = this.repo;
            String webhookUrlValue = this.webhookUrl;
            String webhookSecret = this.secret;
            CreateGogsWebhook.createGogsWebhook(kubernetes, log, gogsUser, gogsPwd, repoName, webhookUrlValue, webhookSecret);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, e);
        }
    }

    public static boolean createGogsWebhook(KubernetesClient kubernetes, Log log, String gogsUser, String gogsPwd, String repoName, String webhookUrl, String webhookSecret) throws MojoExecutionException, JsonProcessingException {
        if (Strings.isNullOrBlank((String)gogsUser)) {
            gogsUser = "gogsadmin";
        }
        if (Strings.isNullOrBlank((String)gogsPwd)) {
            gogsPwd = "RedHat$1";
        }
        String namespace = kubernetes.getNamespace();
        String gogsAddress = kubernetes.getServiceURL("gogs", namespace, "http", true);
        log.info((CharSequence)("Found gogs address: " + gogsAddress + " for namespace: " + namespace + " on Kubernetes address: " + kubernetes.getAddress()));
        if (Strings.isNullOrBlank((String)gogsAddress)) {
            throw new MojoExecutionException("No address for service gogs in namespace: " + namespace + " on Kubernetes address: " + kubernetes.getAddress());
        }
        log.info((CharSequence)("Querying webhooks in gogs for namespace: " + namespace + " on Kubernetes address: " + kubernetes.getAddress()));
        GitRepoClient repoClient = new GitRepoClient(gogsAddress, gogsUser, gogsPwd);
        List webhooks = repoClient.getWebhooks(gogsUser, repoName);
        for (WebHookDTO webhook : webhooks) {
            String url = null;
            WebhookConfig config = webhook.getConfig();
            if (config == null) continue;
            url = config.getUrl();
            if (Objects.equal((Object)webhookUrl, (Object)url)) {
                log.info((CharSequence)("Already has webhook for: " + url + " so not creating again"));
                return false;
            }
            log.info((CharSequence)("Ignoring webhook " + url + " from: " + JsonHelper.toJson((Object)config)));
        }
        CreateWebhookDTO createWebhook = new CreateWebhookDTO();
        createWebhook.setType("gogs");
        WebhookConfig config = createWebhook.getConfig();
        config.setUrl(webhookUrl);
        config.setSecret(webhookSecret);
        WebHookDTO webhook = repoClient.createWebhook(gogsUser, repoName, createWebhook);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Got created web hook: " + JsonHelper.toJson((Object)webhook)));
        }
        log.info((CharSequence)("Created webhook for " + webhookUrl + " for namespace: " + namespace + " on gogs URL: " + gogsAddress));
        return true;
    }
}

