/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.util.IntOrString;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemaProperty;
import io.fabric8.maven.support.VolumeType;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.template.Parameter;
import io.fabric8.openshift.api.model.template.ParameterBuilder;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.openshift.api.model.template.TemplateBuilder;
import io.fabric8.openshift.api.model.template.TemplateFluent;
import io.fabric8.utils.Base64Encoder;
import io.fabric8.utils.Files;
import io.fabric8.utils.Function;
import io.fabric8.utils.Objects;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="json", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class JsonMojo
extends AbstractFabric8Mojo {
    public static final String FABRIC8_PORT_HOST_PREFIX = "docker.port.host.";
    public static final String FABRIC8_PORT_CONTAINER_PREFIX = "docker.port.container.";
    public static final String FABRIC8_PORT_SERVICE = "fabric8.service.port";
    public static final String FABRIC8_CONTAINER_PORT_SERVICE = "fabric8.service.containerPort";
    public static final String FABRIC8_PROTOCOL_SERVICE = "fabric8.service.protocol";
    public static final String FABRIC8_PORT_SERVICE_PREFIX = "fabric8.service.port.";
    public static final String FABRIC8_CONTAINER_PORT_SERVICE_PREFIX = "fabric8.service.containerPort.";
    public static final String FABRIC8_PROTOCOL_SERVICE_PREFIX = "fabric8.service.protocol.";
    private static final String NAME = "name";
    private static final String ATTRIBUTE_TYPE = "attributeType";
    private static final String VOLUME_MOUNT_PATH = "mountPath";
    private static final String VOLUME_REGEX = "fabric8.volume.(?<name>[^. ]*).(?<attributeType>[^. ]*)";
    private static final Pattern VOLUME_PATTERN = Pattern.compile("fabric8.volume.(?<name>[^. ]*).(?<attributeType>[^. ]*)");
    private static final String PARAM_REGEX = "fabric8.parameter.(?<name>[^. ]*)(.)?(?<attributeType>[^ ]*)";
    private static final Pattern PARAM_PATTERN = Pattern.compile("fabric8.parameter.(?<name>[^. ]*)(.)?(?<attributeType>[^ ]*)");
    private static final String TEMPLATE_NAME = "fabric8.template";
    private static final String PARAMETER_PREFIX = "fabric8.parameter";
    private static final String PARAMETER_NAME_PREFIX = "fabric8.parameter.%s";
    private static final String PARAMETER_PROPERTY = "fabric8.parameter.%s.%s";
    private static final String GENERATE = "generate";
    private static final String FROM = "from";
    private static final String VALUE = "value";
    private static final String DESCRIPTION = "description";
    @Component
    private MavenProjectHelper projectHelper;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.kubernetes.artifactType", defaultValue="json")
    private String artifactType = "json";
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.kubernetes.artifactClassifier", defaultValue="kubernetes")
    private String artifactClassifier = "kubernetes";
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.generateJson", defaultValue="true")
    private boolean generateJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.failOnMissingJsonFiles", defaultValue="true")
    private boolean failOnMissingJsonFiles;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.includeNamespaceEnvVar", defaultValue="true")
    private boolean includeNamespaceEnvVar;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.namespaceEnvVar", defaultValue="KUBERNETES_NAMESPACE")
    private String kubernetesNamespaceEnvVar;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.provider", defaultValue="fabric8")
    private String provider;
    @org.apache.maven.plugins.annotations.Parameter
    private Map<String, String> labels;
    @org.apache.maven.plugins.annotations.Parameter
    private List<EnvVar> environmentVariables;
    @org.apache.maven.plugins.annotations.Parameter
    private List<ContainerPort> containerPorts;
    @org.apache.maven.plugins.annotations.Parameter
    private Map<String, Integer> defaultContainerPortMap;
    @org.apache.maven.plugins.annotations.Parameter
    private List<ServicePort> servicePorts;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.replicas", defaultValue="1")
    private Integer replicaCount;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.useDeploymentConfig", defaultValue="false")
    private boolean useDeploymentConfig;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.lastTriggeredImageTag", defaultValue="latest")
    private String lastTriggeredImageTag;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploymentStrategy", defaultValue="Recreate")
    private String deploymentStrategy;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.extra.json", defaultValue="${basedir}/target/classes/kubernetes-extra.json")
    private File kubernetesExtraJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.templateTempDir", defaultValue="${basedir}/target/fabric8/template-workdir")
    private File templateTempDir;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.iconUrl")
    private String iconUrl;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.iconUrlPrefix")
    private String iconUrlPrefix;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.iconBranch", defaultValue="master")
    private String iconBranch;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.replicationController.name", defaultValue="${project.artifactId}")
    private String replicationControllerName;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.kubernetes.name", defaultValue="${project.artifactId}")
    private String kubernetesName;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.container.name", defaultValue="${project.artifactId}")
    private String kubernetesContainerName;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.service.name", defaultValue="${project.artifactId}")
    private String serviceName;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.service.headless", defaultValue="false")
    private boolean headlessServices;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.service.port")
    private Integer servicePort;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.service.containerPort")
    private String serviceContainerPort;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.service.protocol", defaultValue="TCP")
    private String serviceProtocol;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.imagePullPolicy")
    private String imagePullPolicy;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.imagePullPolicySnapshot")
    private String imagePullPolicySnapshot;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.includeAllEnvironmentVariables", defaultValue="true")
    private boolean includeAllEnvironmentVariables;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.containerPrivileged")
    protected Boolean containerPrivileged;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.serviceAccount")
    protected String serviceAccount;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.templateParametersFile", defaultValue="${basedir}/src/main/fabric8/templateParameters.properties")
    protected File templateParametersPropertiesFile;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.maximumDataUrlSizeK", defaultValue="2")
    private int maximumDataUrlSizeK;
    @Component
    protected ArtifactResolver resolver;
    @org.apache.maven.plugins.annotations.Parameter(property="localRepository", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @org.apache.maven.plugins.annotations.Parameter(property="project.remoteArtifactRepositories")
    protected List remoteRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File json = this.getKubernetesJson();
        this.getLog().info((CharSequence)("Configured with file: " + json));
        if (json == null) {
            throw new MojoExecutionException("No kubernetes json file is specified!");
        }
        if (this.shouldGenerateForThisProject() && (!this.isIgnoreProject() || this.combineDependencies)) {
            if (this.combineDependencies) {
                this.combineDependentJsonFiles(json);
            } else if (this.generateJson) {
                this.generateKubernetesJson(json);
                if (this.kubernetesExtraJson != null && this.kubernetesExtraJson.exists()) {
                    this.combineJsonFiles(json, this.kubernetesExtraJson);
                }
            }
            if (json.exists() && json.isFile() && this.useDeploymentConfig) {
                this.wrapInDeploymentConfigs(json);
            }
        }
    }

    @Override
    protected boolean shouldGenerateForThisProject() {
        return super.shouldGenerateForThisProject() || this.combineDependencies;
    }

    protected void combineDependentJsonFiles(File json) throws MojoExecutionException {
        try {
            MavenProject project = this.getProject();
            LinkedHashSet<File> jsonFiles = new LinkedHashSet<File>();
            Set dependencyArtifacts = project.getDependencyArtifacts();
            for (Artifact artifact : dependencyArtifacts) {
                String classifier = artifact.getClassifier();
                String type = artifact.getType();
                File file = artifact.getFile();
                if (!JsonMojo.isKubernetesJsonArtifact(classifier, type)) continue;
                if (file != null) {
                    System.out.println("Found kubernetes JSON dependency: " + artifact);
                    jsonFiles.add(file);
                    continue;
                }
                Set<Artifact> artifacts = this.resolveArtifacts(artifact);
                for (Artifact resolvedArtifact : artifacts) {
                    classifier = resolvedArtifact.getClassifier();
                    type = resolvedArtifact.getType();
                    file = resolvedArtifact.getFile();
                    if (!JsonMojo.isKubernetesJsonArtifact(classifier, type) || file == null) continue;
                    System.out.println("Resolved kubernetes JSON dependency: " + artifact);
                    jsonFiles.add(file);
                }
            }
            ArrayList<Object> jsonObjectList = new ArrayList<Object>();
            for (File file : jsonFiles) {
                this.addKubernetesJsonFileToList(jsonObjectList, file);
            }
            if (jsonObjectList.isEmpty()) {
                if (this.failOnMissingJsonFiles) {
                    throw new MojoExecutionException("Could not find any dependent kubernetes JSON files!");
                }
                this.getLog().warn((CharSequence)"Could not find any dependent kubernetes JSON files");
                return;
            }
            Object combinedJson = jsonObjectList.size() == 1 ? jsonObjectList.get(0) : KubernetesHelper.combineJson((Object[])jsonObjectList.toArray());
            if (combinedJson instanceof Template) {
                Template template = (Template)combinedJson;
                KubernetesHelper.setName((HasMetadata)template, (String)this.getKubernetesName());
                this.configureTemplateDescriptionAndIcon(template, this.getIconUrl());
            }
            json.getParentFile().mkdirs();
            KubernetesHelper.saveJson((File)json, combinedJson);
            this.getLog().info((CharSequence)("Saved as :" + json.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to save combined JSON files " + json + " and " + this.kubernetesExtraJson + " as " + json + ". " + e, e);
        }
    }

    private void addKubernetesJsonFileToList(List<Object> list, File file) {
        block5: {
            if (file.exists() && file.isFile()) {
                try {
                    Object jsonObject = JsonMojo.loadJsonFile(file);
                    if (jsonObject != null) {
                        list.add(jsonObject);
                        break block5;
                    }
                    this.getLog().warn((CharSequence)("No object found for file: " + file));
                }
                catch (MojoExecutionException e) {
                    this.getLog().warn((CharSequence)("Failed to parse file " + file + ". " + (Object)((Object)e)), (Throwable)e);
                }
            } else {
                this.getLog().warn((CharSequence)("Ignoring missing file " + file));
            }
        }
    }

    protected Set<Artifact> resolveArtifacts(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setRemoteRepositories(this.remoteRepositories);
        request.setLocalRepository(this.localRepository);
        ArtifactResolutionResult resolve = this.resolver.resolve(request);
        return resolve.getArtifacts();
    }

    protected void combineJsonFiles(File json, File kubernetesExtraJson) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Combining generated json " + json + " with extra json " + kubernetesExtraJson));
        Object extra = JsonMojo.loadJsonFile(kubernetesExtraJson);
        Object generated = JsonMojo.loadJsonFile(json);
        try {
            Object combinedJson = KubernetesHelper.combineJson((Object[])new Object[]{generated, extra});
            KubernetesHelper.saveJson((File)json, (Object)combinedJson);
            this.getLog().info((CharSequence)("Saved as :" + json.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save combined JSON files " + json + " and " + kubernetesExtraJson + " as " + json + ". " + e, (Exception)e);
        }
    }

    protected void wrapInDeploymentConfigs(File json) throws MojoExecutionException {
        try {
            Object dto = JsonMojo.loadJsonFile(json);
            if (dto instanceof KubernetesList) {
                KubernetesList container = (KubernetesList)dto;
                List<HasMetadata> items = container.getItems();
                items = this.wrapInDeploymentConfigs(items);
                this.getLog().info((CharSequence)"Wrapped in DeploymentConfigs:");
                this.printSummary(items);
                container.setItems(items);
                KubernetesHelper.saveJson((File)json, (Object)container);
            } else if (dto instanceof Template) {
                Template container = (Template)dto;
                List<HasMetadata> items = container.getObjects();
                items = this.wrapInDeploymentConfigs(items);
                this.getLog().info((CharSequence)"Wrapped in DeploymentConfigs:");
                this.printSummary(items);
                container.setObjects(items);
                this.getLog().info((CharSequence)"Template is now:");
                this.printSummary(container.getObjects());
                KubernetesHelper.saveJson((File)json, (Object)container);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save combined JSON files " + json + " and " + this.kubernetesExtraJson + " as " + json + ". " + e, (Exception)e);
        }
    }

    protected List<HasMetadata> wrapInDeploymentConfigs(List<HasMetadata> items) {
        ArrayList<HasMetadata> answer = new ArrayList<HasMetadata>();
        for (HasMetadata item : items) {
            if (item instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)item;
                this.wrapInDeploymentConfigs(answer, replicationController);
                continue;
            }
            answer.add(item);
        }
        return answer;
    }

    protected void wrapInDeploymentConfigs(List<HasMetadata> list, ReplicationController replicationController) {
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
        String name = KubernetesHelper.getName((HasMetadata)replicationController);
        if (Strings.isNotBlank((String)name)) {
            name = Strings.stripSuffix((String)name, (String)"-controller");
        }
        if (Strings.isNullOrBlank((String)name)) {
            name = this.getProject().getArtifactId();
        }
        String deploymentName = name;
        String imageStream = name;
        Map labels = KubernetesHelper.getLabels((HasMetadata)replicationController);
        builder = (DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)builder.withNewMetadata().withName(deploymentName)).withLabels(labels)).endMetadata();
        ReplicationControllerSpec spec = replicationController.getSpec();
        if (spec != null) {
            List containers;
            PodSpec podSpec;
            ArrayList<String> containerNames = new ArrayList<String>();
            PodTemplateSpec podTemplateSpec = spec.getTemplate();
            if (podTemplateSpec != null && (podSpec = podTemplateSpec.getSpec()) != null && (containers = podSpec.getContainers()) != null) {
                for (Container container : containers) {
                    String containerName = container.getName();
                    if (!Strings.isNotBlank((String)containerName)) continue;
                    containerNames.add(containerName);
                }
            }
            this.getOrAddImageStream(list, imageStream, labels);
            builder = (DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.StrategyNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)builder.withNewSpec().withTemplate(podTemplateSpec)).withReplicas(spec.getReplicas())).withSelector(spec.getSelector())).withNewStrategy().withType(this.deploymentStrategy)).endStrategy()).addNewTrigger().withType("ImageChange")).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withContainerNames(containerNames)).withNewFrom().withName(imageStream + ":" + this.lastTriggeredImageTag)).endFrom()).withLastTriggeredImage(this.lastTriggeredImageTag)).endImageChangeParams()).endTrigger()).endSpec();
        }
        DeploymentConfig config = builder.build();
        list.add((HasMetadata)config);
    }

    protected ImageStream getOrAddImageStream(List<HasMetadata> list, String imageStreamName, Map<String, String> labels) {
        for (HasMetadata item : list) {
            ImageStream stream;
            if (!(item instanceof ImageStream) || !Objects.equal((Object)imageStreamName, (Object)KubernetesHelper.getName((HasMetadata)(stream = (ImageStream)item)))) continue;
            return stream;
        }
        ImageStream imageStream = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(imageStreamName)).withLabels(labels)).endMetadata()).build();
        list.add((HasMetadata)imageStream);
        return imageStream;
    }

    protected static Object loadJsonFile(File file) throws MojoExecutionException {
        try {
            return KubernetesHelper.loadJson((File)file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse JSON " + file + ". " + e, (Exception)e);
        }
    }

    protected void generateKubernetesJson(File kubernetesJson) throws MojoExecutionException {
        KubernetesList kubernetesList;
        Object result;
        MavenProject project = this.getProject();
        Map<String, String> labelMap = this.getLabels();
        String name = this.getKubernetesName();
        if (labelMap.isEmpty() && Strings.isNotBlank((String)name)) {
            labelMap.put("component", name);
        }
        if (!labelMap.containsKey("provider") && Strings.isNotBlank((String)this.provider)) {
            labelMap.put("provider", this.provider);
        }
        KubernetesListBuilder builder = (KubernetesListBuilder)((BaseKubernetesListFluent.ReplicationControllerItemsNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.SecurityContextNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((BaseKubernetesListFluent.ReplicationControllerItemsNested)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new KubernetesListBuilder().addNewReplicationControllerItem().withNewMetadata().withName(KubernetesHelper.validateKubernetesId((String)this.replicationControllerName, (String)"fabric8.replicationController.name"))).withLabels(labelMap)).endMetadata()).withNewSpec().withReplicas(this.replicaCount)).withSelector(labelMap)).withNewTemplate().withNewMetadata().withLabels(labelMap)).endMetadata()).withNewSpec().withServiceAccount(this.serviceAccount)).addNewContainer().withName(this.getKubernetesContainerName())).withImage(this.getDockerImage())).withImagePullPolicy(this.getImagePullPolicy())).withEnv(this.getEnvironmentVariables())).withNewSecurityContext().withPrivileged(this.getContainerPrivileged())).endSecurityContext()).withPorts(this.getContainerPorts())).withVolumeMounts(this.getVolumeMounts())).withLivenessProbe(this.getLivenessProbe())).withReadinessProbe(this.getReadinessProbe())).endContainer()).withVolumes(this.getVolumes())).endSpec()).endTemplate()).endSpec()).endReplicationControllerItem();
        if (this.serviceName != null) {
            ServiceBuilder serviceBuilder = (ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.serviceName)).withLabels(labelMap)).endMetadata();
            ServiceFluent.SpecNested serviceSpecBuilder = (ServiceFluent.SpecNested)serviceBuilder.withNewSpec().withSelector(labelMap);
            List<ServicePort> servicePorts = this.getServicePorts();
            System.out.println("Generated ports: " + servicePorts);
            boolean hasPorts = servicePorts != null & !servicePorts.isEmpty();
            if (hasPorts) {
                serviceSpecBuilder.withPorts(servicePorts);
            } else {
                serviceSpecBuilder.withPortalIP("None");
            }
            serviceSpecBuilder.endSpec();
            if (this.headlessServices || hasPorts) {
                builder = (KubernetesListBuilder)builder.addToServiceItems(serviceBuilder.build());
            }
        }
        Template template = this.getTemplate();
        String iconUrl = this.getIconUrl();
        if (!template.getParameters().isEmpty() || Strings.isNotBlank((String)iconUrl)) {
            this.configureTemplateDescriptionAndIcon(template, iconUrl);
            builder = (KubernetesListBuilder)builder.addToTemplateItems(template);
        }
        if ((result = Templates.combineTemplates((KubernetesList)(kubernetesList = builder.build()))) instanceof Template) {
            Template resultTemplate = (Template)result;
            this.configureTemplateDescriptionAndIcon(resultTemplate, iconUrl);
        }
        try {
            ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
            String generated = mapper.writeValueAsString(result);
            Files.writeToFile((File)kubernetesJson, (String)generated, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to generate Kubernetes JSON.", e);
        }
    }

    protected void configureTemplateDescriptionAndIcon(Template template, String iconUrl) {
        Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)template);
        this.addDocumentationAnnotations(template, annotations);
        if (Strings.isNotBlank((String)iconUrl)) {
            annotations.put(this.getTemplateKey(template, "iconUrl"), iconUrl);
        }
    }

    protected String getTemplateKey(Template template, String key) {
        String name = KubernetesHelper.getName((HasMetadata)template);
        if (Strings.isNullOrBlank((String)name)) {
            name = this.getProject().getArtifactId();
        }
        return "fabric8." + name + "/" + key;
    }

    protected void addDocumentationAnnotations(Template template, Map<String, String> annotations) {
        try {
            this.copySummaryText(this.templateTempDir);
            this.copyReadMe(this.templateTempDir);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to copy documentation: " + e), (Throwable)e);
        }
        File summary = new File(this.templateTempDir, "Summary.md");
        if (summary.exists() && summary.isFile()) {
            try {
                String text = Files.toString((File)summary);
                annotations.put(this.getTemplateKey(template, "summary"), text);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to load " + summary + ". " + e), (Throwable)e);
            }
        }
        String description = null;
        File readme = new File(this.templateTempDir, "ReadMe.md");
        if (readme.exists() && readme.isFile()) {
            try {
                description = Files.toString((File)readme);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to load " + readme + ". " + e), (Throwable)e);
            }
        }
        if (description == null) {
            description = this.getProject().getDescription();
        }
        if (Strings.isNotBlank(description)) {
            annotations.put(DESCRIPTION, description);
        }
    }

    protected String getIconUrl() {
        String commonRef;
        String answer = this.iconUrl;
        if (Strings.isNullOrBlank((String)answer)) {
            try {
                if (this.templateTempDir != null) {
                    this.templateTempDir.mkdirs();
                    File iconFile = this.copyIconToFolder(this.templateTempDir);
                    if (iconFile == null) {
                        this.copyAppConfigFiles(this.templateTempDir, this.appConfigDir);
                        for (String ext : ICON_EXTENSIONS) {
                            File file = new File(this.templateTempDir, "icon" + ext);
                            if (!file.exists() || !file.isFile()) continue;
                            iconFile = file;
                            break;
                        }
                    }
                    if (iconFile != null) {
                        answer = this.convertIconFileToURL(iconFile);
                    }
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to load icon file: " + e), (Throwable)e);
            }
        }
        if (Strings.isNullOrBlank((String)answer) && (commonRef = this.asCommonIconRef(this.iconRef)) != null) {
            answer = URLUtils.pathJoin((String[])new String[]{"https://cdn.rawgit.com/fabric8io/fabric8", this.iconBranch, "/fabric8-maven-plugin/src/main/resources/", commonRef});
        }
        if (Strings.isNullOrBlank((String)answer)) {
            this.getLog().warn((CharSequence)"No icon file found for this project!");
        } else {
            this.getLog().info((CharSequence)("Icon URL: " + answer));
        }
        return answer;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String convertIconFileToURL(File iconFile) throws IOException {
        String urlPrefix;
        String relativePath;
        block6: {
            int len$;
            String[] arr$;
            String url;
            String relativeParentPath;
            block7: {
                block5: {
                    String[] prefixes;
                    Scm scm;
                    long length = iconFile.length();
                    int sizeK = Math.round(length / 1024L);
                    byte[] bytes = Files.readBytes((File)iconFile);
                    byte[] encoded = Base64Encoder.encode((byte[])bytes);
                    int base64SizeK = Math.round(encoded.length / 1024);
                    this.getLog().info((CharSequence)("found icon file: " + iconFile + " which is " + sizeK + "K" + " base64 encoded " + base64SizeK + "K"));
                    if (base64SizeK < this.maximumDataUrlSizeK) {
                        String mimeType = Files.guessMediaType((File)iconFile);
                        return "data:" + mimeType + ";charset=UTF-8;base64," + new String(encoded);
                    }
                    File iconSourceFile = new File(this.appConfigDir, iconFile.getName());
                    if (!iconSourceFile.exists()) break block5;
                    File rootProjectFolder = this.getRootProjectFolder();
                    if (rootProjectFolder == null) return null;
                    relativePath = Files.getRelativePath((File)rootProjectFolder, (File)iconSourceFile);
                    relativeParentPath = Files.getRelativePath((File)rootProjectFolder, (File)this.getProject().getBasedir());
                    urlPrefix = this.iconUrlPrefix;
                    if (!Strings.isNullOrBlank((String)urlPrefix) || (scm = this.getProject().getScm()) == null || (url = scm.getUrl()) == null) break block6;
                    arr$ = prefixes = new String[]{"http://github.com/", "https://github.com/"};
                    len$ = arr$.length;
                    break block7;
                }
                String commonRef = this.asCommonIconRef(this.iconRef);
                if (commonRef != null) {
                    return URLUtils.pathJoin((String[])new String[]{"https://cdn.rawgit.com/fabric8io/fabric8", this.iconBranch, "/fabric8-maven-plugin/src/main/resources/", commonRef});
                }
                this.getLog().warn((CharSequence)("Cannot find url for icon to use " + this.iconUrl));
                return null;
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                String prefix = arr$[i$];
                if (!url.startsWith(prefix)) continue;
                url = URLUtils.pathJoin((String[])new String[]{"https://cdn.rawgit.com/", url.substring(prefix.length())});
                break;
            }
            if (url.endsWith(relativeParentPath)) {
                url = url.substring(0, url.length() - relativeParentPath.length());
            }
            urlPrefix = url;
        }
        if (Strings.isNullOrBlank((String)urlPrefix)) {
            this.getLog().warn((CharSequence)"No iconUrlPrefix defined or could be found via SCM in the pom.xml so cannot add an icon URL!");
            return null;
        }
        String answer = URLUtils.pathJoin((String[])new String[]{urlPrefix, this.iconBranch, relativePath});
        this.getLog().info((CharSequence)("icon url is: " + answer));
        return answer;
    }

    protected String asCommonIconRef(String iconRef) {
        if (iconRef == null) {
            return null;
        }
        if (iconRef.startsWith("icons/")) {
            iconRef = iconRef.substring(6);
        }
        if (iconRef.contains("activemq")) {
            return "icons/activemq.svg";
        }
        if (iconRef.contains("camel")) {
            return "icons/camel.svg";
        }
        if (iconRef.contains("java")) {
            return "icons/java.svg";
        }
        if (iconRef.contains("jetty")) {
            return "icons/jetty.svg";
        }
        if (iconRef.contains("karaf")) {
            return "icons/karaf.svg";
        }
        if (iconRef.contains("mule")) {
            return "icons/mule.svg";
        }
        if (iconRef.contains("spring-boot")) {
            return "icons/spring-boot.svg";
        }
        if (iconRef.contains("tomcat")) {
            return "icons/tomcat.svg";
        }
        if (iconRef.contains("tomee")) {
            return "icons/tomee.svg";
        }
        if (iconRef.contains("weld")) {
            return "icons/weld.svg";
        }
        if (iconRef.contains("wildfly")) {
            return "icons/wildfly.svg";
        }
        return null;
    }

    protected Probe getLivenessProbe() {
        return this.getProbe("fabric8.livenessProbe");
    }

    protected Probe getReadinessProbe() {
        return this.getProbe("fabric8.readinessProbe");
    }

    protected Probe getProbe(String prefix) {
        Long timeoutSeconds;
        Long initialDelaySeconds;
        Probe answer = new Probe();
        boolean added = false;
        Properties properties = this.getProject().getProperties();
        String httpGetPath = properties.getProperty(prefix + ".httpGet.path");
        String httpGetPort = properties.getProperty(prefix + ".httpGet.port");
        String httpGetHost = properties.getProperty(prefix + ".httpGet.host");
        if (Strings.isNotBlank((String)httpGetPath)) {
            added = true;
            HTTPGetAction httpGet = new HTTPGetAction();
            httpGet.setPath(httpGetPath);
            httpGet.setHost(httpGetHost);
            if (Strings.isNotBlank((String)httpGetPort)) {
                IntOrString httpGetPortIntOrString = KubernetesHelper.createIntOrString((String)httpGetPort);
                httpGet.setPort(httpGetPortIntOrString);
            }
            answer.setHttpGet(httpGet);
        }
        if ((initialDelaySeconds = PropertiesHelper.getLong((Properties)properties, (String)(prefix + ".initialDelaySeconds"))) != null) {
            answer.setInitialDelaySeconds(initialDelaySeconds);
        }
        if ((timeoutSeconds = PropertiesHelper.getLong((Properties)properties, (String)(prefix + ".timeoutSeconds"))) != null) {
            answer.setTimeoutSeconds(timeoutSeconds);
        }
        return added ? answer : null;
    }

    public Boolean getContainerPrivileged() {
        return this.containerPrivileged;
    }

    public String getImagePullPolicy() {
        MavenProject project = this.getProject();
        String pullPolicy = this.imagePullPolicy;
        if (project != null) {
            String version = project.getVersion();
            if (Strings.isNullOrBlank((String)pullPolicy) && version != null && version.endsWith("SNAPSHOT")) {
                pullPolicy = this.imagePullPolicySnapshot;
            }
        }
        return pullPolicy;
    }

    public String getKubernetesContainerName() {
        if (Strings.isNullOrBlank((String)this.kubernetesContainerName)) {
            String[] paths;
            String groupPrefix = null;
            MavenProject project = this.getProject();
            String imageName = project.getProperties().getProperty("docker.image");
            if (Strings.isNotBlank((String)imageName) && (paths = imageName.split("/")) != null) {
                if (paths.length == 2) {
                    groupPrefix = paths[0];
                } else if (paths.length == 3) {
                    groupPrefix = paths[1];
                }
            }
            if (Strings.isNullOrBlank(groupPrefix)) {
                groupPrefix = project.getGroupId();
            }
            this.kubernetesContainerName = groupPrefix + "-" + project.getArtifactId();
        }
        return this.kubernetesContainerName;
    }

    public void setKubernetesContainerName(String kubernetesContainerName) {
        this.kubernetesContainerName = kubernetesContainerName;
    }

    public String getKubernetesName() {
        return this.kubernetesName;
    }

    public void setKubernetesName(String kubernetesName) {
        this.kubernetesName = kubernetesName;
    }

    public Map<String, Integer> getDefaultContainerPortMap() {
        if (this.defaultContainerPortMap == null) {
            this.defaultContainerPortMap = new HashMap<String, Integer>();
        }
        if (this.defaultContainerPortMap.isEmpty()) {
            this.defaultContainerPortMap.put("jolokia", 8778);
            this.defaultContainerPortMap.put("web", 8080);
        }
        return this.defaultContainerPortMap;
    }

    public void setDefaultContainerPortMap(Map<String, Integer> defaultContainerPortMap) {
        this.defaultContainerPortMap = defaultContainerPortMap;
    }

    public List<ContainerPort> getContainerPorts() {
        if (this.containerPorts == null) {
            this.containerPorts = new ArrayList<ContainerPort>();
        }
        if (this.containerPorts.isEmpty()) {
            ContainerPort port;
            Integer portNumber;
            String portText;
            String name;
            HashMap<String, ContainerPort> portMap = new HashMap<String, ContainerPort>();
            Properties properties1 = this.getProject().getProperties();
            Map hostPorts = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)FABRIC8_PORT_HOST_PREFIX);
            Properties properties = this.getProject().getProperties();
            Map containerPortsMap = PropertiesHelper.findPropertiesWithPrefix((Properties)properties, (String)FABRIC8_PORT_CONTAINER_PREFIX);
            for (Map.Entry entry : containerPortsMap.entrySet()) {
                name = (String)entry.getKey();
                portText = (String)entry.getValue();
                portNumber = this.parsePort(portText, FABRIC8_PORT_CONTAINER_PREFIX + name);
                if (portNumber == null) continue;
                port = JsonMojo.getOrCreatePort(portMap, name);
                port.setContainerPort(portNumber);
                port.setName(name);
            }
            for (Map.Entry entry : hostPorts.entrySet()) {
                name = (String)entry.getKey();
                portText = (String)entry.getValue();
                portNumber = this.parsePort(portText, FABRIC8_PORT_HOST_PREFIX + name);
                if (portNumber == null) continue;
                port = JsonMojo.getOrCreatePort(portMap, name);
                port.setHostPort(portNumber);
                if (port.getContainerPort() != null) continue;
                port.setContainerPort(this.getDefaultContainerPortMap().get(name));
            }
            this.getLog().info((CharSequence)("Generated port mappings: " + portMap));
            this.getLog().debug((CharSequence)("from host ports: " + hostPorts));
            this.getLog().debug((CharSequence)("from containerPorts ports: " + this.containerPorts));
            this.containerPorts.addAll(portMap.values());
        }
        return this.containerPorts;
    }

    protected static ContainerPort getOrCreatePort(Map<String, ContainerPort> portMap, String name) {
        ContainerPort answer = portMap.get(name);
        if (answer == null) {
            answer = new ContainerPort();
            portMap.put(name, answer);
            answer.setName(name);
        }
        return answer;
    }

    public List<ServicePort> getServicePorts() throws MojoExecutionException {
        if (this.servicePorts == null) {
            this.servicePorts = new ArrayList<ServicePort>();
        }
        if (this.servicePorts.isEmpty()) {
            Properties properties1 = this.getProject().getProperties();
            Map servicePortProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)FABRIC8_PORT_SERVICE_PREFIX);
            Map serviceContainerPortProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)FABRIC8_CONTAINER_PORT_SERVICE_PREFIX);
            Map serviceProtocolProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)properties1, (String)FABRIC8_PROTOCOL_SERVICE_PREFIX);
            for (Map.Entry entry : servicePortProperties.entrySet()) {
                String name = (String)entry.getKey();
                String servicePortText = (String)entry.getValue();
                Integer servicePortNumber = this.parsePort(servicePortText, FABRIC8_PORT_SERVICE_PREFIX + name);
                if (servicePortNumber == null) continue;
                String containerPort = (String)serviceContainerPortProperties.get(name);
                if (Strings.isNullOrBlank((String)containerPort)) {
                    this.getLog().warn((CharSequence)("Missing container port for service - need to specify fabric8.service.containerPort." + name + " property"));
                    continue;
                }
                ServicePort servicePort = new ServicePort();
                servicePort.setName(name);
                servicePort.setPort(servicePortNumber);
                IntOrString containerPortSpec = new IntOrString();
                Integer containerPortNumber = this.parsePort(containerPort, FABRIC8_CONTAINER_PORT_SERVICE_PREFIX + name);
                if (containerPortNumber != null) {
                    containerPortSpec.setIntVal(containerPortNumber);
                } else {
                    containerPortSpec.setStrVal(containerPort);
                }
                servicePort.setTargetPort(containerPortSpec);
                String portProtocol = (String)serviceProtocolProperties.get(name);
                if (portProtocol != null) {
                    servicePort.setProtocol(portProtocol);
                }
                this.servicePorts.add(servicePort);
            }
            if (this.serviceContainerPort != null && this.servicePort != null) {
                if (this.servicePorts.size() > 0) {
                    throw new MojoExecutionException("Multi-port services must use the fabric8.service.port.<name> format");
                }
                ServicePort actualServicePort = new ServicePort();
                Integer containerPortNumber = this.parsePort(this.serviceContainerPort, FABRIC8_CONTAINER_PORT_SERVICE);
                IntOrString containerPort = new IntOrString();
                if (containerPortNumber != null) {
                    containerPort.setIntVal(containerPortNumber);
                } else {
                    containerPort.setStrVal(this.serviceContainerPort);
                }
                actualServicePort.setTargetPort(containerPort);
                actualServicePort.setPort(this.servicePort);
                if (this.serviceProtocol != null) {
                    actualServicePort.setProtocol(this.serviceProtocol);
                    this.servicePorts.add(actualServicePort);
                }
            }
        }
        return this.servicePorts;
    }

    protected static EnvVar getOrCreateEnv(Map<String, EnvVar> envMap, String name) {
        EnvVar answer = envMap.get(name);
        if (answer == null) {
            answer = new EnvVar();
            envMap.put(name, answer);
        }
        return answer;
    }

    protected Integer parsePort(String portText, String propertyName) {
        if (Strings.isNotBlank((String)portText)) {
            try {
                return Integer.parseInt(portText);
            }
            catch (NumberFormatException e) {
                this.getLog().debug((CharSequence)("Failed to parse port text: " + portText + " from maven property " + propertyName + ". " + e), (Throwable)e);
            }
        }
        return null;
    }

    public void setContainerPorts(List<ContainerPort> ports) {
        this.containerPorts = ports;
    }

    public void setServicePorts(List<ServicePort> ports) {
        this.servicePorts = ports;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        if (this.labels.isEmpty()) {
            this.labels = PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProject().getProperties(), (String)"fabric8.label.", (Function)Strings.toLowerCaseFunction());
        }
        return this.labels;
    }

    public List<EnvVar> getEnvironmentVariables() throws MojoExecutionException {
        if (this.environmentVariables == null) {
            this.environmentVariables = new ArrayList<EnvVar>();
        }
        if (this.environmentVariables.isEmpty()) {
            HashMap<String, EnvVar> envMap = new HashMap<String, EnvVar>();
            Map<String, String> envs = this.getExportedEnvironmentVariables();
            for (Map.Entry<String, String> entry : envs.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (name == null) continue;
                EnvVar env = JsonMojo.getOrCreateEnv(envMap, name);
                env.setName(name);
                if (env.getValue() != null) continue;
                env.setValue(value);
            }
            this.getLog().info((CharSequence)("Generated env mappings: " + envMap));
            this.getLog().debug((CharSequence)("from envs: " + envs));
            this.environmentVariables.addAll(envMap.values());
        }
        if (this.includeNamespaceEnvVar) {
            this.environmentVariables.add(((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName(this.kubernetesNamespaceEnvVar)).withNewValueFrom().withNewFieldRef().withFieldPath("metadata.namespace")).endFieldRef()).endValueFrom()).build());
        }
        return this.environmentVariables;
    }

    public Map<String, String> getExportedEnvironmentVariables() throws MojoExecutionException {
        if (this.includeAllEnvironmentVariables) {
            try {
                JsonSchema schema = this.getEnvironmentVariableJsonSchema();
                TreeMap<String, String> answer = new TreeMap<String, String>();
                Map<String, JsonSchemaProperty> properties = schema.getProperties();
                Set<Map.Entry<String, JsonSchemaProperty>> entries = properties.entrySet();
                for (Map.Entry<String, JsonSchemaProperty> entry : entries) {
                    String name = entry.getKey();
                    String value = entry.getValue().getDefaultValue();
                    if (value == null) {
                        value = "";
                    }
                    answer.put(name, value);
                }
                Map<String, String> mavenEnvVars = this.getEnvironmentVariableProperties();
                answer.putAll(mavenEnvVars);
                return answer;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load environment variable json schema files: " + e, (Exception)e);
            }
        }
        return this.getEnvironmentVariableProperties();
    }

    public List<VolumeMount> getVolumeMounts() {
        ArrayList<VolumeMount> volumeMount = new ArrayList<VolumeMount>();
        MavenProject project = this.getProject();
        for (Map.Entry<Object, Object> entry : project.getProperties().entrySet()) {
            String s;
            Matcher m;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(m = VOLUME_PATTERN.matcher(s = (String)key)).matches()) continue;
            String name = m.group(NAME);
            String type = m.group(ATTRIBUTE_TYPE);
            if (!type.equals(VOLUME_MOUNT_PATH)) continue;
            String path = String.valueOf(entry.getValue());
            volumeMount.add(((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(name)).withMountPath(path)).withReadOnly(Boolean.valueOf(false))).build());
        }
        return volumeMount;
    }

    public List<Volume> getVolumes() {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        MavenProject project = this.getProject();
        Properties properties = project.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String s;
            Matcher m;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(m = VOLUME_PATTERN.matcher(s = (String)key)).matches()) continue;
            String name = m.group(NAME);
            String type = m.group(ATTRIBUTE_TYPE);
            VolumeType volumeType = VolumeType.typeFor(type);
            if (volumeType == null) continue;
            volumes.add(volumeType.fromProperties(name, properties));
        }
        return volumes;
    }

    public Template getTemplate() throws MojoExecutionException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        MavenProject project = this.getProject();
        Properties projectProperties = project.getProperties();
        HashSet<String> paramNames = new HashSet<String>();
        if (this.templateParametersPropertiesFile != null && this.templateParametersPropertiesFile.isFile() && this.templateParametersPropertiesFile.exists()) {
            String valuePostfix = ".value";
            String descriptionPostfix = ".description";
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(this.templateParametersPropertiesFile));
                Set<Object> keys = properties.keySet();
                Properties prefixedProperties = new Properties();
                for (Object key : keys) {
                    if (key == null) continue;
                    String name = key.toString();
                    String value = properties.getProperty(name);
                    prefixedProperties.put("fabric8.parameter." + name, value);
                }
                this.loadParametersFromProperties(prefixedProperties, parameters, paramNames);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load templateParameters properties file " + this.templateParametersPropertiesFile + ". " + e, (Exception)e);
            }
        }
        this.loadParametersFromProperties(projectProperties, parameters, paramNames);
        String templateName = projectProperties.containsKey(TEMPLATE_NAME) ? String.valueOf(projectProperties.getProperty(TEMPLATE_NAME)) : project.getArtifactId();
        return ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(templateName)).endMetadata()).withParameters(parameters)).build();
    }

    protected void loadParametersFromProperties(Properties properties, List<Parameter> parameters, Set<String> paramNames) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name;
            String s;
            Matcher m;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(m = PARAM_PATTERN.matcher(s = (String)key)).matches() || !paramNames.add(name = m.group(NAME))) continue;
            String value = properties.getProperty(String.format(PARAMETER_PROPERTY, name, VALUE));
            String from = properties.getProperty(String.format(PARAMETER_PROPERTY, name, FROM));
            String description = properties.getProperty(String.format(PARAMETER_PROPERTY, name, DESCRIPTION));
            String generate = properties.getProperty(String.format(PARAMETER_PROPERTY, name, GENERATE));
            if (Strings.isNullOrBlank((String)value) && Strings.isNullOrBlank((String)from)) {
                value = properties.getProperty(String.format(PARAMETER_NAME_PREFIX, name));
            }
            this.getLog().info((CharSequence)("Found Template parameter: " + name + this.labelValueOrBlank(VALUE, value) + this.labelValueOrBlank(FROM, from) + this.labelValueOrBlank(GENERATE, generate) + this.labelValueOrBlank(DESCRIPTION, description)));
            parameters.add(((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)new ParameterBuilder().withName(name)).withFrom(from)).withValue(value)).withGenerate(generate)).withDescription(description)).build());
        }
    }

    private String labelValueOrBlank(String label, String value) {
        if (Strings.isNotBlank((String)value)) {
            return " " + label + ": " + value;
        }
        return "";
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    protected static void addIfNotDefined(Map<String, Object> variables, String key, String value) {
        if (!variables.containsKey(key)) {
            variables.put(key, value);
        }
    }
}

