/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.internal.HasMetadataComparator;
import io.fabric8.maven.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="apply", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractFabric8Mojo {
    @Component
    protected ArtifactResolver resolver;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(property="fabric8.apply.create", defaultValue="true")
    private boolean createNewResources;
    @Parameter(property="fabric8.apply.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @Parameter(property="fabric8.apply.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @Parameter(property="fabric8.apply.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @Parameter(property="fabric8.apply.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @Parameter(property="fabric8.apply.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @Parameter(property="fabric8.apply.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @Parameter(property="fabric8.apply.createRoutes", defaultValue="true")
    private boolean createRoutes;
    @Parameter(property="fabric8.apply.jsonLogDir", defaultValue="${basedir}/target/fabric8/applyJson")
    private File jsonLogDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        KubernetesClient kubernetes;
        File json = this.getKubernetesJson();
        if (!Files.isFile((File)json)) {
            if (Files.isFile((File)this.kubernetesSourceJson)) {
                json = this.kubernetesSourceJson;
            } else {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson);
                }
                this.getLog().warn((CharSequence)("No such generated kubernetes json file: " + json + " or source json file " + this.kubernetesSourceJson + " for this project so ignoring"));
                return;
            }
        }
        if ((kubernetes = this.getKubernetes()).getMasterUrl() == null || Strings.isNullOrBlank((String)kubernetes.getMasterUrl().toString())) {
            throw new MojoFailureException("Can't find Kubernetes master URL");
        }
        this.getLog().info((CharSequence)("Using kubernetes at: " + kubernetes.getMasterUrl() + " in namespace " + this.getNamespace()));
        this.getLog().info((CharSequence)("Kubernetes JSON: " + json));
        try {
            Controller controller = this.createController();
            controller.setAllowCreate(this.createNewResources);
            controller.setServicesOnlyMode(this.servicesOnly);
            controller.setIgnoreServiceMode(this.ignoreServices);
            controller.setLogJsonDir(this.jsonLogDir);
            controller.setBasedir(this.getRootProjectFolder());
            controller.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            controller.setProcessTemplatesLocally(this.processTemplatesLocally);
            controller.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
            boolean openShift = KubernetesHelper.isOpenShift((KubernetesClient)kubernetes);
            this.getLog().info((CharSequence)("Is OpenShift: " + openShift));
            if (!openShift) {
                this.disableOpenShiftFeatures(controller);
            }
            String fileName = json.getName();
            Object dto = KubernetesHelper.loadJson((File)json);
            if (dto == null) {
                throw new MojoFailureException("Could not load kubernetes json: " + json);
            }
            String namespace = this.getNamespace();
            controller.applyNamespace(namespace);
            controller.setNamespace(namespace);
            if (dto instanceof Template) {
                Template template = (Template)dto;
                dto = this.applyTemplates(template, kubernetes, controller, fileName);
            }
            LinkedHashSet<KubernetesList> kubeConfigs = new LinkedHashSet<KubernetesList>();
            if (!this.combineDependencies) {
                for (File dependency : this.getDependencies()) {
                    this.getLog().info((CharSequence)("Found dependency: " + dependency));
                    ApplyMojo.loadDependency(this.getLog(), kubeConfigs, dependency);
                }
            }
            TreeSet<HasMetadata> entities = new TreeSet<HasMetadata>((Comparator<HasMetadata>)new HasMetadataComparator());
            for (KubernetesList c : kubeConfigs) {
                entities.addAll(c.getItems());
            }
            entities.addAll(KubernetesHelper.toItemList((Object)dto));
            if (this.createRoutes) {
                this.createRoutes(kubernetes, entities);
            }
            this.addEnvironmentAnnotations(entities);
            for (HasMetadata entity : entities) {
                if (entity instanceof Pod) {
                    Pod pod = (Pod)entity;
                    controller.applyPod(pod, fileName);
                    continue;
                }
                if (entity instanceof Service) {
                    Service service = (Service)entity;
                    controller.applyService(service, fileName);
                    continue;
                }
                if (entity instanceof ReplicationController) {
                    ReplicationController replicationController = (ReplicationController)entity;
                    controller.applyReplicationController(replicationController, fileName);
                    continue;
                }
                if (entity == null) continue;
                controller.apply((Object)entity, fileName);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void disableOpenShiftFeatures(Controller controller) {
        this.processTemplatesLocally = true;
        this.createRoutes = false;
        controller.setSupportOAuthClients(false);
        controller.setProcessTemplatesLocally(true);
    }

    protected Object applyTemplates(Template template, KubernetesClient kubernetes, Controller controller, String fileName) throws Exception {
        KubernetesHelper.setNamespace((HasMetadata)template, (String)this.getNamespace());
        this.overrideTemplateParameters(template);
        return controller.applyTemplate(template, fileName);
    }

    protected void createRoutes(KubernetesClient kubernetes, Collection<HasMetadata> collection) {
        Object routes;
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        if (Strings.isNullOrBlank((String)routeDomainPostfix)) {
            log.warn((CharSequence)"No fabric8.domain property or $KUBERNETES_DOMAIN environment variable so cannot create any OpenShift Routes");
            return;
        }
        String namespace = this.getNamespace();
        try {
            routes = (RouteList)((ClientNonNamespaceOperation)((OpenShiftClient)kubernetes.adapt(OpenShiftClient.class)).routes().inNamespace(namespace)).list();
            if (routes != null) {
                List list = routes.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Could not load routes; we maybe are not connected to an OpenShift environment? " + e), (Throwable)e);
            return;
        }
        routes = new ArrayList();
        for (Object e : collection) {
            Service service;
            Route route;
            if (!(e instanceof Service) || (route = ApplyMojo.createRouteForService(routeDomainPostfix, namespace, service = (Service)e, log)) == null) continue;
            routes.add(route);
        }
        collection.addAll((Collection<HasMetadata>)routes);
    }

    public static Route createRouteForService(String routeDomainPostfix, String namespace, Service service, Log log) {
        Route route = null;
        String id = KubernetesHelper.getName((HasMetadata)service);
        if (Strings.isNotBlank((String)id) && ApplyMojo.shouldCreateRouteForService(log, service, id)) {
            route = new Route();
            String routeId = id;
            KubernetesHelper.setName((HasMetadata)route, (String)namespace, (String)routeId);
            RouteSpec routeSpec = new RouteSpec();
            ObjectReference objectRef = new ObjectReference();
            objectRef.setName(id);
            objectRef.setNamespace(namespace);
            routeSpec.setTo(objectRef);
            String host = Strings.stripSuffix((String)Strings.stripSuffix((String)id, (String)"-service"), (String)".");
            routeSpec.setHost(host + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)"."));
            route.setSpec(routeSpec);
            String json = null;
            try {
                json = KubernetesHelper.toJson((Object)route);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + route;
            }
            log.debug((CharSequence)("Created route: " + json));
        }
        return route;
    }

    protected static boolean shouldCreateRouteForService(Log log, Service service, String id) {
        if ("kubernetes".equals(id) || "kubernetes-ro".equals(id)) {
            return false;
        }
        Set ports = KubernetesHelper.getPorts((Service)service);
        log.debug((CharSequence)("Service " + id + " has ports: " + ports));
        if (ports.size() == 1) {
            return true;
        }
        log.info((CharSequence)("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports));
        return false;
    }

    public static void addConfig(Collection<KubernetesList> kubeConfigs, Object kubeCfg) {
        if (kubeCfg instanceof KubernetesList) {
            kubeConfigs.add((KubernetesList)kubeCfg);
        }
    }

    public static void loadDependency(Log log, Collection<KubernetesList> kubeConfigs, File file) throws IOException {
        if (file.isFile()) {
            log.info((CharSequence)("Loading file " + file));
            ApplyMojo.addConfig(kubeConfigs, KubernetesHelper.loadJson((File)file));
        } else {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    String name = child.getName().toLowerCase();
                    if (!name.endsWith(".json") && !name.endsWith(".yaml")) continue;
                    ApplyMojo.loadDependency(log, kubeConfigs, child);
                }
            }
        }
    }
}

