/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.ApplyMojo;
import io.fabric8.openshift.client.OpenShiftClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="clean", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CleanMojo
extends ApplyMojo {
    @Parameter(property="fabric8.deep.clean", defaultValue="false")
    private Boolean deep;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        KubernetesClient client = (KubernetesClient)this.getKubernetes().inNamespace(this.getNamespace());
        client.services().delete();
        client.replicationControllers().delete();
        client.pods().delete();
        client.endpoints().delete();
        client.events().delete();
        if (this.deep.booleanValue()) {
            client.secrets().delete();
            client.serviceAccounts().delete();
            client.securityContextConstraints().delete();
        }
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            openShiftClient.routes().delete();
            openShiftClient.builds().delete();
            openShiftClient.imageStreams().delete();
            openShiftClient.buildConfigs().delete();
            openShiftClient.deploymentConfigs().delete();
            openShiftClient.templates().delete();
            if (this.deep.booleanValue()) {
                openShiftClient.users().delete();
                openShiftClient.groups().delete();
                openShiftClient.policies().delete();
                openShiftClient.policyBindings().delete();
            }
        }
    }
}

