/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.gerrit.CreateRepositoryDTO;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.net.ConnectException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-gitrepo", requiresProject=false)
public class CreateGerritRepoMojo
extends AbstractNamespacedMojo {
    private static final String JSON_MAGIC = ")]}'";
    @Parameter(property="repo", required=true)
    private String repo;
    @Parameter(property="description", required=false)
    private String description;
    @Parameter(property="empty_commit", required=false, defaultValue="true")
    private String empty_commit;
    @Parameter(property="gerritAdminUsername", defaultValue="${GERRIT_ADMIN_USER}")
    private String gerritAdminUsername;
    @Parameter(property="gerritAdminPassword", defaultValue="${GERRIT_ADMIN_PWD}")
    private String gerritAdminPassword;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            KubernetesClient kubernetes = this.getKubernetes();
            Log log = this.getLog();
            String gerritUser = this.gerritAdminUsername;
            String gerritPwd = this.gerritAdminPassword;
            String repoName = this.repo;
            String description = this.description;
            String empty_commit = this.empty_commit;
            CreateGerritRepoMojo.createGerritRepo(kubernetes, this.getNamespace(), log, gerritUser, gerritPwd, repoName, description, empty_commit);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, e);
        }
    }

    private static boolean createGerritRepo(KubernetesClient kubernetes, String namespace, Log log, String gerritUser, String gerritPwd, String repoName, String description, String empty_commit) throws MojoExecutionException, IOException {
        if (Strings.isNullOrBlank((String)gerritUser)) {
            gerritUser = "admin";
        }
        if (Strings.isNullOrBlank((String)gerritPwd)) {
            gerritPwd = "secret";
        }
        String gerritAddress = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"gerrit", (String)namespace, (String)"http", (boolean)true);
        log.info((CharSequence)("Found gerrit address: " + gerritAddress + " for namespace: " + namespace + " on Kubernetes address: " + kubernetes.getMasterUrl()));
        if (Strings.isNullOrBlank((String)gerritAddress)) {
            throw new MojoExecutionException("No address for service gerrit in namespace: " + namespace + " on Kubernetes address: " + kubernetes.getMasterUrl());
        }
        log.info((CharSequence)("Querying Gerrit for namespace: " + namespace + " on Kubernetes address: " + kubernetes.getMasterUrl()));
        DefaultHttpClient httpclient = new DefaultHttpClient();
        DefaultHttpClient httpclientPost = new DefaultHttpClient();
        String GERRIT_URL = gerritAddress + "/a/projects/" + repoName;
        HttpGet httpget = new HttpGet(GERRIT_URL);
        System.out.println("Requesting : " + httpget.getURI());
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            System.out.println(response.getStatusLine());
            if (response.getStatusLine().getStatusCode() == 401) {
                Header authHeader = response.getFirstHeader("WWW-Authenticate");
                System.out.println("authHeader = " + authHeader);
                DigestScheme digestScheme = new DigestScheme();
                digestScheme.processChallenge(authHeader);
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials("admin", "secret");
                httpget.addHeader(digestScheme.authenticate((Credentials)creds, (HttpRequest)httpget, null));
                HttpPost httpPost = new HttpPost(GERRIT_URL);
                httpPost.addHeader(digestScheme.authenticate((Credentials)creds, (HttpRequest)httpPost, null));
                httpPost.addHeader("Content-Type", "application/json");
                CreateRepositoryDTO createRepoDTO = new CreateRepositoryDTO();
                createRepoDTO.setDescription("my cool git repo");
                createRepoDTO.setName(repoName);
                createRepoDTO.setCreate_empty_commit(Boolean.valueOf(empty_commit).booleanValue());
                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString((Object)createRepoDTO);
                StringEntity entity = new StringEntity(json);
                httpPost.setEntity((HttpEntity)entity);
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = (String)httpclientPost.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                System.out.println("responseBody : " + responseBody);
            }
        }
        catch (MalformedChallengeException e) {
            e.printStackTrace();
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            System.out.println("Gerrit Server is not responding");
        }
        catch (HttpResponseException e) {
            System.out.println("Response from Gerrit Server : " + e.getMessage());
            throw new MojoExecutionException("Repository " + repoName + " already exists !");
        }
        finally {
            httpclient.getConnectionManager().shutdown();
            httpclientPost.getConnectionManager().shutdown();
        }
        return false;
    }
}

