/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.utils.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractNamespacedMojo
extends AbstractMojo {
    @Parameter(property="fabric8.namespace")
    private String namespace;
    @Parameter(property="fabric8.domain", defaultValue="${env.KUBERNETES_DOMAIN}")
    protected String routeDomain;
    @Parameter(property="fabric8.apply.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="fabric8.recreate")
    protected boolean recreate;
    private KubernetesClient kubernetes;

    public KubernetesClient getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = new KubernetesClient();
        }
        if (Strings.isNotBlank((String)this.namespace)) {
            this.kubernetes.setNamespace(this.namespace);
        }
        return this.kubernetes;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.getKubernetes());
        controller.setThrowExceptionOnError(this.failOnError);
        controller.setRecreateMode(this.recreate);
        return controller;
    }

    protected String getNamespace() {
        return this.getKubernetes().getNamespace();
    }
}

