/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.letschat.LetsChatClient;
import io.fabric8.letschat.LetsChatKubernetes;
import io.fabric8.letschat.RoomDTO;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.maven.CreateGogsWebhook;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.taiga.ModuleDTO;
import io.fabric8.taiga.ProjectDTO;
import io.fabric8.taiga.TaigaClient;
import io.fabric8.taiga.TaigaKubernetes;
import io.fabric8.taiga.TaigaModule;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-build-config", requiresProject=false)
public class CreateBuildConfigMojo
extends AbstractNamespacedMojo {
    @Parameter(defaultValue="${basedir}")
    protected File basedir;
    @Parameter(property="fabric8.configFile", defaultValue="${basedir}/fabric8.yml")
    protected File projectConfigFile;
    @Parameter(property="fabric8.gogsUsername")
    protected String username;
    @Parameter(property="fabric8.gogsPassword")
    protected String password;
    @Parameter(property="fabric8.repoName", defaultValue="${project.artifactId}")
    protected String repoName;
    @Parameter(property="fabric8.fullName")
    protected String fullName;
    @Parameter(property="fabric8.gitUrl")
    protected String gitUrl;
    @Parameter(property="fabric8.webhookSecret", defaultValue="secret101")
    protected String secret;
    @Parameter(property="fabric8.buildImageStream", defaultValue="triggerJenkins")
    protected String buildImageStream;
    @Parameter(property="fabric8.buildImageTag", defaultValue="latest")
    protected String buildImageTag;
    @Parameter(property="fabric8.jenkinsJob")
    protected String jenkinsJob;
    @Parameter(property="fabric8.jenkinsMonitorView")
    protected String jenkinsMonitorView;
    @Parameter(property="fabric8.jenkinsPipelineView")
    protected String jenkinsPipelineView;
    @Parameter(property="fabric8.tagiaProjectName", defaultValue="${fabric8.repoName}")
    protected String taigaProjectName;
    @Parameter(property="fabric8.taigaProjectSlug")
    protected String taigaProjectSlug;
    @Parameter(property="fabric8.taigaProjectLinkPage", defaultValue="backlog")
    protected String taigaProjectLinkPage;
    @Parameter(property="fabric8.taigaProjectLinkLabel", defaultValue="Backlog")
    protected String taigaProjectLinkLabel;
    @Parameter(property="fabric8.taigaTeamLinkPage", defaultValue="team")
    protected String taigaTeamLinkPage;
    @Parameter(property="fabric8.taigaTeamLinkLabel", defaultValue="Team")
    protected String taigaTeamLinkLabel;
    @Parameter(property="fabric8.taigaAutoCreate", defaultValue="true")
    protected boolean taigaAutoCreate;
    @Parameter(property="fabric8.taigaEnabled", defaultValue="true")
    protected boolean taigaEnabled;
    @Parameter(property="fabric8.letschatEnabled", defaultValue="true")
    protected boolean letschatEnabled;
    @Parameter(property="fabric8.letschatRoomLinkLabel", defaultValue="Room")
    protected String letschatRoomLinkLabel;
    @Parameter(property="fabric8.letschatRoomLinkLabel", defaultValue="fabric8_${namespace}")
    protected String letschatRoomExpression;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String chatRoomLink;
        String taigaTeamLink;
        this.loadConfigFile();
        KubernetesClient kubernetes = this.getKubernetes();
        String name = this.repoName;
        if (Strings.isNotBlank((String)this.username)) {
            name = this.username + "-" + name;
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("user", this.username);
        labels.put("repo", this.repoName);
        TaigaClient taiga = null;
        ProjectDTO taigaProject = null;
        try {
            taiga = this.createTaiga();
            taigaProject = this.createTaigaProject(taiga);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to load or lazily create the Taiga project: " + e), (Throwable)e);
        }
        LetsChatClient letschat = null;
        try {
            letschat = this.createLetsChat();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to load or lazily create the LetsChat client: " + e), (Throwable)e);
        }
        HashMap<String, String> annotations = new HashMap<String, String>();
        String jenkinsJobUrl = null;
        try {
            String jenkinsUrl = kubernetes.getServiceURL("jenkins", kubernetes.getNamespace(), "http", true);
            if (Strings.isNotBlank((String)jenkinsUrl)) {
                if (Strings.isNotBlank((String)this.jenkinsMonitorView)) {
                    annotations.put("fabric8.link.jenkins.monitor/url", URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsMonitorView}));
                    annotations.put("fabric8.link.jenkins.monitor/label", "Monitor");
                }
                if (Strings.isNotBlank((String)this.jenkinsPipelineView)) {
                    annotations.put("fabric8.link.jenkins.pipeline/url", URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/view", this.jenkinsPipelineView}));
                    annotations.put("fabric8.link.jenkins.pipeline/label", "Pipeline");
                }
                if (Strings.isNotBlank((String)this.jenkinsJob)) {
                    jenkinsJobUrl = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/job", this.jenkinsJob});
                    annotations.put("fabric8.link.jenkins.job/url", jenkinsJobUrl);
                    annotations.put("fabric8.link.jenkins.job/label", "Job");
                }
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Could not find the Jenkins URL!: " + e), (Throwable)e);
        }
        String taigaLink = this.getProjectPageLink(taiga, taigaProject, this.taigaProjectLinkPage);
        if (Strings.isNotBlank((String)taigaLink)) {
            annotations.put("fabric8.link.taiga/url", taigaLink);
            annotations.put("fabric8.link.taiga/label", this.taigaProjectLinkLabel);
        }
        if (Strings.isNotBlank((String)(taigaTeamLink = this.getProjectPageLink(taiga, taigaProject, this.taigaTeamLinkPage)))) {
            annotations.put("fabric8.link.taiga.team/url", taigaTeamLink);
            annotations.put("fabric8.link.taiga.team/label", this.taigaTeamLinkLabel);
        }
        if (Strings.isNotBlank((String)(chatRoomLink = this.getChatRoomLink(letschat)))) {
            annotations.put("fabric8.link.letschat.room/url", chatRoomLink);
            annotations.put("fabric8.link.letschat.room/label", this.letschatRoomLinkLabel);
        }
        BuildConfigFluent.SpecNested specBuilder = ((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(name)).withLabels(labels)).withAnnotations(annotations)).endMetadata()).withNewSpec();
        if (Strings.isNotBlank((String)this.gitUrl)) {
            specBuilder = (BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildSourceFluent.GitNested)((BuildConfigSpecFluent.SourceNested)specBuilder.withNewSource().withType("Git")).withNewGit().withUri(this.gitUrl)).endGit()).endSource();
        }
        if (Strings.isNotBlank((String)this.buildImageStream) && Strings.isNotBlank((String)this.buildImageTag)) {
            specBuilder = (BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((BuildConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Docker")).withNewDockerStrategy().withNewFrom().withName(this.buildImageStream + ":" + this.buildImageTag)).endFrom()).endDockerStrategy()).endStrategy();
        }
        BuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GenericNested)((BuildConfigSpecFluent.TriggersNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GithubNested)((BuildConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("github")).withNewGithub().withSecret(this.secret)).endGithub()).endTrigger()).addNewTrigger().withType("generic")).withNewGeneric().withSecret(this.secret)).endGeneric()).endTrigger()).endSpec()).build();
        Controller controller = this.createController();
        controller.applyBuildConfig(buildConfig, "maven");
        this.getLog().info((CharSequence)("Created build configuration for " + name + " in namespace: " + controller.getNamespace() + " at " + kubernetes.getAddress()));
        this.createJenkinsWebhook(jenkinsJobUrl);
        this.createTaigaWebhook(taiga, taigaProject);
    }

    protected void loadConfigFile() {
        if (this.projectConfigFile != null && this.projectConfigFile.exists() && this.projectConfigFile.isFile()) {
            this.getLog().info((CharSequence)("Parsing fabric8 devops project configuration from: " + this.projectConfigFile.getName()));
            ProjectConfig projectConfig = null;
            try {
                projectConfig = ProjectConfigs.parseProjectConfig((File)this.projectConfigFile);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to parse " + this.projectConfigFile));
            }
            if (projectConfig != null) {
                String issueProjectName;
                String chatRoom = projectConfig.getChatRoom();
                if (Strings.isNotBlank((String)chatRoom)) {
                    this.getLog().info((CharSequence)("Found chat room: " + chatRoom));
                    this.letschatRoomExpression = chatRoom;
                }
                if (Strings.isNotBlank((String)(issueProjectName = projectConfig.getIssueProjectName()))) {
                    this.taigaProjectName = issueProjectName;
                }
            }
        } else {
            this.getLog().info((CharSequence)("No fabric8.yml file found for " + this.basedir));
        }
        if (Strings.isNullOrBlank((String)this.gitUrl)) {
            try {
                this.gitUrl = GitHelpers.extractGitUrl((File)this.basedir);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Could not load git URL from directory: " + e), (Throwable)e);
            }
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
            this.taigaProjectName = this.repoName;
        }
        if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
            this.taigaProjectSlug = this.taigaProjectName;
        }
    }

    protected String getChatRoomLink(LetsChatClient letschat) {
        if (letschat != null) {
            String roomId;
            RoomDTO room;
            String url = letschat.getAddress();
            String slug = this.evaluateRoomExpression(this.letschatRoomExpression);
            if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && (room = letschat.getOrCreateRoom(slug)) != null && Strings.isNotBlank((String)(roomId = room.getId()))) {
                return URLUtils.pathJoin((String[])new String[]{url, "/#!/room/" + roomId});
            }
        }
        return null;
    }

    protected String evaluateRoomExpression(String roomExpresion) {
        if (Strings.isNotBlank((String)roomExpresion)) {
            String namespace = this.getKubernetes().getNamespace();
            if (namespace == null) {
                namespace = KubernetesClient.defaultNamespace();
            }
            String answer = roomExpresion;
            answer = this.replaceExpression(answer, "namespace", namespace);
            answer = this.replaceExpression(answer, "repoName", this.repoName);
            answer = this.replaceExpression(answer, "username", this.username);
            return answer;
        }
        return null;
    }

    protected String replaceExpression(String text, String key, String value) {
        if (Strings.isNotBlank((String)key) && Strings.isNotBlank((String)value)) {
            String replace = "${" + key + "}";
            return text.replace(replace, value);
        }
        return text;
    }

    protected LetsChatClient createLetsChat() {
        if (!this.letschatEnabled) {
            return null;
        }
        KubernetesClient kubernetes = this.getKubernetes();
        LetsChatClient letsChat = LetsChatKubernetes.createLetsChat((KubernetesClient)kubernetes);
        if (letsChat == null) {
            this.getLog().warn((CharSequence)("No letschat service availble n kubernetes " + kubernetes.getNamespace() + " on address: " + kubernetes.getAddress()));
            return null;
        }
        if (!letsChat.isValid()) {
            this.getLog().warn((CharSequence)"No $LETSCHAT_HUBOT_TOKEN environment variable defined so LetsChat support is disabled");
            return null;
        }
        return letsChat;
    }

    protected TaigaClient createTaiga() {
        if (!this.taigaEnabled) {
            return null;
        }
        TaigaClient taiga = TaigaKubernetes.createTaiga((KubernetesClient)this.getKubernetes());
        if (taiga != null) {
            taiga.setAutoCreateProjects(this.taigaAutoCreate);
        }
        return taiga;
    }

    protected String getProjectPageLink(TaigaClient taiga, ProjectDTO taigaProject, String projectRelativePage) {
        if (taiga != null && taigaProject != null) {
            String url = taiga.getAddress();
            String slug = taigaProject.getSlug();
            if (Strings.isNullOrBlank((String)slug)) {
                slug = this.taigaProjectSlug;
            }
            String userName = taiga.getUsername();
            if (Strings.isNullOrBlank((String)slug)) {
                slug = userName + "-" + this.taigaProjectName;
            }
            if (Strings.isNotBlank((String)url) && Strings.isNotBlank((String)slug) && Strings.isNotBlank((String)projectRelativePage)) {
                return URLUtils.pathJoin((String[])new String[]{url, "/project/", slug + "/", projectRelativePage});
            }
        }
        return null;
    }

    protected void createJenkinsWebhook(String jenkinsJobUrl) {
        if (Strings.isNotBlank((String)jenkinsJobUrl)) {
            String jenkinsWebHook = URLUtils.pathJoin((String[])new String[]{jenkinsJobUrl, "/build"});
            this.createWebhook(jenkinsWebHook, this.secret);
        }
    }

    protected ProjectDTO createTaigaProject(TaigaClient taiga) {
        if (taiga != null) {
            if (Strings.isNullOrBlank((String)this.taigaProjectName)) {
                this.getLog().info((CharSequence)"Not creating Taiga project as no `fabric8.tagiaProjectName` property specified");
                return null;
            }
            if (Strings.isNullOrBlank((String)this.taigaProjectSlug)) {
                this.getLog().info((CharSequence)"Not creating Taiga project as no `fabric8.taigaProjectSlug` property specified");
                return null;
            }
            this.getLog().info((CharSequence)("About to create Taiga project " + this.taigaProjectName + " with slug: " + this.taigaProjectSlug));
            return taiga.getOrCreateProject(this.taigaProjectName, this.taigaProjectSlug);
        }
        return null;
    }

    protected void createTaigaWebhook(TaigaClient taiga, ProjectDTO project) {
        if (taiga != null && project != null) {
            Long projectId = project.getId();
            ModuleDTO module = taiga.moduleForProject(projectId, TaigaModule.GOGS);
            if (module != null) {
                String webhookSecret = module.getSecret();
                String webhook = taiga.getPublicWebhookUrl(module);
                if (Strings.isNotBlank((String)webhookSecret) && Strings.isNotBlank((String)webhook)) {
                    this.createWebhook(webhook, webhookSecret);
                } else {
                    this.getLog().warn((CharSequence)("Could not create webhook for Taiga. Missing module data for url: " + webhook + " secret: " + webhookSecret));
                }
            } else {
                this.getLog().warn((CharSequence)"No module for gogs so cannot create Taiga webhook");
            }
        }
    }

    protected void createWebhook(String url, String webhookSecret) {
        try {
            CreateGogsWebhook.createGogsWebhook(this.getKubernetes(), this.getLog(), this.username, this.password, this.repoName, url, webhookSecret);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to create webhook " + url + " on repository " + this.repoName + ". Reason: " + e), (Throwable)e);
        }
    }
}

