/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.gerrit.CreateRepositoryDTO;
import io.fabric8.gerrit.GitApi;
import io.fabric8.gerrit.ProjectInfoDTO;
import io.fabric8.gerrit.RepositoryDTO;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.JsonHelper;
import io.fabric8.utils.cxf.WebClients;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-gitrepo", requiresProject=false)
public class CreateGerritRepoMojo
extends AbstractNamespacedMojo {
    private static final String JSON_MAGIC = ")]}'";
    @Parameter(property="repo", required=true)
    private String repo;
    @Parameter(property="description", required=false)
    private String description;
    @Parameter(property="empty_commit", required=false, defaultValue="true")
    private String empty_commit;
    @Parameter(property="gerritAdminUsername", defaultValue="${GERRIT_ADMIN_USER}")
    private String gerritAdminUsername;
    @Parameter(property="gerritAdminPassword", defaultValue="${GERRIT_ADMIN_PWD}")
    private String gerritAdminPassword;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            KubernetesClient kubernetes = this.getKubernetes();
            Log log = this.getLog();
            String gerritUser = this.gerritAdminUsername;
            String gerritPwd = this.gerritAdminPassword;
            String repoName = this.repo;
            String description = this.description;
            String empty_commit = this.empty_commit;
            CreateGerritRepoMojo.createGerritRepo(kubernetes, log, gerritUser, gerritPwd, repoName, description, empty_commit);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, e);
        }
    }

    private static boolean createGerritRepo(KubernetesClient kubernetes, Log log, String gerritUser, String gerritPwd, String repoName, String description, String empty_commit) throws MojoExecutionException, JsonProcessingException {
        ProjectInfoDTO project;
        block7: {
            if (Strings.isNullOrBlank((String)gerritUser)) {
                gerritUser = "admin";
            }
            if (Strings.isNullOrBlank((String)gerritPwd)) {
                gerritPwd = "secret";
            }
            String namespace = kubernetes.getNamespace();
            String gerritAddress = kubernetes.getServiceURL("gerrit", namespace, "http", true);
            log.info((CharSequence)("Found gerrit address: " + gerritAddress + " for namespace: " + namespace + " on Kubernetes address: " + kubernetes.getAddress()));
            if (Strings.isNullOrBlank((String)gerritAddress)) {
                throw new MojoExecutionException("No address for service gerrit in namespace: " + namespace + " on Kubernetes address: " + kubernetes.getAddress());
            }
            log.info((CharSequence)("Querying Gerrit for namespace: " + namespace + " on Kubernetes address: " + kubernetes.getAddress()));
            List providers = WebClients.createProviders();
            providers.add(new RemovePrefix());
            WebClient webClient = WebClient.create((String)gerritAddress, (List)providers);
            WebClients.disableSslChecks((WebClient)webClient);
            WebClients.configureUserAndPassword((WebClient)webClient, (String)gerritUser, (String)gerritPwd);
            WebClients.enableDigestAuthenticaionType((WebClient)webClient);
            GitApi gitApi = (GitApi)JAXRSClientFactory.fromClient((Client)webClient, GitApi.class);
            project = null;
            try {
                project = gitApi.getRepository(repoName);
            }
            catch (WebApplicationException ex) {
                if (ex.getResponse().getStatus() != Response.Status.NOT_FOUND.getStatusCode()) break block7;
                CreateRepositoryDTO createRepoDTO = new CreateRepositoryDTO();
                createRepoDTO.setDescription(description);
                createRepoDTO.setName(repoName);
                createRepoDTO.setCreate_empty_commit(Boolean.valueOf(empty_commit).booleanValue());
                RepositoryDTO repository = gitApi.createRepository(repoName, createRepoDTO);
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Git Repo created : " + JsonHelper.toJson((Object)repository)));
                }
                log.info((CharSequence)("Created git repo for " + repoName + " for namespace: " + namespace + " on gogs URL: " + gerritAddress));
                return true;
            }
        }
        if (project != null && project.getName().equals(repoName)) {
            throw new MojoExecutionException("Repository " + repoName + " already exists !");
        }
        return false;
    }

    @Priority(value=1000)
    protected static class RemovePrefix
    implements ReaderInterceptor {
        protected RemovePrefix() {
        }

        public Object aroundReadFrom(ReaderInterceptorContext interceptorContext) throws IOException, WebApplicationException {
            String line;
            InputStream in = interceptorContext.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder received = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                received.append(line);
            }
            String s = received.toString();
            s = s.replace(CreateGerritRepoMojo.JSON_MAGIC, "");
            System.out.println("Reader Interceptor removing the prefix invoked.");
            System.out.println("Content cleaned : " + s);
            String responseContent = new String(s);
            interceptorContext.setInputStream((InputStream)new ByteArrayInputStream(responseContent.getBytes()));
            return interceptorContext.proceed();
        }
    }
}

