/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.maven.core.config.ResourceConfiguration;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class DefaultReplicaSetEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig"};
    private ReplicationControllerHandler rcHandler;
    private ReplicaSetHandler rsHandler;

    public DefaultReplicaSetEnricher(EnricherContext buildContext) {
        super(buildContext);
        HandlerHub handlers = new HandlerHub(buildContext.getProject());
        this.rcHandler = handlers.getReplicationControllerHandler();
        this.rsHandler = handlers.getReplicaSetHandler();
    }

    public String getName() {
        return "default.rs";
    }

    public void enrich(KubernetesListBuilder builder) {
        ResourceConfiguration config = new ResourceConfiguration.Builder().replicaSetName(this.getConfig().get("name", MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0]))).imagePullPolicy(this.getConfig().get("imagePullPolicy", "IfNotPresent")).build();
        ReplicaSet defaultReplicaSet = this.rsHandler.getReplicaSet(config, this.getImages());
        if (this.hasPodControllers(builder)) {
            PodSpec podSpec;
            PodTemplateSpec template;
            ReplicaSetSpec spec = defaultReplicaSet.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null && (podSpec = template.getSpec()) != null) {
                builder.accept((Visitor)new Visitor<PodSpecBuilder>(){

                    public void visit(PodSpecBuilder builder) {
                        DefaultReplicaSetEnricher.this.mergePodSpec(builder, podSpec);
                    }
                });
            }
        } else if (this.getConfig().getAsBoolean("useReplicaSet", true)) {
            this.log.info("Adding a default ReplicaSet");
            builder.addToReplicaSetItems(new ReplicaSet[]{defaultReplicaSet});
        } else {
            this.log.info("Adding a default ReplicationController");
            builder.addToReplicationControllerItems(new ReplicationController[]{this.rcHandler.getReplicationController(config, this.getImages())});
        }
    }

    private void mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec) {
        List containers = builder.getContainers();
        List defaultContainers = defaultPodSpec.getContainers();
        int size = defaultContainers.size();
        if (size > 0) {
            if (containers == null || containers.isEmpty()) {
                builder.addToContainers(defaultContainers.toArray(new Container[size]));
            } else {
                int idx = 0;
                for (Container defaultContainer : defaultContainers) {
                    Container container;
                    if (idx < containers.size()) {
                        container = (Container)containers.get(idx);
                    } else {
                        container = new Container();
                        containers.add(container);
                    }
                    if (Strings.isNullOrBlank((String)container.getImagePullPolicy())) {
                        container.setImagePullPolicy(defaultContainer.getImagePullPolicy());
                    }
                    if (Strings.isNullOrBlank((String)container.getImage())) {
                        container.setImage(defaultContainer.getImage());
                    }
                    if (Strings.isNullOrBlank((String)container.getName())) {
                        container.setName(defaultContainer.getName());
                    }
                    ++idx;
                }
                builder.withContainers(containers);
            }
        }
    }

    private boolean hasPodControllers(KubernetesListBuilder builder) {
        return this.checkForKind(builder, POD_CONTROLLER_KINDS);
    }

    private boolean checkForKind(KubernetesListBuilder builder, String ... kinds) {
        HashSet<String> kindSet = new HashSet<String>(Arrays.asList(kinds));
        for (HasMetadata item : builder.getItems()) {
            if (!kindSet.contains(item.getKind())) continue;
            return true;
        }
        return false;
    }
}

