/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import java.util.Map;

public abstract class SelectorVisitor<T>
implements Visitor<T> {
    protected final EnricherManager enricher;

    public SelectorVisitor(EnricherManager enricher) {
        this.enricher = enricher;
    }

    public abstract void visit(T var1);

    public static class ReplicaSet
    extends SelectorVisitor<ReplicaSetSpecBuilder> {
        public ReplicaSet(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        public void visit(ReplicaSetSpecBuilder item) {
            item.withSelector(this.createLabelSelector(this.enricher.extractSelector(Kind.REPLICA_SET)));
        }

        private LabelSelector createLabelSelector(Map<String, String> labelSelector) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(labelSelector)).build();
        }
    }

    public static class ReplicationController
    extends SelectorVisitor<ReplicationControllerSpecBuilder> {
        public ReplicationController(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        public void visit(ReplicationControllerSpecBuilder item) {
            item.getSelector().putAll(this.enricher.extractSelector(Kind.REPLICATION_CONTROLLER));
        }
    }

    public static class Deployment
    extends SelectorVisitor<DeploymentSpecBuilder> {
        public Deployment(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        public void visit(DeploymentSpecBuilder item) {
            Map<String, String> selectorMatchLabels = this.enricher.extractSelector(Kind.REPLICATION_CONTROLLER);
            LabelSelector selector = item.getSelector();
            if (selector == null) {
                ((DeploymentSpecFluent.SelectorNested)item.withNewSelector().addToMatchLabels(selectorMatchLabels)).endSelector();
            } else {
                selector.getMatchLabels().putAll(selectorMatchLabels);
            }
        }
    }

    public static class Service
    extends SelectorVisitor<ServiceSpecBuilder> {
        public Service(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        public void visit(ServiceSpecBuilder item) {
            item.getSelector().putAll(this.enricher.extractSelector(Kind.SERVICE));
        }
    }
}

