/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.maven.core.config.ResourceConfiguration;
import io.fabric8.maven.core.config.ResourceMode;
import io.fabric8.maven.core.config.ServiceConfiguration;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.customizer.ImageConfigCustomizerManager;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resource", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ResourceMojo
extends AbstractFabric8Mojo {
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}")
    private File target;
    @Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @Parameter(property="fabric8.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="fabric8.mode")
    private ResourceMode mode = ResourceMode.kubernetes;
    @Parameter
    private ResourceConfiguration resources;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter
    private Map<String, String> enricher;
    @Parameter
    private Map<String, String> customizer;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.artifactType", defaultValue="yml")
    private String artifactType;
    @Parameter(property="fabric8.artifactClassifier", defaultValue="kubernetes")
    private String artifactClassifier;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    private HandlerHub handlerHub;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.log = new AnsiLogger(this.getLog(), this.getBooleanConfigProperty("useColor", true), this.getBooleanConfigProperty("verbose", false), "F8> ");
            this.handlerHub = new HandlerHub(this.project);
            this.resolvedImages = this.resolveImages(this.images, this.log);
            EnricherManager enricherManager = new EnricherManager(new EnricherContext(this.project, this.enricher, this.resolvedImages, this.resources, this.log));
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                KubernetesList resources = this.generateResourceDescriptor(enricherManager, this.resolvedImages);
                File outputFile = KubernetesResourceUtil.writeResourceDescriptor((KubernetesList)resources, (File)this.getTargetFile(), (ResourceFileType)this.resourceFileType);
                this.projectHelper.attachArtifact(this.project, this.artifactType, this.artifactClassifier, outputFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private File getTargetFile() {
        return new File(this.target, this.mode.getFileName());
    }

    private List<ImageConfiguration> resolveImages(List<ImageConfiguration> images, Logger log) {
        final Properties resolveProperties = this.project.getProperties();
        List ret = ConfigHelper.resolveImages(images, (ConfigHelper.Resolver)new ConfigHelper.Resolver(){

            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return ResourceMojo.this.imageConfigResolver.resolve(image, resolveProperties);
            }
        }, null, (ConfigHelper.Customizer)new ConfigHelper.Customizer(){

            public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
                return ImageConfigCustomizerManager.customize(configs, ResourceMojo.this.customizer, ResourceMojo.this.project);
            }
        });
        ConfigHelper.initAndValidate((List)ret, null, (Logger)log);
        return ret;
    }

    private KubernetesList generateResourceDescriptor(EnricherManager enricherManager, List<ImageConfiguration> images) throws IOException, MojoExecutionException {
        KubernetesListBuilder builder;
        File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.resourceDir);
        ReplicationControllerHandler rcHandler = this.handlerHub.getReplicationControllerHandler();
        if (resourceFiles != null && resourceFiles.length > 0) {
            this.log.info("Using resource templates from %s", new Object[]{this.resourceDir});
            builder = KubernetesResourceUtil.readResourceFragmentsFrom((String)"v1", (String)"extensions/v1beta1", (File[])this.filterFiles(resourceFiles));
        } else {
            builder = new KubernetesListBuilder();
        }
        if (this.resources != null) {
            this.log.info("Adding resources from plugin configuration");
            this.addServices(builder, this.resources.getServices(), this.resources.getAnnotations().getService());
            builder.addToReplicationControllerItems(new ReplicationController[]{rcHandler.getReplicationController(this.resources, images)});
        }
        enricherManager.enrichLabels(builder);
        enricherManager.addMissingSelectors(builder);
        enricherManager.customize(builder);
        return builder.build();
    }

    private File[] filterFiles(File[] resourceFiles) throws MojoExecutionException {
        if (!this.workDir.exists() && !this.workDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + this.workDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(this.workDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private void addServices(KubernetesListBuilder builder, List<ServiceConfiguration> serviceConfig, Map<String, String> annotations) {
        if (serviceConfig != null) {
            ServiceHandler serviceHandler = this.handlerHub.getServiceHandler();
            builder.addToServiceItems(this.toArray(serviceHandler.getServices(serviceConfig, annotations)));
        }
    }

    private Service[] toArray(List<Service> services) {
        if (services == null) {
            return new Service[0];
        }
        if (services instanceof ArrayList) {
            return ((ArrayList)services).toArray(new Service[services.size()]);
        }
        Service[] ret = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ret[i] = services.get(i);
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.resourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }
}

