/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.maven.core.handler.Containers;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class DefaultImageEnricher
extends BaseEnricher {
    public DefaultImageEnricher(EnricherContext buildContext) {
        super(buildContext);
    }

    public String getName() {
        return "default.image";
    }

    public void enrich(KubernetesListBuilder builder) {
        builder.accept((Visitor)new Visitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder item) {
                DefaultImageEnricher.this.getOrCreateContainerList(item);
            }
        });
        builder.accept((Visitor)new Visitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder item) {
                DefaultImageEnricher.this.getOrCreateContainerList(item);
            }
        });
    }

    private List<Container> getOrCreateContainerList(ReplicaSetBuilder rs) {
        PodTemplateSpec template;
        ReplicaSetSpec spec = rs.getSpec();
        if (spec == null) {
            spec = new ReplicaSetSpec();
            rs.withSpec(spec);
        }
        if ((template = spec.getTemplate()) == null) {
            template = new PodTemplateSpec();
            spec.setTemplate(template);
        }
        return this.getOrCreateContainerList(template);
    }

    private List<Container> getOrCreateContainerList(ReplicationControllerBuilder rc) {
        PodTemplateSpec template;
        ReplicationControllerSpec spec = rc.getSpec();
        if (spec == null) {
            spec = new ReplicationControllerSpec();
            rc.withSpec(spec);
        }
        if ((template = spec.getTemplate()) == null) {
            template = new PodTemplateSpec();
            spec.setTemplate(template);
        }
        return this.getOrCreateContainerList(template);
    }

    private List<Container> getOrCreateContainerList(PodTemplateSpec template) {
        ArrayList<Container> containers;
        PodSpec podSpec = template.getSpec();
        if (podSpec == null) {
            podSpec = new PodSpec();
            template.setSpec(podSpec);
        }
        if ((containers = podSpec.getContainers()) == null) {
            containers = new ArrayList<Container>();
            podSpec.setContainers(containers);
        }
        this.defaultContainerImages(this.getConfig().get("pullPolicy", "IfNotPresent"), containers);
        podSpec.setContainers(containers);
        return containers;
    }

    private void defaultContainerImages(String imagePullPolicy, List<Container> containers) {
        int idx = 0;
        List images = this.getImages();
        if (images.isEmpty()) {
            this.log.warn("No resolved images!");
        }
        for (ImageConfiguration imageConfiguration : images) {
            Container container;
            if (idx < containers.size()) {
                container = containers.get(idx);
            } else {
                container = new Container();
                containers.add(container);
            }
            if (Strings.isNullOrBlank((String)container.getImagePullPolicy())) {
                container.setImagePullPolicy(imagePullPolicy);
            }
            if (Strings.isNullOrBlank((String)container.getImage())) {
                container.setImage(imageConfiguration.getName());
            }
            if (Strings.isNullOrBlank((String)container.getName())) {
                container.setName(Containers.getKubernetesContainerName((MavenProject)this.getProject(), (ImageConfiguration)imageConfiguration));
            }
            ++idx;
        }
    }
}

