/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import org.apache.maven.project.MavenProject;

public class DefaultNameEnricher
extends BaseEnricher {
    public DefaultNameEnricher(EnricherContext buildContext) {
        super(buildContext);
    }

    public String getName() {
        return "default.name";
    }

    public void enrich(KubernetesListBuilder builder) {
        final String defaultName = this.getConfig().get("", MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0]));
        builder.accept((Visitor)new Visitor<HasMetadata>(){

            public void visit(HasMetadata resource) {
                ObjectMeta metadata = DefaultNameEnricher.this.getOrCreateMetadata(resource);
                if (Strings.isNullOrBlank((String)metadata.getName())) {
                    metadata.setName(defaultName);
                }
            }
        });
        builder.accept((Visitor)new Visitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder resource) {
                DeploymentFluent.MetadataNested metadata = resource.editMetadata();
                if (metadata == null) {
                    ((DeploymentFluent.MetadataNested)resource.withNewMetadata().withName(defaultName)).endMetadata();
                } else if (Strings.isNullOrBlank((String)metadata.getName())) {
                    ((DeploymentFluent.MetadataNested)metadata.withName(defaultName)).endMetadata();
                }
            }
        });
        builder.accept((Visitor)new Visitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder resource) {
                ReplicationControllerFluent.MetadataNested metadata = resource.editMetadata();
                if (metadata == null) {
                    ((ReplicationControllerFluent.MetadataNested)resource.withNewMetadata().withName(defaultName)).endMetadata();
                } else if (Strings.isNullOrBlank((String)metadata.getName())) {
                    ((ReplicationControllerFluent.MetadataNested)metadata.withName(defaultName)).endMetadata();
                }
            }
        });
        builder.accept((Visitor)new Visitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder resource) {
                ReplicaSetFluent.MetadataNested metadata = resource.editMetadata();
                if (metadata == null) {
                    ((ReplicaSetFluent.MetadataNested)resource.withNewMetadata().withName(defaultName)).endMetadata();
                } else if (Strings.isNullOrBlank((String)metadata.getName())) {
                    ((ReplicaSetFluent.MetadataNested)metadata.withName(defaultName)).endMetadata();
                }
            }
        });
    }

    private ObjectMeta getOrCreateMetadata(HasMetadata resource) {
        ObjectMeta metadata = resource.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            resource.setMetadata(metadata);
        }
        return metadata;
    }
}

