/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class ProjectInfoEnricher
extends BaseEnricher {
    public ProjectInfoEnricher(EnricherContext buildContext) {
        super(buildContext, "label.project");
    }

    public Map<String, String> getLabels(Kind kind) {
        MavenProject project = this.getProject();
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("version", project.getVersion());
        ret.put("project", project.getArtifactId());
        ret.put("group", project.getGroupId());
        ret.put("provider", "fabric8");
        return ret;
    }

    public Map<String, String> getSelector(Kind kind) {
        Map<String, String> ret = this.getLabels(kind);
        if (kind == Kind.SERVICE || kind == Kind.DEPLOYMENT || kind == Kind.DEPLOYMENT_CONFIG) {
            return ProjectInfoEnricher.removeVersionSelector(ret);
        }
        return ret;
    }

    public static Map<String, String> removeVersionSelector(Map<String, String> selector) {
        HashMap<String, String> answer = new HashMap<String, String>(selector);
        answer.remove("version");
        return answer;
    }
}

