/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import java.util.HashMap;
import java.util.Map;

public abstract class MetadataEnricherVisitor<T>
implements Visitor<T> {
    private final EnricherManager enricher;

    private MetadataEnricherVisitor(EnricherManager enricher) {
        this.enricher = enricher;
    }

    public void visit(T item) {
        ObjectMeta metadata = this.getOrCreateMetadata(item);
        this.overlayMap(metadata.getLabels(), this.enricher.extractLabels(this.getKind()));
        this.overlayMap(metadata.getAnnotations(), this.enricher.extractAnnotations(this.getKind()));
    }

    private void overlayMap(Map<String, String> targetMap, Map<String, String> enrichMap) {
        targetMap = this.getOrCreateMap(targetMap);
        enrichMap = this.getOrCreateMap(enrichMap);
        for (Map.Entry<String, String> entry : enrichMap.entrySet()) {
            if (targetMap.containsKey(entry.getKey())) continue;
            targetMap.put(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Kind getKind();

    protected abstract ObjectMeta getOrCreateMetadata(T var1);

    private Map<String, String> getOrCreateMap(Map<String, String> labels) {
        return labels != null ? labels : new HashMap();
    }

    public static class Deployment
    extends MetadataEnricherVisitor<DeploymentBuilder> {
        public Deployment(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.DEPLOYMENT;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DeploymentBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((DeploymentBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class ReplicationController
    extends MetadataEnricherVisitor<ReplicationControllerBuilder> {
        public ReplicationController(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICATION_CONTROLLER;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicationControllerBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((ReplicationControllerBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class ReplicaSet
    extends MetadataEnricherVisitor<ReplicaSetBuilder> {
        public ReplicaSet(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICA_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicaSetBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((ReplicaSetBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class Service
    extends MetadataEnricherVisitor<ServiceBuilder> {
        public Service(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.SERVICE;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ServiceBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((ServiceBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }

    public static class PodTemplate
    extends MetadataEnricherVisitor<PodTemplateSpecBuilder> {
        public PodTemplate(EnricherManager enricher) {
            super(enricher);
        }

        @Override
        protected Kind getKind() {
            return Kind.POD_TEMPLATE;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(PodTemplateSpecBuilder item) {
            ObjectMeta ret = item.getMetadata();
            return ret == null ? ((PodTemplateSpecBuilder)item.withNewMetadata().endMetadata()).getMetadata() : ret;
        }
    }
}

