/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildMojo
extends io.fabric8.maven.docker.BuildMojo {
    static final String FABRIC8_DOCKER_SKIP_POM = "fabric8.docker.skip.pom";
    @Deprecated
    @Parameter
    Map<String, String> customizer;
    @Parameter
    Map<String, String> generator;
    @Parameter(property="fabric8.docker.skip.pom")
    boolean disablePomPackaging;

    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.project != null && this.disablePomPackaging && Objects.equals("pom", this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Disabling docker build for pom packaging due to property: fabric8.docker.skip.pom");
            return;
        }
        super.executeInternal(hub);
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        return GeneratorManager.generate(configs, this.generator != null ? this.generator : this.customizer, this.project, this.log);
    }

    protected String getLogPrefix() {
        return "F8> ";
    }
}

