/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildMojo
extends io.fabric8.maven.docker.BuildMojo {
    @Deprecated
    @Parameter
    Map<String, String> customizer;
    @Parameter
    Map<String, String> generator;
    @Parameter(property="fabric8.build.skip.pom", defaultValue="true")
    boolean skipPomBuilds;
    @Parameter(property="fabric8.build.mode")
    PlatformMode buildMode;
    @Parameter(property="fabric8.build.recreate", defaultValue="false")
    boolean recreateBuildConfig;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    private ClusterAccess clusterAccess;

    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.project != null && this.skipPomBuilds && Objects.equals("pom", this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Disabling docker build for pom packaging");
            return;
        }
        super.executeInternal(hub);
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        if (this.buildMode == PlatformMode.kubernetes) {
            super.buildAndTag(hub, imageConfig);
        } else if (this.buildMode == PlatformMode.openshift) {
            this.executeOpenShiftBuild(hub, imageConfig);
        } else {
            throw new MojoExecutionException("Unknown platform mode " + this.buildMode);
        }
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        return GeneratorManager.generate(configs, this.generator != null ? this.generator : this.customizer, this.project, this.log);
    }

    protected String getLogPrefix() {
        return "F8> ";
    }

    private void executeOpenShiftBuild(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException {
        MojoParameters params = this.createMojoParameters();
        ImageName imageName = new ImageName(imageConfig.getName());
        File dockerTar = hub.getArchiveService().createDockerBuildArchive(imageConfig, params);
        OpenShiftClient client = this.getOpenShiftClient();
        KubernetesListBuilder builder = new KubernetesListBuilder();
        String buildName = imageName.getSimpleName() + "-build";
        String imageStreamName = imageName.getSimpleName();
        this.checkOrCreateBuildConfig(client, builder, buildName, imageStreamName, imageName.getTag());
        this.checkOrCreateImageStream(client, builder, imageStreamName);
        this.createResourceObjects(client, builder);
        this.startBuild(dockerTar, client, buildName);
    }

    private OpenShiftClient getOpenShiftClient() throws MojoExecutionException {
        ClusterAccess access = new ClusterAccess(this.namespace);
        OpenShiftClient client = access.createOpenShiftClient();
        if (!KubernetesHelper.isOpenShift((KubernetesClient)client)) {
            throw new MojoExecutionException("Cannot create OpenShift Docker build with a non-OpenShift cluster at " + client.getMasterUrl());
        }
        return client;
    }

    private void startBuild(File dockerTar, OpenShiftClient client, String buildName) {
        this.log.info("Starting build %s", new Object[]{buildName});
        ((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).instantiateBinary().fromFile(dockerTar);
    }

    private void createResourceObjects(OpenShiftClient client, KubernetesListBuilder builder) {
        KubernetesList k8sList = builder.build();
        if (k8sList.getItems().size() != 0) {
            client.lists().create((Object[])new KubernetesList[]{k8sList});
        }
    }

    private void checkOrCreateImageStream(OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((ClientResource)client.imageStreams().withName(imageStreamName)).get() != null;
        if (hasImageStream && this.recreateBuildConfig) {
            ((ClientResource)client.imageStreams().withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            ((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.MetadataNested)builder.addNewImageStreamItem().withNewMetadata().withName(imageStreamName)).endMetadata()).endImageStreamItem();
        } else {
            this.log.info("Using ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private void checkOrCreateBuildConfig(OpenShiftClient client, KubernetesListBuilder builder, String buildName, String imageStreamName, String imageTag) {
        boolean hasBuildConfig;
        boolean bl = hasBuildConfig = ((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).get() != null;
        if (hasBuildConfig && this.recreateBuildConfig) {
            ((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).delete();
            hasBuildConfig = false;
        }
        if (!hasBuildConfig) {
            this.log.info("Creating BuildConfig %s for Docker build", new Object[]{buildName});
            ((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.MetadataNested)builder.addNewBuildConfigItem().withNewMetadata().withName(buildName)).endMetadata()).withNewSpec().withNewStrategy().withType("Docker")).endStrategy()).withNewSource().withType("Binary")).endSource()).withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(imageStreamName + ":" + imageTag)).endTo()).endOutput()).endSpec()).endBuildConfigItem();
        } else {
            this.log.info("Using BuildConfig %s", new Object[]{buildName});
        }
    }
}

