/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.internal.HasMetadataComparator;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class DeployMojo
extends AbstractFabric8Mojo {
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.domain")
    protected String routeDomain;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.failOnError", defaultValue="true")
    protected boolean failOnError;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.create", defaultValue="true")
    private boolean createNewResources;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.rolling", defaultValue="false")
    private boolean rollingUpgrades;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.createExternalUrls", defaultValue="true")
    private boolean createExternalUrls;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.deploy.jsonLogDir", defaultValue="${basedir}/target/fabric8/applyJson")
    private File jsonLogDir;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.namespace")
    private String namespace;
    private ClusterAccess clusterAccess;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File manifest;
        this.clusterAccess = new ClusterAccess(this.namespace);
        KubernetesClient kubernetes = this.clusterAccess.createKubernetesClient();
        String clusterKind = "Kubernetes";
        if (KubernetesHelper.isOpenShift((KubernetesClient)kubernetes)) {
            manifest = this.openshiftManifest;
            clusterKind = "OpenShift";
        } else {
            manifest = this.kubernetesManifest;
        }
        if (!Files.isFile((File)manifest)) {
            if (this.failOnNoKubernetesJson) {
                throw new MojoFailureException("No such generated manifest file: " + manifest);
            }
            this.log.warn("No such generated manifest file %s for this project so ignoring", new Object[]{manifest});
            return;
        }
        if (kubernetes.getMasterUrl() == null || Strings.isNullOrBlank((String)kubernetes.getMasterUrl().toString())) {
            throw new MojoFailureException("Cannot find Kubernetes master URL");
        }
        this.log.info("Using %s at %s in namespace %s with manifest %s ", new Object[]{clusterKind, kubernetes.getMasterUrl(), this.clusterAccess.getNamespace(), manifest});
        try {
            Controller controller = this.createController();
            controller.setAllowCreate(this.createNewResources);
            controller.setServicesOnlyMode(this.servicesOnly);
            controller.setIgnoreServiceMode(this.ignoreServices);
            controller.setLogJsonDir(this.jsonLogDir);
            controller.setBasedir(this.getRootProjectFolder());
            controller.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            controller.setProcessTemplatesLocally(this.processTemplatesLocally);
            controller.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
            controller.setRollingUpgrade(this.rollingUpgrades);
            controller.setRollingUpgradePreserveScale(this.isRollingUpgradePreserveScale());
            boolean openShift = KubernetesHelper.isOpenShift((KubernetesClient)kubernetes);
            if (openShift) {
                this.getLog().info((CharSequence)"OpenShift platform detected");
            } else {
                this.disableOpenShiftFeatures(controller);
            }
            String fileName = manifest.getName();
            Object dto = KubernetesHelper.loadYaml((File)manifest, KubernetesResource.class);
            if (dto == null) {
                throw new MojoFailureException("Cannot load kubernetes YAML: " + manifest);
            }
            String namespace = this.clusterAccess.getNamespace();
            controller.applyNamespace(namespace);
            controller.setNamespace(namespace);
            if (dto instanceof Template) {
                Template template = (Template)dto;
                dto = this.applyTemplates(template, kubernetes, controller, fileName);
            }
            LinkedHashSet resources = new LinkedHashSet();
            TreeSet<HasMetadata> entities = new TreeSet<HasMetadata>((Comparator<HasMetadata>)new HasMetadataComparator());
            for (KubernetesResource resource : resources) {
                entities.addAll(KubernetesHelper.toItemList((Object)resource));
            }
            entities.addAll(KubernetesHelper.toItemList((Object)dto));
            if (this.createExternalUrls) {
                if (controller.getOpenShiftClientOrNull() != null) {
                    this.createRoutes(controller, entities);
                } else {
                    this.createIngress(controller, kubernetes, entities);
                }
            }
            for (HasMetadata entity : entities) {
                if (entity instanceof Pod) {
                    Pod pod = (Pod)entity;
                    controller.applyPod(pod, fileName);
                    continue;
                }
                if (entity instanceof Service) {
                    Service service = (Service)entity;
                    controller.applyService(service, fileName);
                    continue;
                }
                if (entity instanceof ReplicationController) {
                    ReplicationController replicationController = (ReplicationController)entity;
                    controller.applyReplicationController(replicationController, fileName);
                    continue;
                }
                if (entity == null) continue;
                controller.apply((Object)entity, fileName);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public static Route createRouteForService(String routeDomainPostfix, String namespace, Service service, Log log) {
        Route route = null;
        String id = KubernetesHelper.getName((HasMetadata)service);
        if (Strings.isNotBlank((String)id) && DeployMojo.shouldCreateExternalURLForService(log, service, id)) {
            String json;
            route = new Route();
            String routeId = id;
            KubernetesHelper.setName((HasMetadata)route, (String)namespace, (String)routeId);
            RouteSpec routeSpec = new RouteSpec();
            ObjectReference objectRef = new ObjectReference();
            objectRef.setName(id);
            objectRef.setNamespace(namespace);
            routeSpec.setTo(objectRef);
            if (!Strings.isNullOrBlank((String)routeDomainPostfix)) {
                String host = Strings.stripSuffix((String)Strings.stripSuffix((String)id, (String)"-service"), (String)".");
                routeSpec.setHost(host + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)"."));
            } else {
                routeSpec.setHost("");
            }
            route.setSpec(routeSpec);
            try {
                json = KubernetesHelper.toJson((Object)route);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + route;
            }
            log.debug((CharSequence)("Created route: " + json));
        }
        return route;
    }

    public static Ingress createIngressForService(String routeDomainPostfix, String namespace, Service service, Log log) {
        Ingress ingress = null;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        ServiceSpec serviceSpec = service.getSpec();
        if (serviceSpec != null && Strings.isNotBlank((String)serviceName) && DeployMojo.shouldCreateExternalURLForService(log, service, serviceName)) {
            String json;
            String ingressId = serviceName;
            String host = "";
            if (Strings.isNotBlank((String)routeDomainPostfix)) {
                host = serviceName + "-" + namespace + "." + Strings.stripPrefix((String)routeDomainPostfix, (String)".");
            }
            ArrayList<HTTPIngressPath> paths = new ArrayList<HTTPIngressPath>();
            List ports = serviceSpec.getPorts();
            if (ports != null) {
                for (ServicePort port : ports) {
                    Integer portNumber = port.getPort();
                    if (portNumber == null) continue;
                    HTTPIngressPath path = ((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)new HTTPIngressPathBuilder().withNewBackend().withServiceName(serviceName)).withServicePort(KubernetesHelper.createIntOrString((int)portNumber))).endBackend()).build();
                    paths.add(path);
                }
            }
            if (paths.isEmpty()) {
                return ingress;
            }
            ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(ingressId)).withNamespace(namespace)).endMetadata()).withNewSpec().addNewRule().withHost(host)).withNewHttp().withPaths(paths)).endHttp()).endRule()).endSpec()).build();
            try {
                json = KubernetesHelper.toJson((Object)ingress);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + ingress;
            }
            log.debug((CharSequence)("Created ingress: " + json));
        }
        return ingress;
    }

    protected static boolean shouldCreateExternalURLForService(Log log, Service service, String id) {
        if ("kubernetes".equals(id) || "kubernetes-ro".equals(id)) {
            return false;
        }
        Set ports = KubernetesHelper.getPorts((Service)service);
        log.debug((CharSequence)("Service " + id + " has ports: " + ports));
        if (ports.size() == 1) {
            String type = null;
            ServiceSpec spec = service.getSpec();
            if (spec != null && Objects.equals(type = spec.getType(), "LoadBalancer")) {
                return true;
            }
            log.info((CharSequence)("Not generating route for service " + id + " type is not LoadBalancer: " + type));
            return false;
        }
        log.info((CharSequence)("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports));
        return false;
    }

    public boolean isRollingUpgrades() {
        return this.rollingUpgrades;
    }

    public boolean isRollingUpgradePreserveScale() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected void disableOpenShiftFeatures(Controller controller) {
        this.processTemplatesLocally = true;
        controller.setSupportOAuthClients(false);
        controller.setProcessTemplatesLocally(true);
    }

    protected Object applyTemplates(Template template, KubernetesClient kubernetes, Controller controller, String fileName) throws Exception {
        KubernetesHelper.setNamespace((HasMetadata)template, (String)this.clusterAccess.getNamespace());
        this.overrideTemplateParameters(template);
        return controller.applyTemplate(template, fileName);
    }

    protected void overrideTemplateParameters(Template template) {
        List parameters = template.getParameters();
        MavenProject project = this.getProject();
        if (parameters != null && project != null) {
            Properties properties = this.getProjectAndFabric8Properties(project);
            boolean missingProperty = false;
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                String name = "fabric8.apply." + parameterName;
                String propertyValue = properties.getProperty(name);
                if (propertyValue != null) {
                    this.getLog().info((CharSequence)("Overriding template parameter " + name + " with value: " + propertyValue));
                    parameter.setValue(propertyValue);
                    continue;
                }
                missingProperty = true;
                this.getLog().info((CharSequence)("No property defined for template parameter: " + name));
            }
            if (missingProperty) {
                this.getLog().debug((CharSequence)("Current properties " + new TreeSet<Object>(properties.keySet())));
            }
        }
    }

    protected Properties getProjectAndFabric8Properties(MavenProject project) {
        Properties properties = project.getProperties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    protected void createRoutes(Controller controller, Collection<HasMetadata> collection) {
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        try {
            OpenShiftClient openshiftClient = controller.getOpenShiftClientOrNull();
            if (openshiftClient == null) {
                return;
            }
            RouteList routes = (RouteList)((ClientNonNamespaceOperation)openshiftClient.routes().inNamespace(namespace)).list();
            if (routes != null) {
                routes.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load OpenShift Routes; maybe not connected to an OpenShift platform? " + e), (Throwable)e);
            return;
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        for (HasMetadata object : collection) {
            Service service;
            Route route;
            if (!(object instanceof Service) || (route = DeployMojo.createRouteForService(routeDomainPostfix, namespace, service = (Service)object, log)) == null) continue;
            routes.add(route);
        }
        collection.addAll(routes);
    }

    protected void createIngress(Controller controller, KubernetesClient kubernetesClient, Collection<HasMetadata> collection) {
        Object ingresses;
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        List ingressList = null;
        try {
            ingresses = (IngressList)((ClientNonNamespaceOperation)kubernetesClient.extensions().ingresses().inNamespace(namespace)).list();
            if (ingresses != null) {
                ingressList = ingresses.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load Ingress instances. Must be an older version of Kubernetes? Error: " + e), (Throwable)e);
            return;
        }
        ingresses = new ArrayList();
        for (HasMetadata object : collection) {
            if (!(object instanceof Service)) continue;
            Service service = (Service)object;
            if (!this.serviceHasIngressRule(ingressList, service)) {
                Ingress ingress = DeployMojo.createIngressForService(routeDomainPostfix, namespace, service, log);
                if (ingress != null) {
                    ingresses.add(ingress);
                    log.info((CharSequence)("Created ingress for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                    continue;
                }
                log.debug((CharSequence)("No ingress required for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                continue;
            }
            log.info((CharSequence)("Already has ingress for service " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
        }
        collection.addAll((Collection<HasMetadata>)ingresses);
    }

    private boolean serviceHasIngressRule(List<Ingress> ingresses, Service service) {
        List rules;
        Ingress ingress;
        IngressSpec spec;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        Iterator<Ingress> iterator = ingresses.iterator();
        while (iterator.hasNext() && (spec = (ingress = iterator.next()).getSpec()) != null && (rules = spec.getRules()) != null) {
            List paths;
            IngressRule rule;
            HTTPIngressRuleValue http;
            Iterator iterator2 = rules.iterator();
            while (iterator2.hasNext() && (http = (rule = (IngressRule)iterator2.next()).getHttp()) != null && (paths = http.getPaths()) != null) {
                HTTPIngressPath path;
                IngressBackend backend;
                Iterator iterator3 = paths.iterator();
                while (iterator3.hasNext() && (backend = (path = (HTTPIngressPath)iterator3.next()).getBackend()) != null) {
                    if (!Objects.equals(serviceName, backend.getServiceName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Controller createController() {
        Controller controller = new Controller(this.clusterAccess.createKubernetesClient());
        controller.setThrowExceptionOnError(this.failOnError);
        controller.setRecreateMode(this.recreate);
        this.getLog().debug((CharSequence)("Using recreate mode: " + this.recreate));
        return controller;
    }

    public String getRouteDomain() {
        return this.routeDomain;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isRecreate() {
        return this.recreate;
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }

    protected MavenProject getRootProject() {
        MavenProject parent;
        MavenProject project = this.getProject();
        while (project != null && (parent = project.getParent()) != null) {
            project = parent;
        }
        return project;
    }
}

