/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.docker;

import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.plugin.customizer.ImageConfigCustomizerManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.INSTALL)
public class BuildMojo
extends io.fabric8.maven.docker.BuildMojo {
    static final String FABRIC8_DOCKER_SKIP_POM = "fabric8.docker.skip.pom";
    @Parameter
    Map<String, String> customizer;
    @Parameter(property="fabric8.docker.skip.pom")
    boolean disablePomPackaging;

    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.project != null && this.disablePomPackaging && Objects.equals("pom", this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Disabling docker build for pom packaging due to property: fabric8.docker.skip.pom");
            return;
        }
        super.executeInternal(hub);
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        return ImageConfigCustomizerManager.customize(configs, this.customizer, this.project);
    }

    protected String getLogPrefix() {
        return "F8> ";
    }
}

