/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.maven.core.config.ServiceConfiguration;
import io.fabric8.maven.core.config.ServiceProtocol;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;

public class DefaultServiceEnricher
extends BaseEnricher {
    ServiceHandler serviceHandler;

    public DefaultServiceEnricher(EnricherContext buildContext) {
        super(buildContext);
        HandlerHub handlers = new HandlerHub(buildContext.getProject());
        this.serviceHandler = handlers.getServiceHandler();
    }

    public String getName() {
        return "default.service";
    }

    public void enrich(KubernetesListBuilder builder) {
        ServiceConfiguration defaultServiceConfig = this.extractDefaultServiceConfig();
        final Service defaultService = this.serviceHandler.getService(defaultServiceConfig, null);
        if (this.hasServices(builder)) {
            builder.accept((Visitor)new Visitor<ServiceBuilder>(){

                public void visit(ServiceBuilder service) {
                    DefaultServiceEnricher.this.mergeServices(service, defaultService);
                }
            });
        } else {
            this.log.info("Adding a default Service with ports [%s]", new Object[]{this.formatPortsAsList(defaultService.getSpec().getPorts())});
            builder.addToServiceItems(new Service[]{defaultService});
        }
    }

    private ServiceConfiguration extractDefaultServiceConfig() {
        List<ServiceConfiguration.Port> ports = this.extractPortsFromImageConfiguration(this.getImages());
        ServiceConfiguration.Builder ret = new ServiceConfiguration.Builder();
        ret.name(this.getConfig().get("name", MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0])));
        if (ports.size() > 0) {
            ret.ports(ports);
        } else {
            ret.headless(true);
        }
        ret.type(this.getConfig().get("type"));
        return ret.build();
    }

    private List<ServiceConfiguration.Port> extractPortsFromImageConfiguration(List<ImageConfiguration> images) {
        ArrayList<ServiceConfiguration.Port> ret = new ArrayList<ServiceConfiguration.Port>();
        for (ImageConfiguration image : images) {
            List ports;
            BuildImageConfiguration buildConfig = image.getBuildConfiguration();
            if (buildConfig == null || (ports = buildConfig.getPorts()) == null) continue;
            for (String port : ports) {
                int portI = Integer.parseInt(port);
                ret.add(new ServiceConfiguration.Port.Builder().protocol(ServiceProtocol.TCP).port(portI).targetPort(portI).build());
            }
        }
        return ret;
    }

    private String formatPortsAsList(List<ServicePort> ports) {
        ArrayList<String> p = new ArrayList<String>();
        for (ServicePort port : ports) {
            IntOrString targetPort = port.getTargetPort();
            String val = targetPort.getStrVal();
            if (val == null) {
                val = Integer.toString(targetPort.getIntVal());
            }
            p.add(val);
        }
        return StringUtils.join(p.iterator(), (String)",");
    }

    private void mergeServices(ServiceBuilder loadedService, Service defaultService) {
        ServiceSpec matchedSpec;
        if (defaultService == null) {
            return;
        }
        ObjectMeta loadedMetadata = loadedService.getMetadata();
        if (loadedMetadata == null) {
            loadedMetadata = defaultService.getMetadata();
            loadedService.withNewMetadataLike(loadedMetadata).endMetadata();
        }
        String name = KubernetesHelper.getName((ObjectMeta)loadedMetadata);
        String defaultServiceName = KubernetesHelper.getName((HasMetadata)defaultService);
        if (Strings.isNullOrBlank((String)name)) {
            ((ServiceFluent.MetadataNested)loadedService.withNewMetadataLike(loadedMetadata).withName(defaultServiceName)).endMetadata();
            name = KubernetesHelper.getName((ObjectMeta)loadedService.getMetadata());
        }
        if (Objects.equals(name, defaultServiceName) && (matchedSpec = defaultService.getSpec()) != null) {
            ServiceFluent.SpecNested loadedSpec = loadedService.editSpec();
            if (loadedSpec == null) {
                loadedService.withNewSpecLike(matchedSpec).endSpec();
            } else {
                List ports = loadedSpec.getPorts();
                if (ports == null || ports.isEmpty()) {
                    ((ServiceFluent.SpecNested)loadedSpec.withPorts(matchedSpec.getPorts())).endSpec();
                } else {
                    List matchedPorts = matchedSpec.getPorts();
                    if (matchedPorts != null) {
                        for (ServicePort matchedPort : matchedPorts) {
                            if (this.hasPort(ports, matchedPort)) continue;
                            ports.add(matchedPort);
                        }
                    }
                    ((ServiceFluent.SpecNested)loadedSpec.withPorts(ports)).endSpec();
                }
            }
        }
    }

    private boolean hasPort(List<ServicePort> ports, ServicePort port) {
        for (ServicePort aPort : ports) {
            if (!Objects.equals(port.getPort(), aPort.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean hasServices(KubernetesListBuilder builder) {
        for (HasMetadata item : builder.getItems()) {
            if (!"Service".equals(item.getKind())) continue;
            return true;
        }
        return false;
    }
}

