/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.MetadataEnricherVisitor;
import io.fabric8.maven.plugin.enricher.SelectorVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnricherManager {
    private List<Enricher> enrichers;
    private final List<? extends MetadataEnricherVisitor<?>> metaDataEnricherVisitors;
    private final List<? extends SelectorVisitor<?>> selectorVisitors;

    public EnricherManager(EnricherContext buildContext) {
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)buildContext);
        this.enrichers = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8-enricher-default", "META-INF/fabric8-enricher"});
        Collections.reverse(this.enrichers);
        this.metaDataEnricherVisitors = Arrays.asList(new MetadataEnricherVisitor.Deployment(this), new MetadataEnricherVisitor.ReplicaSet(this), new MetadataEnricherVisitor.ReplicationController(this), new MetadataEnricherVisitor.Service(this), new MetadataEnricherVisitor.PodTemplate(this));
        this.selectorVisitors = Arrays.asList(new SelectorVisitor.Deployment(this), new SelectorVisitor.ReplicaSet(this), new SelectorVisitor.ReplicationController(this), new SelectorVisitor.Service(this));
    }

    public void enrichLabels(KubernetesListBuilder builder) {
        this.visit(builder, this.metaDataEnricherVisitors);
    }

    public void addMissingSelectors(KubernetesListBuilder builder) {
        for (SelectorVisitor<?> visitor : this.selectorVisitors) {
            builder.accept(visitor);
        }
    }

    public void enrich(KubernetesListBuilder builder) {
        for (Enricher enricher : this.enrichers) {
            enricher.enrich(builder);
        }
    }

    Map<String, String> extractLabels(Kind kind) {
        return this.extract(Extractor.LABEL_EXTRACTOR, kind);
    }

    Map<String, String> extractAnnotations(Kind kind) {
        return this.extract(Extractor.ANNOTATION_EXTRACTOR, kind);
    }

    Map<String, String> extractSelector(Kind kind) {
        return this.extract(Extractor.SELECTOR_EXTRACTOR, kind);
    }

    private Map<String, String> extract(Extractor extractor, Kind kind) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Enricher enricher : this.enrichers) {
            this.putAllIfNotNull(ret, extractor.extract(enricher, kind));
        }
        return ret;
    }

    public void addEnricher(Enricher enricher) {
        this.enrichers.add(enricher);
    }

    private void putAllIfNotNull(Map<String, String> ret, Map<String, String> toPut) {
        if (toPut != null) {
            ret.putAll(toPut);
        }
    }

    private void visit(KubernetesListBuilder builder, List<? extends MetadataEnricherVisitor<?>> visitors) {
        for (MetadataEnricherVisitor<?> visitor : visitors) {
            builder.accept(visitor);
        }
    }

    static enum Extractor {
        LABEL_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getLabels(kind);
            }
        }
        ,
        ANNOTATION_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getAnnotations(kind);
            }
        }
        ,
        SELECTOR_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getSelector(kind);
            }
        };


        abstract Map<String, String> extract(Enricher var1, Kind var2);
    }
}

