/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategy;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.maven.core.config.ResourceConfiguration;
import io.fabric8.maven.core.config.ResourceMode;
import io.fabric8.maven.core.config.ServiceConfiguration;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.customizer.ImageConfigCustomizerManager;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resource", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractFabric8Mojo {
    private static final String PROPERTY_DOCKER_LABEL = "fabric8.docker.label";
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}")
    private File target;
    @Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @Parameter(property="fabric8.enrichedResourcesDir", defaultValue="${project.build.outputDirectory}/META-INF/fabric8")
    private File enrichedResourcesDir;
    @Parameter(property="fabric8.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private ResourceConfiguration resources;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter
    private Map<String, String> enricher;
    @Parameter
    private Map<String, String> customizer;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="fabric8.artifactType", defaultValue="yml")
    private String artifactType;
    @Parameter(property="fabric8.kubernetesArtifactClassifier", defaultValue="kubernetes")
    private String kubernetesArtifactClassifier;
    @Parameter(property="fabric8.openshiftArtifactClassifier", defaultValue="openshift")
    private String openshiftArtifactClassifier;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    private HandlerHub handlerHub;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.defineCustomProperties(this.project);
            this.handlerHub = new HandlerHub(this.project);
            this.resolvedImages = this.resolveImages(this.images, this.log);
            URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader((MavenProject)this.project);
            EnricherManager enricherManager = new EnricherManager(new EnricherContext(this.project, this.enricher, this.resolvedImages, this.resources, compileClassLoader, this.log));
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                KubernetesList resources = this.generateResourceDescriptor(enricherManager, this.resolvedImages);
                KubernetesList openShiftResources = this.createOpenShiftResources(resources);
                this.enrichedResourcesDir.mkdirs();
                File kubernetesFile = KubernetesResourceUtil.writeResourceDescriptor((KubernetesList)resources, (File)new File(this.target, ResourceMode.kubernetes.getFileName()), (ResourceFileType)this.resourceFileType, (File)this.enrichedResourcesDir, (Logger)this.log);
                this.projectHelper.attachArtifact(this.project, this.artifactType, this.kubernetesArtifactClassifier, kubernetesFile);
                File openshiftFile = KubernetesResourceUtil.writeResourceDescriptor((KubernetesList)openShiftResources, (File)new File(this.target, ResourceMode.openshift.getFileName()), (ResourceFileType)this.resourceFileType, (File)this.enrichedResourcesDir, (Logger)this.log);
                this.projectHelper.attachArtifact(this.project, this.artifactType, this.openshiftArtifactClassifier, openshiftFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private KubernetesList createOpenShiftResources(KubernetesList resources) {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        builder.withMetadata(resources.getMetadata());
        List items = resources.getItems();
        if (items != null) {
            for (HasMetadata item : items) {
                HasMetadata openshiftItem = this.convertToOpenShift(item);
                if (openshiftItem == null) continue;
                builder.addToItems(new HasMetadata[]{openshiftItem});
            }
        }
        return builder.build();
    }

    private HasMetadata convertToOpenShift(HasMetadata item) {
        if (item instanceof ReplicaSet) {
            ReplicaSet resource = (ReplicaSet)item;
            ReplicationControllerBuilder builder = new ReplicationControllerBuilder();
            builder.withMetadata(resource.getMetadata());
            ReplicaSetSpec spec = resource.getSpec();
            if (spec != null) {
                PodTemplateSpec template;
                Map matchLabels;
                LabelSelector selector;
                ReplicationControllerFluent.SpecNested specBuilder = builder.withNewSpec();
                Integer replicas = spec.getReplicas();
                if (replicas != null) {
                    specBuilder.withReplicas(replicas);
                }
                if ((selector = spec.getSelector()) != null && (matchLabels = selector.getMatchLabels()) != null && !matchLabels.isEmpty()) {
                    specBuilder.withSelector(matchLabels);
                }
                if ((template = spec.getTemplate()) != null) {
                    specBuilder.withTemplate(template);
                }
                specBuilder.endSpec();
            }
            return builder.build();
        }
        if (item instanceof Deployment) {
            Deployment resource = (Deployment)item;
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder();
            builder.withMetadata(resource.getMetadata());
            DeploymentSpec spec = resource.getSpec();
            if (spec != null) {
                DeploymentStrategy strategy;
                PodTemplateSpec template;
                Map matchLabels;
                LabelSelector selector;
                DeploymentConfigFluent.SpecNested specBuilder = builder.withNewSpec();
                Integer replicas = spec.getReplicas();
                if (replicas != null) {
                    specBuilder.withReplicas(replicas);
                }
                if ((selector = spec.getSelector()) != null && (matchLabels = selector.getMatchLabels()) != null && !matchLabels.isEmpty()) {
                    specBuilder.withSelector(matchLabels);
                }
                if ((template = spec.getTemplate()) != null) {
                    specBuilder.withTemplate(template);
                }
                if ((strategy = spec.getStrategy()) != null) {
                    // empty if block
                }
                ((DeploymentConfigSpecFluent.TriggersNested)specBuilder.addNewTrigger().withType("ConfigChange")).endTrigger();
                specBuilder.endSpec();
            }
            return builder.build();
        }
        return item;
    }

    private void defineCustomProperties(MavenProject project) {
        Properties properties = project.getProperties();
        String label = properties.getProperty(PROPERTY_DOCKER_LABEL);
        if (label == null) {
            label = project.getVersion();
            if (label.endsWith("-SNAPSHOT")) {
                label = "latest";
            }
            properties.setProperty(PROPERTY_DOCKER_LABEL, label);
        }
    }

    private List<ImageConfiguration> resolveImages(List<ImageConfiguration> images, Logger log) {
        final Properties resolveProperties = this.project.getProperties();
        List ret = ConfigHelper.resolveImages(images, (ConfigHelper.Resolver)new ConfigHelper.Resolver(){

            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return ResourceMojo.this.imageConfigResolver.resolve(image, resolveProperties);
            }
        }, null, (ConfigHelper.Customizer)new ConfigHelper.Customizer(){

            public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
                return ImageConfigCustomizerManager.customize(configs, ResourceMojo.this.customizer, ResourceMojo.this.project);
            }
        });
        ConfigHelper.initAndValidate((List)ret, null, (Logger)log);
        return ret;
    }

    private KubernetesList generateResourceDescriptor(EnricherManager enricherManager, List<ImageConfiguration> images) throws IOException, MojoExecutionException {
        KubernetesListBuilder builder;
        File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.resourceDir);
        ReplicationControllerHandler rcHandler = this.handlerHub.getReplicationControllerHandler();
        if (resourceFiles != null && resourceFiles.length > 0) {
            this.log.info("Using resource templates from %s", new Object[]{this.resourceDir});
            builder = KubernetesResourceUtil.readResourceFragmentsFrom((String)"v1", (String)"extensions/v1beta1", (File[])this.filterFiles(resourceFiles));
        } else {
            builder = new KubernetesListBuilder();
        }
        if (this.resources != null) {
            this.log.info("Adding resources from plugin configuration");
            this.addServices(builder, this.resources.getServices(), this.resources.getAnnotations().getService());
            builder.addToReplicationControllerItems(new ReplicationController[]{rcHandler.getReplicationController(this.resources, images)});
        }
        enricherManager.enrich(builder);
        enricherManager.enrichLabels(builder);
        enricherManager.addMissingSelectors(builder);
        return builder.build();
    }

    private File[] filterFiles(File[] resourceFiles) throws MojoExecutionException {
        if (!this.workDir.exists() && !this.workDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + this.workDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(this.workDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private void addServices(KubernetesListBuilder builder, List<ServiceConfiguration> serviceConfig, Map<String, String> annotations) {
        if (serviceConfig != null) {
            ServiceHandler serviceHandler = this.handlerHub.getServiceHandler();
            builder.addToServiceItems(this.toArray(serviceHandler.getServices(serviceConfig, annotations)));
        }
    }

    private Service[] toArray(List<Service> services) {
        if (services == null) {
            return new Service[0];
        }
        if (services instanceof ArrayList) {
            return ((ArrayList)services).toArray(new Service[services.size()]);
        }
        Service[] ret = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ret[i] = services.get(i);
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.resourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }
}

