/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.maven.core.config.ResourceConfiguration;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.maven.project.MavenProject;

public class DefaultReplicaSetEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig"};
    private final DeploymentHandler deployHandler;
    private final ReplicationControllerHandler rcHandler;
    private final ReplicaSetHandler rsHandler;

    public DefaultReplicaSetEnricher(EnricherContext buildContext) {
        super(buildContext, "default.deployment");
        HandlerHub handlers = new HandlerHub(buildContext.getProject());
        this.rcHandler = handlers.getReplicationControllerHandler();
        this.rsHandler = handlers.getReplicaSetHandler();
        this.deployHandler = handlers.getDeploymentHandler();
    }

    public void addDefaultResources(KubernetesListBuilder builder) {
        final String defaultName = this.getConfig(Config.name, MavenUtil.createDefaultResourceName((MavenProject)this.getProject(), (String[])new String[0]));
        ResourceConfiguration config = new ResourceConfiguration.Builder().replicaSetName(defaultName).imagePullPolicy(this.getConfig(Config.imagePullPolicy)).build();
        Deployment defaultDeployment = this.deployHandler.getDeployment(config, this.getImages());
        if (this.hasPodControllers(builder)) {
            PodSpec podSpec;
            PodTemplateSpec template;
            DeploymentSpec spec = defaultDeployment.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null && (podSpec = template.getSpec()) != null) {
                builder.accept((Visitor)new Visitor<PodSpecBuilder>(){

                    public void visit(PodSpecBuilder builder) {
                        DefaultReplicaSetEnricher.this.mergePodSpec(builder, podSpec, defaultName);
                    }
                });
            }
        } else if (Configs.asBoolean((String)this.getConfig(Config.deployment))) {
            this.log.info("Adding a default Deployment");
            builder.addToDeploymentItems(new Deployment[]{defaultDeployment});
        } else if (Configs.asBoolean((String)this.getConfig(Config.replicaSet))) {
            this.log.info("Adding a default ReplicaSet");
            builder.addToReplicaSetItems(new ReplicaSet[]{this.rsHandler.getReplicaSet(config, this.getImages())});
        } else {
            this.log.info("Adding a default ReplicationController");
            builder.addToReplicationControllerItems(new ReplicationController[]{this.rcHandler.getReplicationController(config, this.getImages())});
        }
    }

    private void mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec, String defaultName) {
        List containers = builder.getContainers();
        List defaultContainers = defaultPodSpec.getContainers();
        int size = defaultContainers.size();
        if (size > 0) {
            if (containers == null || containers.isEmpty()) {
                builder.addToContainers(defaultContainers.toArray(new Container[size]));
            } else {
                int idx = 0;
                for (Container defaultContainer : defaultContainers) {
                    List defaultEnv;
                    Container container;
                    if (idx < containers.size()) {
                        container = (Container)containers.get(idx);
                    } else {
                        container = new Container();
                        containers.add(container);
                    }
                    if (Strings.isNullOrBlank((String)container.getImagePullPolicy())) {
                        container.setImagePullPolicy(defaultContainer.getImagePullPolicy());
                    }
                    if (Strings.isNullOrBlank((String)container.getImage())) {
                        container.setImage(defaultContainer.getImage());
                    }
                    if (Strings.isNullOrBlank((String)container.getName())) {
                        container.setName(defaultContainer.getName());
                    }
                    if ((defaultEnv = defaultContainer.getEnv()) != null) {
                        for (EnvVar envVar : defaultEnv) {
                            this.ensureHasEnv(container, envVar);
                        }
                    }
                    ++idx;
                }
                builder.withContainers(containers);
            }
        } else if (!containers.isEmpty()) {
            Container container = (Container)containers.get(0);
            if (Strings.isNullOrBlank((String)container.getName())) {
                container.setName(defaultName);
            }
            builder.withContainers(containers);
        }
    }

    private void ensureHasEnv(Container container, EnvVar envVar) {
        ArrayList<EnvVar> envVars = container.getEnv();
        if (envVars == null) {
            envVars = new ArrayList<EnvVar>();
            container.setEnv(envVars);
        }
        for (EnvVar var : envVars) {
            if (!Objects.equals(var.getName(), envVar.getName())) continue;
            return;
        }
        envVars.add(envVar);
    }

    private boolean hasPodControllers(KubernetesListBuilder builder) {
        return this.checkForKind(builder, POD_CONTROLLER_KINDS);
    }

    private boolean checkForKind(KubernetesListBuilder builder, String ... kinds) {
        HashSet<String> kindSet = new HashSet<String>(Arrays.asList(kinds));
        for (HasMetadata item : builder.getItems()) {
            if (!kindSet.contains(item.getKind())) continue;
            return true;
        }
        return false;
    }

    private static enum Config implements Configs.Key
    {
        name,
        imagePullPolicy{
            {
                ((Config)this).d = "IfNotPresent";
            }
        }
        ,
        deployment{
            {
                ((Config)this).d = "true";
            }
        }
        ,
        replicaSet{
            {
                ((Config)this).d = "true";
            }
        };

        private String d;

        public String def() {
            return this.d;
        }
    }
}

