/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.BuildRecreateMode;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.ClientBuildConfigResource;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildMojo
extends io.fabric8.maven.docker.BuildMojo {
    @Parameter
    private ProcessorConfig generator;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ResourceConfig resources;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.skip.build.pom", defaultValue="true")
    private boolean skipBuildPom;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = KubernetesResourceUtil.defaultPlatformMode;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.build.recreate", defaultValue="none")
    private String buildRecreate;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    private ClusterAccess clusterAccess;
    private PlatformMode platformMode;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        this.clusterAccess = new ClusterAccess(this.namespace);
        this.platformMode = KubernetesResourceUtil.resolvePlatformMode((PlatformMode)this.mode, (ClusterAccess)this.clusterAccess, (Logger)this.log);
        if (this.project != null && this.skipBuildPom && Objects.equals("pom", this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Disabling docker build for pom packaging");
            return;
        }
        super.executeInternal(hub);
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        block4: {
            try {
                if (this.platformMode == PlatformMode.kubernetes) {
                    super.buildAndTag(hub, imageConfig);
                    break block4;
                }
                if (this.platformMode == PlatformMode.openshift) {
                    this.executeOpenShiftBuild(hub, imageConfig);
                    break block4;
                }
                throw new MojoExecutionException("Unknown platform mode " + this.mode + " for image " + imageConfig.getDescription());
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O Error executing build for image " + imageConfig.getDescription() + ":" + e, (Exception)e);
            }
        }
    }

    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
        return GeneratorManager.generate(configs, this.extractGeneratorConfig(), this.project, this.log, this.platformMode, this.buildStrategy);
    }

    protected String getLogPrefix() {
        return "F8> ";
    }

    private ProcessorConfig extractGeneratorConfig() {
        try {
            return ProfileUtil.extractProcesssorConfiguration((ProcessorConfig)this.generator, (ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract generator config: " + e, e);
        }
    }

    private void executeOpenShiftBuild(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, IOException {
        MojoParameters params = this.createMojoParameters();
        ImageName imageName = new ImageName(imageConfig.getName());
        File dockerTar = hub.getArchiveService().createDockerBuildArchive(imageConfig, params);
        OpenShiftClient client = this.getOpenShiftClient();
        KubernetesListBuilder builder = new KubernetesListBuilder();
        String buildName = this.checkOrCreateBuildConfig(client, builder, imageConfig);
        this.checkOrCreateImageStream(client, builder, this.getImageStreamName(imageName));
        this.applyResourceObjects(client, builder);
        this.startBuild(dockerTar, client, buildName);
    }

    private String getBuildName(ImageName imageName) {
        return imageName.getSimpleName();
    }

    private String getImageStreamName(ImageName name) {
        return name.getSimpleName();
    }

    private OpenShiftClient getOpenShiftClient() throws MojoExecutionException {
        OpenShiftClient client = this.clusterAccess.createOpenShiftClient();
        if (!KubernetesHelper.isOpenShift((KubernetesClient)client)) {
            throw new MojoExecutionException("Cannot create OpenShift Docker build with a non-OpenShift cluster at " + client.getMasterUrl());
        }
        return client;
    }

    private void startBuild(File dockerTar, OpenShiftClient client, String buildName) {
        this.log.info("Starting Build %s", new Object[]{buildName});
        ((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).instantiateBinary().fromFile(dockerTar);
    }

    private void applyResourceObjects(OpenShiftClient client, KubernetesListBuilder builder) throws IOException {
        if (builder.getItems().size() > 0) {
            this.enrich(builder);
            KubernetesList k8sList = builder.build();
            client.lists().create((Object[])new KubernetesList[]{k8sList});
        }
    }

    private void enrich(KubernetesListBuilder builder) throws IOException {
        ProcessorConfig resolvedEnricherConfig = ProfileUtil.extractProcesssorConfiguration((ProcessorConfig)this.enricher, (ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir);
        EnricherContext enricherContext = new EnricherContext(this.project, resolvedEnricherConfig, this.getResolvedImages(), this.resources, this.log);
        EnricherManager enricherManager = new EnricherManager(enricherContext);
        enricherManager.enrich(builder);
    }

    private void checkOrCreateImageStream(OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((ClientResource)client.imageStreams().withName(imageStreamName)).get() != null;
        if (hasImageStream && this.getBuildRecreateMode().isImageStream()) {
            ((ClientResource)client.imageStreams().withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            ((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.MetadataNested)builder.addNewImageStreamItem().withNewMetadata().withName(imageStreamName)).endMetadata()).endImageStreamItem();
        } else {
            this.log.info("Using ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private BuildRecreateMode getBuildRecreateMode() {
        return BuildRecreateMode.fromParameter((String)this.buildRecreate);
    }

    private String checkOrCreateBuildConfig(OpenShiftClient client, KubernetesListBuilder builder, ImageConfiguration imageConfig) {
        ImageName imageName = new ImageName(imageConfig.getName());
        String buildName = this.getBuildName(imageName);
        String imageStreamName = this.getImageStreamName(imageName);
        BuildConfig buildConfig = (BuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).get();
        if (buildConfig != null) {
            if (!this.getBuildRecreateMode().isBuildConfig()) {
                String type = buildConfig.getSpec().getStrategy().getType();
                if (!this.buildStrategy.isSame(type)) {
                    ((DoneableBuildConfig)((BuildConfigFluent.SpecNested)((DoneableBuildConfig)((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).edit()).editSpec().withStrategy(this.createBuildStrategy(imageConfig))).endSpec()).done();
                    this.log.info("Editing BuildConfig %s for %s build", new Object[]{buildName, this.getStrategyLabel()});
                } else {
                    this.log.info("Using BuildConfig %s for %s build", new Object[]{buildName, this.getStrategyLabel()});
                }
                return buildName;
            }
            ((ClientBuildConfigResource)client.buildConfigs().withName(buildName)).delete();
        }
        this.log.info("Creating BuildConfig %s for %s build", new Object[]{buildName, this.getStrategyLabel()});
        ((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.MetadataNested)builder.addNewBuildConfigItem().withNewMetadata().withName(buildName)).endMetadata()).withNewSpec().withStrategy(this.createBuildStrategy(imageConfig))).withNewSource().withType("Binary")).endSource()).withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(imageStreamName + ":" + imageName.getTag())).endTo()).endOutput()).endSpec()).endBuildConfigItem();
        return buildName;
    }

    private String getStrategyLabel() {
        return this.buildStrategy == OpenShiftBuildStrategy.s2i ? "S2I" : "Docker";
    }

    private BuildStrategy createBuildStrategy(ImageConfiguration imageConfig) {
        if (this.buildStrategy == OpenShiftBuildStrategy.docker) {
            return ((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Docker")).build();
        }
        if (this.buildStrategy == OpenShiftBuildStrategy.s2i) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            String fromImage = buildConfig.getFrom();
            return ((BuildStrategyBuilder)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Source")).withNewSourceStrategy().withNewFrom().withKind("DockerImage")).withName(fromImage)).endFrom()).endSourceStrategy()).build();
        }
        throw new IllegalArgumentException("Unsupported BuildStrategy " + this.buildStrategy);
    }
}

