/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.ServiceConfig;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ProfileUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.converter.DeploymentOpenShiftConverter;
import io.fabric8.maven.plugin.converter.KubernetesToOpenShiftConverter;
import io.fabric8.maven.plugin.converter.ReplicSetOpenShiftConverter;
import io.fabric8.maven.plugin.enricher.EnricherManager;
import io.fabric8.maven.plugin.generator.GeneratorManager;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractFabric8Mojo {
    private static final String DOCKER_MAVEN_PLUGIN_KEY = "io.fabric8:docker-maven-plugin";
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private ImageConfigResolver imageConfigResolver;
    @Component
    private GoalFinder goalFinder;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Parameter(property="fabric8.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/fabric8")
    private File targetDir;
    @Parameter(property="fabric8.workDir", defaultValue="${project.build.directory}/fabric8")
    private File workDir;
    @Parameter(property="fabric8.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private ResourceConfig resources;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter(property="fabric8.mode")
    private PlatformMode mode = KubernetesResourceUtil.defaultPlatformMode;
    @Parameter(property="fabric8.build.strategy")
    private OpenShiftBuildStrategy buildStrategy = OpenShiftBuildStrategy.s2i;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ProcessorConfig generator;
    @Component
    private MavenProjectHelper projectHelper;
    private boolean useReplicaSet = true;
    private List<ImageConfiguration> resolvedImages;
    private HandlerHub handlerHub;
    private Map<String, KubernetesToOpenShiftConverter> openShiftConverters;
    @Parameter(property="fabric8.namespace")
    private String namespace;
    private ClusterAccess clusterAccess;
    private PlatformMode platformMode;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        try {
            this.clusterAccess = new ClusterAccess(this.namespace);
            this.platformMode = KubernetesResourceUtil.resolvePlatformMode((PlatformMode)this.mode, (ClusterAccess)this.clusterAccess, (Logger)this.log);
            this.openShiftConverters = new HashMap<String, KubernetesToOpenShiftConverter>();
            this.openShiftConverters.put("ReplicaSet", new ReplicSetOpenShiftConverter());
            this.openShiftConverters.put("Deployment", new DeploymentOpenShiftConverter(this.platformMode));
            this.handlerHub = new HandlerHub(this.project);
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            EnricherContext ctx = new EnricherContext(this.project, this.extractEnricherConfig(), this.resolvedImages, this.resources, this.log);
            EnricherManager enricherManager = new EnricherManager(ctx);
            if (!(this.skip || this.isPomProject() && !this.hasFabric8Dir())) {
                KubernetesList kubernetesResources = this.generateKubernetesResources(enricherManager, this.resolvedImages);
                this.writeResources(kubernetesResources, ResourceClassifier.KUBERNETES);
                KubernetesList openShiftResources = this.convertToOpenShiftResources(kubernetesResources);
                this.writeResources(openShiftResources, ResourceClassifier.OPENSHIFT);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate fabric8 descriptor", (Exception)e);
        }
    }

    private KubernetesList generateKubernetesResources(EnricherManager enricherManager, List<ImageConfiguration> images) throws IOException, MojoExecutionException {
        KubernetesListBuilder builder;
        File[] resourceFiles = KubernetesResourceUtil.listResourceFragments((File)this.resourceDir);
        if (resourceFiles != null && resourceFiles.length > 0) {
            this.log.info("Using resource templates from %s", new Object[]{this.resourceDir});
            builder = KubernetesResourceUtil.readResourceFragmentsFrom((String)"v1", (String)"extensions/v1beta1", (File[])this.filterFiles(resourceFiles));
        } else {
            builder = new KubernetesListBuilder();
        }
        if (this.resources != null) {
            this.addConfiguredResources(builder, images);
        }
        enricherManager.createDefaultResources(builder);
        enricherManager.enrich(builder);
        return builder.build();
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.extractProcesssorConfiguration((ProcessorConfig)this.enricher, (ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, (File)this.resourceDir);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.extractProcesssorConfiguration((ProcessorConfig)this.generator, (ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, (File)this.resourceDir);
    }

    private void writeResources(KubernetesList resources, ResourceClassifier classifier) throws IOException {
        File resourceFileBase = new File(this.targetDir, classifier.getValue());
        File file = KubernetesResourceUtil.writeResource((Object)resources, (File)resourceFileBase, (ResourceFileType)this.resourceFileType);
        this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), classifier.getValue(), file);
        if (this.resourceFileType.equals((Object)ResourceFileType.yaml)) {
            file = KubernetesResourceUtil.writeResource((Object)resources, (File)resourceFileBase, (ResourceFileType)ResourceFileType.json);
            this.projectHelper.attachArtifact(this.project, ResourceFileType.yaml.getArtifactType(), classifier.getValue(), file);
        }
        this.writeIndividualResources(resources, resourceFileBase);
    }

    private void writeIndividualResources(KubernetesList resources, File targetDir) throws IOException {
        for (HasMetadata item : resources.getItems()) {
            String name = KubernetesHelper.getName((HasMetadata)item);
            if (Strings.isNullOrBlank((String)name)) {
                this.log.error("No name for generated item " + item, new Object[0]);
                continue;
            }
            String itemFile = KubernetesResourceUtil.getNameWithSuffix((String)name, (String)item.getKind());
            File itemTarget = new File(targetDir, itemFile);
            KubernetesResourceUtil.writeResource((Object)item, (File)itemTarget, (ResourceFileType)this.resourceFileType);
        }
    }

    private KubernetesList convertToOpenShiftResources(KubernetesList resources) {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        builder.withMetadata(resources.getMetadata());
        List items = resources.getItems();
        if (items != null) {
            for (HasMetadata item : items) {
                builder.addToItems(new HasMetadata[]{this.convertKubernetesItemToOpenShift(item)});
            }
        }
        return builder.build();
    }

    private HasMetadata convertKubernetesItemToOpenShift(HasMetadata item) {
        KubernetesToOpenShiftConverter converter = this.openShiftConverters.get(item.getKind());
        return converter != null ? converter.convert(item) : item;
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, final Logger log) throws MojoExecutionException {
        final Properties resolveProperties = this.project.getProperties();
        List ret = ConfigHelper.resolveImages(images, (ConfigHelper.Resolver)new ConfigHelper.Resolver(){

            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return ResourceMojo.this.imageConfigResolver.resolve(image, resolveProperties);
            }
        }, null, (ConfigHelper.Customizer)new ConfigHelper.Customizer(){

            public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> configs) {
                try {
                    return GeneratorManager.generate(configs, ResourceMojo.this.extractGeneratorConfig(), ResourceMojo.this.project, log, ResourceMojo.this.mode, ResourceMojo.this.buildStrategy);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot extract generator: " + e, e);
                }
            }
        });
        Date now = this.getBuildReferenceDate();
        this.storeReferenceDateInPluginContext(now);
        String minimalApiVersion = ConfigHelper.initAndValidate((List)ret, null, (ConfigHelper.NameFormatter)new ImageNameFormatter(this.project, now), (Logger)log);
        return ret;
    }

    private void storeReferenceDateInPluginContext(Date now) {
        Map pluginContext = this.getPluginContext();
        pluginContext.put("CONTEXT_KEY_BUILD_TIMESTAMP", now);
    }

    private Date getBuildReferenceDate() throws MojoExecutionException {
        if (this.goalFinder.runningWithGoal(this.project, this.session, "fabric8:build")) {
            return new Date();
        }
        File tsFile = new File(this.project.getBuild().getDirectory(), "docker/build.timestamp");
        if (!tsFile.exists()) {
            return new Date();
        }
        try {
            return EnvUtil.loadTimestamp((File)tsFile);
        }
        catch (MojoExecutionException e) {
            throw new MojoExecutionException("Cannot read timestamp from " + tsFile, (Exception)((Object)e));
        }
    }

    private void addConfiguredResources(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        this.log.info("Adding resources from plugin configuration", new Object[0]);
        this.addServices(builder, this.resources.getServices());
        this.addController(builder, images);
    }

    private void addController(KubernetesListBuilder builder, List<ImageConfiguration> images) {
        ReplicationControllerHandler rcHandler = this.handlerHub.getReplicationControllerHandler();
        if (this.resources.getReplicaSetName() != null) {
            builder.addToReplicationControllerItems(new ReplicationController[]{rcHandler.getReplicationController(this.resources, images)});
        }
    }

    private File[] filterFiles(File[] resourceFiles) throws MojoExecutionException {
        if (!this.workDir.exists() && !this.workDir.mkdirs()) {
            throw new MojoExecutionException("Cannot create working dir " + this.workDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(this.workDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new MojoExecutionException(String.format("Cannot filter %s to %s", resource, targetFile), (Exception)((Object)exp));
            }
        }
        return ret;
    }

    private void addServices(KubernetesListBuilder builder, List<ServiceConfig> serviceConfig) {
        if (serviceConfig != null) {
            ServiceHandler serviceHandler = this.handlerHub.getServiceHandler();
            builder.addToServiceItems(this.toArray(serviceHandler.getServices(serviceConfig)));
        }
    }

    private Service[] toArray(List<Service> services) {
        if (services == null) {
            return new Service[0];
        }
        if (services instanceof ArrayList) {
            return ((ArrayList)services).toArray(new Service[services.size()]);
        }
        Service[] ret = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ret[i] = services.get(i);
        }
        return ret;
    }

    private boolean hasFabric8Dir() {
        return this.resourceDir.isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }
}

