/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.maven.core.config.HelmConfig;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;

@Mojo(name="helm", defaultPhase=LifecyclePhase.PACKAGE)
public class HelmMojo
extends AbstractFabric8Mojo {
    @Parameter
    private HelmConfig helm;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="tar")
    private TarArchiver archiver;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        String chartName = this.getChartName();
        for (HelmConfig.HelmType type : this.getHelmTypes()) {
            this.generateHelmChartDirectory(chartName, type);
        }
    }

    protected void generateHelmChartDirectory(String chartName, HelmConfig.HelmType type) throws MojoExecutionException {
        File outputDir = this.prepareOutputDir(type);
        File sourceDir = this.checkSourceDir(chartName, type);
        if (sourceDir == null) {
            return;
        }
        this.log.info("Creating Helm Chart \"%s\" for %s", new Object[]{chartName, type.getDescription()});
        this.log.verbose("SourceDir: %s", new Object[]{sourceDir});
        this.log.verbose("OutputDir: %s", new Object[]{outputDir});
        this.copyResourceFilesToTemplatesDir(outputDir, sourceDir);
        this.createChartYaml(chartName, outputDir);
        this.copyTextFile(outputDir, "README");
        this.copyTextFile(outputDir, "LICENSE");
        File destinationFile = new File(this.project.getBuild().getDirectory(), chartName + "-" + this.project.getVersion() + "-" + type.getClassifier() + ".tar.gz");
        MavenUtil.createArchive((File)outputDir, (File)destinationFile, (TarArchiver)this.archiver);
        this.projectHelper.attachArtifact(this.project, "tar.gz", type.getClassifier(), destinationFile);
    }

    private String getChartName() {
        String ret = this.getProperty("fabric8.helm.chart");
        if (ret == null) {
            ret = this.helm != null ? this.helm.getChart() : null;
        }
        return ret != null ? ret : this.project.getArtifactId();
    }

    private File prepareOutputDir(HelmConfig.HelmType type) {
        File dirF;
        String dir = this.getProperty("fabric8.helm.outputDir");
        if (dir == null) {
            dir = this.project.getBuild().getDirectory() + "/fabric8/helm/" + type.getClassifier();
        }
        if (Files.isDirectory((File)(dirF = new File(dir)))) {
            Files.recursiveDelete((File)dirF);
        }
        return dirF;
    }

    private File checkSourceDir(String chartName, HelmConfig.HelmType type) {
        File dirF;
        String dir = this.getProperty("fabric8.helm.sourceDir");
        if (dir == null) {
            dir = this.project.getBuild().getOutputDirectory() + "/META-INF/fabric8/" + type.getSourceDir();
        }
        if (!(dirF = new File(dir)).isDirectory() || !dirF.exists()) {
            this.log.warn("Chart source directory %s does not exist so cannot make chart %s. Probably you need run 'mvn fabric8:resource' before.", new Object[]{dirF, chartName});
            return null;
        }
        if (!this.containsYamlFiles(dirF)) {
            this.log.warn("Chart source directory %s does not contain any YAML manifest to make chart %s. Probably you need run 'mvn fabric8:resource' before.", new Object[]{dirF, chartName});
            return null;
        }
        return dirF;
    }

    private List<HelmConfig.HelmType> getHelmTypes() {
        List types;
        String helmTypeProp = this.getProperty("fabric8.helm.type");
        if (!Strings.isNullOrBlank((String)helmTypeProp)) {
            List propTypes = Strings.splitAsList((String)helmTypeProp, (String)",");
            ArrayList<HelmConfig.HelmType> ret = new ArrayList<HelmConfig.HelmType>();
            for (String prop : propTypes) {
                ret.add(HelmConfig.HelmType.valueOf((String)prop.trim().toLowerCase()));
            }
            return ret;
        }
        if (this.helm != null && (types = this.helm.getType()) != null && types.size() > 0) {
            return types;
        }
        return Arrays.asList(HelmConfig.HelmType.kubernetes);
    }

    private void createChartYaml(String chartName, File outputDir) throws MojoExecutionException {
        Chart chart = this.helm != null ? new Chart(chartName, this.project, this.helm.getKeywords(), this.helm.getEngine()) : new Chart(chartName, this.project);
        File outputChartFile = new File(outputDir, "Chart.yaml");
        try {
            KubernetesHelper.saveYaml((Object)chart, (File)outputChartFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save chart " + outputChartFile + ": " + e, (Exception)e);
        }
    }

    private void copyResourceFilesToTemplatesDir(File outputDir, File sourceDir) throws MojoExecutionException {
        File templatesDir = new File(outputDir, "templates");
        templatesDir.mkdirs();
        try {
            Files.copy((File)sourceDir, (File)templatesDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy manifest files from " + sourceDir + " to chart templates directory: " + templatesDir + ": " + e, (Exception)e);
        }
    }

    private boolean containsYamlFiles(File sourceDir) {
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String lower = file.getName().toLowerCase();
                if (!lower.endsWith(".yaml") && !lower.endsWith(".yml")) continue;
                return true;
            }
        }
        return false;
    }

    private void copyTextFile(File outputDir, final String srcFile) throws MojoExecutionException {
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lower = name.toLowerCase(Locale.ENGLISH);
                    return lower.equals(srcFile.toLowerCase()) || lower.startsWith(srcFile.toLowerCase() + ".");
                }
            };
            this.copyFirstFile(this.project.getBasedir(), filter, new File(outputDir, srcFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to save " + srcFile + ": " + e, (Exception)e);
        }
    }

    protected void copyFirstFile(File sourceDir, FilenameFilter filter, File outFile) throws IOException {
        File[] files = sourceDir.listFiles(filter);
        if (files != null && files.length > 0) {
            File sourceFile = files[0];
            Files.copy((File)sourceFile, (File)outFile);
        }
        if (files.length > 1) {
            this.log.warn("Found %d of %s files. Using first one %s", new Object[]{files.length, outFile, files[0]});
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Chart {
        @JsonProperty
        private String name;
        @JsonProperty
        private String home;
        @JsonProperty
        private List<String> sources;
        @JsonProperty
        private String version;
        @JsonProperty
        private String description;
        @JsonProperty
        private List<String> keywords;
        @JsonProperty
        private List<Maintainer> maintainers;
        @JsonProperty
        private String engine;

        public Chart(String name, MavenProject project) {
            this(name, project, null, null);
        }

        public Chart(String name, MavenProject project, List<String> keywords, String engine) {
            this.name = name;
            this.keywords = keywords;
            this.engine = engine;
            this.name = name;
            if (project != null) {
                List developers;
                String url;
                this.version = project.getVersion();
                this.description = project.getDescription();
                this.home = project.getUrl();
                this.keywords = keywords;
                this.engine = engine;
                Scm scm = project.getScm();
                if (scm != null && (url = scm.getUrl()) != null) {
                    ArrayList<String> sources1 = new ArrayList<String>();
                    sources1.add(url);
                    this.sources = sources1;
                }
                if ((developers = project.getDevelopers()) != null) {
                    ArrayList<Maintainer> maintainers1 = new ArrayList<Maintainer>();
                    for (Developer developer : developers) {
                        String email = developer.getEmail();
                        String devName = developer.getName();
                        if (!Strings.isNotBlank((String)devName) && !Strings.isNotBlank((String)email)) continue;
                        Maintainer maintainer = new Maintainer(devName, email);
                        maintainers1.add(maintainer);
                    }
                    this.maintainers = maintainers1;
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public static class Maintainer {
            @JsonProperty
            private String name;
            @JsonProperty
            private String email;

            public Maintainer() {
            }

            public Maintainer(String name, String email) {
                this.name = name;
                this.email = email;
            }
        }
    }
}

