/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.maven.plugin.AbstractFabric8Mojo;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Function;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractArtifactSearchMojo
extends AbstractFabric8Mojo {
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List<MavenArtifactRepository> remoteRepositories;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(property="fabric8.repository.index.mavenRepoUrl", defaultValue="http://central.maven.org/maven2/")
    protected String mavenRepoUrl;
    @Parameter(property="fabric8.repository.index.mavenRepoSearchUrl", defaultValue="http://search.maven.org/solrsearch/select")
    protected String mavenRepoSearchUrl;
    @Parameter(property="fabric8.repository.index.maxSearchResults", defaultValue="200000")
    protected int maxSearchResults;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repoSession;
    @Parameter(name="iconMappings")
    private List<Mapping> iconMappings;
    private Map<String, String> iconMappingsMap;

    protected static String findManifestAnnotation(Object manifest, final String annotation) {
        return AbstractArtifactSearchMojo.findManifestValue(manifest, new Function<HasMetadata, String>(){

            public String apply(HasMetadata hasMetadata) {
                Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)hasMetadata);
                String answer = (String)annotations.get(annotation);
                if (Strings.isNotBlank((String)answer)) {
                    return answer;
                }
                return null;
            }
        });
    }

    protected static String findManifestIcon(Object manifest) {
        return AbstractArtifactSearchMojo.findManifestAnnotation(manifest, "fabric8.io/iconUrl");
    }

    protected static <T> T findManifestValue(Object manifest, Function<HasMetadata, T> function) {
        HasMetadata metadata;
        Object answer;
        if (manifest instanceof HasMetadata && (answer = function.apply((Object)(metadata = (HasMetadata)manifest))) != null) {
            return (T)answer;
        }
        if (manifest instanceof KubernetesList) {
            KubernetesList list = (KubernetesList)manifest;
            return AbstractArtifactSearchMojo.findManifestValueFromList(list.getItems(), function);
        }
        if (manifest instanceof Template) {
            Template template = (Template)manifest;
            return AbstractArtifactSearchMojo.findManifestValueFromList(template.getObjects(), function);
        }
        return null;
    }

    private static <T> T findManifestValueFromList(List<HasMetadata> items, Function<HasMetadata, T> function) {
        if (items != null) {
            for (HasMetadata item : items) {
                T answer = AbstractArtifactSearchMojo.findManifestValue(item, function);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    public Map<String, String> getIconMappingsMap() {
        if (this.iconMappingsMap == null) {
            this.iconMappingsMap = new HashMap<String, String>();
            if (this.iconMappings != null) {
                for (Mapping mapping : this.iconMappings) {
                    this.iconMappingsMap.put(mapping.getKey(), mapping.getValue());
                }
            }
            this.getLog().debug((CharSequence)("Loaded icon mappings: " + this.iconMappingsMap));
        }
        return this.iconMappingsMap;
    }

    public String convertRelativeIcon(String icon) {
        if (Strings.isNotBlank((String)icon)) {
            String answer = this.getIconMappingsMap().get(icon);
            if (answer != null) {
                return answer;
            }
            if (icon.equals("data:image/svg+xml;charset=UTF-8;base64,")) {
                return null;
            }
            String prefix = "https://raw.githubusercontent.com/";
            if (icon.startsWith(prefix)) {
                return URLUtils.pathJoin((String[])new String[]{"https://cdn.rawgit.com/", icon.substring(prefix.length())});
            }
            if (icon.indexOf(58) < 0) {
                icon = URLUtils.pathJoin((String[])new String[]{"https://cdn.rawgit.com/fabric8io/fabric8-console/master/", icon});
            }
        }
        return icon;
    }

    protected List<ArtifactDTO> searchMaven(String query) throws MojoExecutionException {
        String urlText = this.mavenRepoSearchUrl + query + "&wt=json&rows=" + this.maxSearchResults;
        Result result = null;
        try {
            URL url = new URL(urlText);
            ObjectMapper mapper = new ObjectMapper();
            result = (Result)mapper.readerFor(Result.class).readValue(url);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not query " + urlText + " : " + e, (Exception)e);
        }
        if (result == null) {
            throw new MojoExecutionException("No result!");
        }
        Response response = result.getResponse();
        if (response == null) {
            throw new MojoExecutionException("No response!");
        }
        List<ArtifactDTO> artifacts = response.getDocs();
        if (artifacts == null) {
            throw new MojoExecutionException("No docs!");
        }
        return artifacts;
    }

    protected File resolveArtifactFile(ArtifactDTO artifactDTO, String classifier, String extension) {
        File file = null;
        try {
            ArtifactRequest artifactRequest = new ArtifactRequest();
            DefaultArtifact artifact = new DefaultArtifact(artifactDTO.getG(), artifactDTO.getA(), classifier, extension, artifactDTO.getV());
            artifactRequest.setArtifact((Artifact)artifact);
            ArrayList<RemoteRepository> aetherRepoList = new ArrayList<RemoteRepository>();
            for (MavenArtifactRepository remoteRepository : this.remoteRepositories) {
                RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepository.getId(), remoteRepository.getLayout().getId(), remoteRepository.getUrl());
                RemoteRepository aetherRepo = builder.build();
                aetherRepoList.add(aetherRepo);
            }
            artifactRequest.setRepositories(aetherRepoList);
            ArtifactResult artifactResult = this.artifactResolver.resolveArtifact(this.repoSession, artifactRequest);
            Artifact resolvedArtifact = artifactResult.getArtifact();
            if (resolvedArtifact == null) {
                this.getLog().warn((CharSequence)("Could not resolve artifact " + artifactDTO.description()));
                return null;
            }
            file = resolvedArtifact.getFile();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Failed to resolve manifest manifest for " + artifactDTO.description() + ". " + e), (Throwable)e);
            return null;
        }
        if (file == null) {
            this.getLog().warn((CharSequence)("Could not resolve artifact file for " + artifactDTO.description()));
            return null;
        }
        if (!file.isFile() || !file.exists()) {
            this.getLog().warn((CharSequence)("Resolved artifact file does not exist for " + artifactDTO.description()));
            return null;
        }
        return file;
    }

    protected Object loadKubernetesManifestFile(ArtifactDTO artifactDTO) {
        return this.loadManifestFile(artifactDTO, "kubernetes", "yml");
    }

    protected Object loadOpenShiftManifestFile(ArtifactDTO artifactDTO) {
        return this.loadManifestFile(artifactDTO, "openshift", "yml");
    }

    private Object loadManifestFile(ArtifactDTO artifactDTO, String classifier, String extension) {
        File file = this.resolveArtifactFile(artifactDTO, classifier, extension);
        if (file == null) {
            return null;
        }
        if (!file.isFile() || !file.exists()) {
            this.getLog().warn((CharSequence)("No YAML manifest exists at " + file));
            return null;
        }
        try {
            return KubernetesHelper.loadYaml((File)file);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to parse " + file + ". " + e), (Throwable)e);
            return null;
        }
    }

    public static class Mapping {
        private String key;
        private String value;

        public String toString() {
            return "Mapping{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ArtifactDTO {
        private String id;
        private String g;
        private String a;
        private String v;
        private String p;
        private List<String> ec;
        private List<String> tags;

        public String toString() {
            return "ArtifactDTO: " + this.g + ":" + this.a + ":" + this.v;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getG() {
            return this.g;
        }

        public void setG(String g) {
            this.g = g;
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public String getV() {
            return this.v;
        }

        public void setV(String v) {
            this.v = v;
        }

        public String getP() {
            return this.p;
        }

        public void setP(String p) {
            this.p = p;
        }

        public List<String> getEc() {
            return this.ec;
        }

        public void setEc(List<String> ec) {
            this.ec = ec;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public String description() {
            return "" + this.g + ":" + this.a + ":" + this.v;
        }

        public String createKey() {
            return this.getA() + "-" + this.getV();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Response {
        private List<ArtifactDTO> docs;

        public List<ArtifactDTO> getDocs() {
            return this.docs;
        }

        public void setDocs(List<ArtifactDTO> docs) {
            this.docs = docs;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Result {
        private Response response;

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }
    }
}

