/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.generator;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.generator.api.Generator;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class GeneratorManager {
    public static List<ImageConfiguration> generate(List<ImageConfiguration> imageConfigs, ProcessorConfig generatorConfig, MavenProject project, Logger log) {
        List ret = imageConfigs;
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)new MavenGeneratorContext(project, generatorConfig));
        List generators = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8/generator-default", "META-INF/fabric8/fabric8-generator-default", "META-INF/fabric8/generator", "META-INF/fabric8-generator"});
        generators = generatorConfig.order(generators, "generator");
        ArrayList<Generator> usableGenerators = new ArrayList<Generator>();
        log.verbose("Generators:", new Object[0]);
        for (Generator generator : generators) {
            if (!generatorConfig.use(generator.getName())) continue;
            log.verbose(" - %s", new Object[]{generator.getName()});
            usableGenerators.add(generator);
        }
        for (Generator generator : usableGenerators) {
            if (!generator.isApplicable()) continue;
            log.info("Running generator %s", new Object[]{generator.getName()});
            ret = generator.customize(ret);
        }
        return ret;
    }
}

