/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.maven.plugin.AbstractInstallMojo;
import io.fabric8.utils.Strings;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="cluster-start", requiresProject=false)
public class ClusterStartMojo
extends AbstractInstallMojo {
    @Parameter(property="fabric8.cluster.kind")
    private String clusterKind;
    @Parameter(property="fabric8.cluster.app", defaultValue="console")
    private String clusterApp;
    @Parameter(property="fabric8.cluster.cpus")
    private String clusterCPUs;
    @Parameter(property="fabric8.cluster.memory")
    private String clusterMemory;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        File gofabric8 = this.installBinaries();
        String arguments = " --batch";
        if (Strings.isNotBlank((String)this.clusterKind)) {
            String text = this.clusterKind.toLowerCase().trim();
            arguments = text.equals("minishift") || text.equals("openshift") ? arguments + " --minishift" : arguments + " --" + this.clusterKind;
        }
        if (Strings.isNotBlank((String)this.clusterApp)) {
            String appArg = this.clusterApp;
            if (this.clusterApp.equals("fabric8") || this.clusterApp.equals("platform")) {
                appArg = "cd-pipeline";
            }
            arguments = arguments + " --" + appArg;
        }
        if (Strings.isNotBlank((String)this.clusterCPUs)) {
            arguments = arguments + " --cpus " + this.clusterCPUs;
        }
        if (Strings.isNotBlank((String)this.clusterMemory)) {
            arguments = arguments + " --memory " + this.clusterMemory;
        }
        String message = "gofabric8 start" + arguments;
        this.log.info("running: " + message, new Object[0]);
        this.runCommand(gofabric8.getAbsolutePath() + " start" + arguments, message);
    }
}

