/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.AbstractDeployMojo;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="debug", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class DebugMojo
extends AbstractDeployMojo {
    public static final String ENV_VAR_JAVA_DEBUG = "JAVA_ENABLE_DEBUG";
    public static final String ENV_VAR_JAVA_DEBUG_PORT = "JAVA_DEBUG_PORT";
    public static final String ENV_VAR_JAVA_DEBUG_PORT_DEFAULT = "5005";
    @Parameter(property="fabric8.debug.port", defaultValue="5005")
    private String localDebugPort;
    private String remoteDebugPort = "5005";
    private Watch podWatcher;
    private CountDownLatch terminateLatch = new CountDownLatch(1);
    private Pod foundPod;

    @Override
    protected void applyEntities(Controller controller, KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        for (HasMetadata entity : entities) {
            DeploymentSpec spec;
            Deployment resource;
            String name = KubernetesHelper.getName((HasMetadata)entity);
            LabelSelector selector = null;
            if (entity instanceof Deployment) {
                resource = (Deployment)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((ClientScaleableResource)((ClientNonNamespaceOperation)kubernetes.extensions().deployments().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = this.getPodLabelSelector(entity);
                }
            } else if (entity instanceof ReplicaSet) {
                resource = (ReplicaSet)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((ClientRollableScallableResource)((ClientNonNamespaceOperation)kubernetes.extensions().replicaSets().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = this.getPodLabelSelector(entity);
                }
            } else if (entity instanceof ReplicationController) {
                resource = (ReplicationController)entity;
                spec = resource.getSpec();
                if (spec != null) {
                    if (this.enableDebugging(entity, spec.getTemplate())) {
                        ((ClientRollableScallableResource)((ClientNonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).replace((Object)resource);
                    }
                    selector = this.getPodLabelSelector(entity);
                }
            } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null) {
                if (this.enableDebugging(entity, spec.getTemplate())) {
                    OpenShiftClient openshiftClient = new Controller(kubernetes).getOpenShiftClientOrNull();
                    if (openshiftClient == null) {
                        this.log.warn("Ignoring DeploymentConfig " + name + " as not connected to an OpenShift cluster", new Object[0]);
                        continue;
                    }
                    ((ClientResource)((ClientNonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name)).replace((Object)resource);
                }
                selector = this.getPodLabelSelector(entity);
            }
            if (selector == null) continue;
            String podName = this.waitForRunningPodWithEnvVar(kubernetes, namespace, selector, ENV_VAR_JAVA_DEBUG, "true");
            this.portForward(controller, podName);
            break;
        }
    }

    private String waitForRunningPodWithEnvVar(KubernetesClient kubernetes, String namespace, LabelSelector selector, final String envVarName, final String envVarValue) throws MojoExecutionException {
        FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> pods = this.withSelector((ClientNonNamespaceOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>>)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)), selector);
        this.log.info("Waiting for debug pod with selector " + selector + " and $" + envVarName + " = " + envVarValue, new Object[0]);
        PodList list = (PodList)pods.list();
        if (list != null) {
            List items = list.getItems();
            Pod latestPod = this.getNewestPod(list.getItems());
            if (latestPod != null && this.podHasEnvVarValue(latestPod, envVarName, envVarValue)) {
                return KubernetesHelper.getName((HasMetadata)latestPod);
            }
        }
        this.podWatcher = (Watch)pods.watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                if (action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED) && KubernetesHelper.isPodRunning((Pod)pod) && DebugMojo.this.podHasEnvVarValue(pod, envVarName, envVarValue)) {
                    DebugMojo.this.foundPod = pod;
                    DebugMojo.this.terminateLatch.countDown();
                }
            }

            public void onClose(KubernetesClientException e) {
            }
        });
        while (this.terminateLatch.getCount() > 0L) {
            try {
                this.terminateLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.foundPod == null) continue;
            return KubernetesHelper.getName((HasMetadata)this.foundPod);
        }
        throw new MojoExecutionException("Could not find a running pod with $" + envVarName + " = " + envVarValue);
    }

    private boolean podHasEnvVarValue(Pod pod, String envVarName, String envVarValue) {
        Container container;
        List env;
        List containers;
        PodSpec spec = pod.getSpec();
        if (spec != null && (containers = spec.getContainers()) != null && !containers.isEmpty() && (env = (container = (Container)containers.get(0)).getEnv()) != null) {
            for (EnvVar envVar : env) {
                if (!Objects.equal((Object)envVar.getName(), (Object)envVarName) || !Objects.equal((Object)envVar.getValue(), (Object)envVarValue)) continue;
                return true;
            }
        }
        return false;
    }

    private void portForward(Controller controller, String podName) throws MojoExecutionException {
        String missingCommandMessage;
        OpenShiftClient openShiftClient = controller.getOpenShiftClientOrNull();
        String command = openShiftClient != null ? "oc" : "kubectl";
        File file = ProcessUtil.findExecutable((Logger)this.log, (String)command);
        if (file == null && command.equals("oc")) {
            file = ProcessUtil.findExecutable((Logger)this.log, (String)command);
            missingCommandMessage = "commands oc or kubectl";
        } else {
            missingCommandMessage = "command " + command;
        }
        if (file == null) {
            throw new MojoExecutionException("Could not find " + missingCommandMessage + ". Please try running `mvn fabric8:install` to install the necessary binaries and ensure they get added to your $PATH");
        }
        this.log.info("Port forwarding to port " + this.remoteDebugPort + " on pod " + podName + " using command: " + command, new Object[0]);
        String arguments = " port-forward " + podName + " " + this.localDebugPort + ":" + this.remoteDebugPort;
        String commands = command + arguments;
        this.log.info("Executing command: " + commands, new Object[0]);
        String message = "port forward";
        try {
            final Process process = Runtime.getRuntime().exec(file.getAbsolutePath() + arguments);
            Runtime.getRuntime().addShutdownHook(new Thread("mvn fabric8:run-interactive shutdown hook"){

                @Override
                public void run() {
                    if (process != null) {
                        DebugMojo.this.log.info("Terminating port forward process:", new Object[0]);
                        try {
                            process.destroy();
                        }
                        catch (Exception e) {
                            DebugMojo.this.log.error("Failed to terminate process port forward", new Object[0]);
                        }
                        try {
                            if (process != null && process.isAlive()) {
                                process.destroyForcibly();
                            }
                        }
                        catch (Exception e) {
                            DebugMojo.this.log.error("Failed to forcibly terminate process port forward", new Object[0]);
                        }
                    }
                }
            });
            this.log.info("", new Object[0]);
            this.log.info("Now you can start a Remote debug execution in your IDE by using localhost and the debug port " + this.localDebugPort, new Object[0]);
            this.log.info("", new Object[0]);
            ProcessUtil.processCommandAsync((Process)process, (Logger)this.createExternalProcessLogger(command + "> "), (String)commands, (String)"port forward");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute process " + commands + " for " + "port forward" + ": " + e, e);
        }
    }

    private boolean enableDebugging(HasMetadata entity, PodTemplateSpec template) {
        List containers;
        PodSpec podSpec;
        if (template != null && (podSpec = template.getSpec()) != null && (containers = podSpec.getContainers()).size() > 0) {
            Container container = (Container)containers.get(0);
            ArrayList<EnvVar> env = container.getEnv();
            if (env == null) {
                env = new ArrayList<EnvVar>();
            }
            this.remoteDebugPort = this.getEnvVar(env, ENV_VAR_JAVA_DEBUG_PORT, ENV_VAR_JAVA_DEBUG_PORT_DEFAULT);
            if (this.setEnvVar(env, ENV_VAR_JAVA_DEBUG, "true")) {
                container.setEnv(env);
                this.log.info("Enabling debug on " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
                return true;
            }
        }
        return false;
    }

    private boolean setEnvVar(List<EnvVar> envVarList, String name, String value) {
        for (EnvVar envVar : envVarList) {
            String envVarName = envVar.getName();
            if (!Objects.equal((Object)name, (Object)envVarName)) continue;
            String oldValue = envVar.getValue();
            if (Objects.equal((Object)value, (Object)oldValue)) {
                return false;
            }
            envVar.setValue(value);
            return true;
        }
        EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
        envVarList.add(env);
        return true;
    }

    private String getEnvVar(List<EnvVar> envVarList, String name, String defaultValue) {
        String answer = defaultValue;
        if (envVarList != null) {
            for (EnvVar envVar : envVarList) {
                String value;
                String envVarName = envVar.getName();
                if (!Objects.equal((Object)name, (Object)envVarName) || !Strings.isNotBlank((String)(value = envVar.getValue()))) continue;
                return value;
            }
        }
        return answer;
    }
}

