/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatusType;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.AbstractDeployMojo;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

public class AbstractTailLogMojo
extends AbstractDeployMojo {
    private Watch podWatcher;
    private LogWatch logWatcher;
    private Map<String, Pod> addedPods = new ConcurrentHashMap<String, Pod>();
    private CountDownLatch terminateLatch = new CountDownLatch(1);
    private String watchingPodName;
    private CountDownLatch logWatchTerminateLatch;

    protected void tailAppPodsLogs(final KubernetesClient kubernetes, final String namespace, final Set<HasMetadata> entities, boolean watchAddedPodsOnly, boolean deleteAppOnExit, boolean followLog, Date ignorePodsOlderThan) {
        HasMetadata entity;
        LabelSelector selector = null;
        Iterator<HasMetadata> iterator = entities.iterator();
        while (iterator.hasNext() && (selector = this.getPodLabelSelector(entity = iterator.next())) == null) {
        }
        if (selector != null) {
            if (deleteAppOnExit) {
                Runtime.getRuntime().addShutdownHook(new Thread("mvn fabric8:run-interactive shutdown hook"){

                    @Override
                    public void run() {
                        AbstractTailLogMojo.this.log.info("Undeploying the app:", new Object[0]);
                        AbstractTailLogMojo.this.deleteEntities(kubernetes, namespace, entities);
                        if (AbstractTailLogMojo.this.podWatcher != null) {
                            AbstractTailLogMojo.this.podWatcher.close();
                        }
                        AbstractTailLogMojo.this.closeLogWatcher();
                    }
                });
            }
            this.waitAndLogPods(kubernetes, namespace, selector, watchAddedPodsOnly, deleteAppOnExit, followLog, ignorePodsOlderThan);
        } else {
            this.log.warn("No selector in deployment so cannot watch pods!", new Object[0]);
        }
    }

    private void waitAndLogPods(final KubernetesClient kubernetes, final String namespace, LabelSelector selector, boolean watchAddedPodsOnly, final boolean deleteAppOnExit, final boolean followLog, Date ignorePodsOlderThan) {
        List items;
        FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> pods = this.withSelector((ClientNonNamespaceOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>>)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)), selector);
        this.log.info("Watching pods with selector " + selector + " waiting for a running pod...", new Object[0]);
        Pod latestPod = null;
        boolean runningPod = false;
        PodList list = (PodList)pods.list();
        if (list != null && (items = list.getItems()) != null) {
            block5: for (Pod pod : items) {
                PodStatusType status = KubernetesHelper.getPodStatus((Pod)pod);
                switch (status) {
                    case WAIT: 
                    case OK: {
                        if (latestPod == null || this.isNewerPod((HasMetadata)pod, (HasMetadata)latestPod)) {
                            if (ignorePodsOlderThan != null) {
                                Date podCreateTime = this.getCreationTimestamp((HasMetadata)pod);
                                if (podCreateTime != null && podCreateTime.compareTo(ignorePodsOlderThan) > 0) {
                                    latestPod = pod;
                                }
                            } else {
                                latestPod = pod;
                            }
                        }
                        runningPod = true;
                        continue block5;
                    }
                }
            }
        }
        if (latestPod != null) {
            this.onPod(Watcher.Action.ADDED, latestPod, kubernetes, namespace, deleteAppOnExit, followLog);
        }
        if (!watchAddedPodsOnly && !runningPod) {
            this.log.warn("No pod is running yet. Are you sure you deployed your app via `fabric8:deploy`?", new Object[0]);
            this.log.warn("Or did you stop it via `fabric8:stop`? If so try running the `fabric8:start` goal", new Object[0]);
        }
        this.podWatcher = (Watch)pods.watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                AbstractTailLogMojo.this.onPod(action, pod, kubernetes, namespace, deleteAppOnExit, followLog);
            }

            public void onClose(KubernetesClientException e) {
            }
        });
        while (this.terminateLatch.getCount() > 0L) {
            try {
                this.terminateLatch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void onPod(Watcher.Action action, Pod pod, KubernetesClient kubernetes, String namespace, boolean deleteAppOnExit, boolean followLog) {
        Pod watchPod;
        String name = KubernetesHelper.getName((HasMetadata)pod);
        if (!action.equals((Object)Watcher.Action.MODIFIED) || this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            this.log.info("" + action + " pod " + name + " status: " + KubernetesHelper.getPodStatusText((Pod)pod) + " " + this.getPodCondition(pod), new Object[0]);
        }
        if (action.equals((Object)Watcher.Action.DELETED)) {
            this.addedPods.remove(name);
            if (Objects.equals(this.watchingPodName, name)) {
                this.watchingPodName = null;
                this.addedPods.remove(name);
            }
        } else if (action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED)) {
            this.addedPods.put(name, pod);
        }
        if (!this.addedPods.isEmpty() && KubernetesHelper.isPodRunning((Pod)(watchPod = this.getNewestPod(this.addedPods.values())))) {
            this.watchLogOfPodName(kubernetes, namespace, deleteAppOnExit, followLog, KubernetesHelper.getName((HasMetadata)watchPod));
        }
    }

    private void watchLogOfPodName(KubernetesClient kubernetes, String namespace, boolean deleteAppOnExit, boolean followLog, String name) {
        if (this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            if (this.logWatcher != null) {
                this.log.info("Closing log watcher for " + this.watchingPodName + " as now watching " + name, new Object[0]);
                this.closeLogWatcher();
            }
            ClientPodResource podResource = (ClientPodResource)((ClientNonNamespaceOperation)kubernetes.pods().inNamespace(namespace)).withName(name);
            if (followLog || deleteAppOnExit) {
                this.watchingPodName = name;
                this.logWatchTerminateLatch = new CountDownLatch(1);
                this.logWatcher = (LogWatch)podResource.watchLog();
                this.watchLog(this.logWatcher, name, "Failed to read log of pod " + name + ".", deleteAppOnExit);
            } else {
                String logText = (String)podResource.getLog();
                if (logText != null) {
                    String[] lines = logText.split("\n");
                    Logger log = this.createPodLogger();
                    log.info("Log of pod: " + name, new Object[0]);
                    log.info("", new Object[0]);
                    for (String line : lines) {
                        log.info(line, new Object[0]);
                    }
                }
                this.terminateLatch.countDown();
            }
        }
    }

    private void closeLogWatcher() {
        if (this.logWatcher != null) {
            this.logWatcher.close();
            this.logWatcher = null;
        }
        if (this.logWatchTerminateLatch != null) {
            this.logWatchTerminateLatch.countDown();
        }
    }

    private void watchLog(LogWatch logWatcher, String podName, final String failureMessage, boolean deleteAppOnExit) {
        final InputStream in = logWatcher.getOutput();
        final Logger log = this.createPodLogger();
        log.info("Tailing log of pod: " + podName, new Object[0]);
        log.info("Press Ctrl-C to " + (deleteAppOnExit ? "undeploy the app" : "stop tailing the log"), new Object[0]);
        log.info("", new Object[0]);
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            log.info("Log closed", new Object[0]);
                            return;
                        }
                        if (AbstractTailLogMojo.this.logWatchTerminateLatch.getCount() <= 0L) {
                            return;
                        }
                        log.info(line, new Object[0]);
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    log.error(failureMessage + " " + e, new Object[]{e});
                    return;
                }
            }
        };
        thread.start();
    }

    private Logger createPodLogger() {
        return this.createExternalProcessLogger("Pod> ");
    }

    private String getPodCondition(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return "";
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return "";
        }
        for (PodCondition condition : conditions) {
            String statusText;
            String type = condition.getType();
            if (!Strings.isNotBlank((String)type) || !"ready".equalsIgnoreCase(type) || !Strings.isNotBlank((String)(statusText = condition.getStatus())) || !Boolean.parseBoolean(statusText)) continue;
            return type;
        }
        return "";
    }

    private boolean isNewerPod(HasMetadata newer, HasMetadata older) {
        Date t1 = this.getCreationTimestamp(newer);
        Date t2 = this.getCreationTimestamp(older);
        if (t1 != null) {
            return t2 == null || t1.compareTo(t2) > 0;
        }
        return false;
    }
}

