/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.fusesource.jansi.Ansi;

public abstract class AbstractFabric8Mojo
extends AbstractMojo {
    public static final Ansi.Color COLOR_POD_LOG = Ansi.Color.BLUE;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(property="fabric8.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="fabric8.verbose", defaultValue="false")
    protected boolean verbose;
    protected Logger log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.log = new AnsiLogger(this.getLog(), this.useColor, this.verbose, "F8> ");
        this.executeInternal();
    }

    public abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    protected String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.project.getProperties().getProperty(key);
        }
        return value;
    }

    protected Logger createExternalProcessLogger(String prefix) {
        if (this.useColor) {
            prefix = prefix + Ansi.ansi().fg(COLOR_POD_LOG);
        }
        return new AnsiLogger(this.getLog(), this.useColor, this.verbose, prefix);
    }

    protected void validateKubernetesMasterUrl(URL masterUrl) throws MojoFailureException {
        if (masterUrl == null || Strings.isNullOrBlank((String)masterUrl.toString())) {
            throw new MojoFailureException("Cannot find Kubernetes master URL. Have you started a cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`?");
        }
    }

    protected void handleKubernetesClientException(KubernetesClientException e) throws MojoExecutionException {
        Throwable cause = e.getCause();
        if (cause instanceof UnknownHostException) {
            this.log.error("Could not connect to kubernetes cluster!", new Object[0]);
            this.log.error("Have you started a local cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`?", new Object[0]);
            this.log.info("For more help see: http://fabric8.io/guide/getStarted/", new Object[0]);
            this.log.error("Connection error: " + cause, new Object[0]);
            String message = "Could not connect to kubernetes cluster. Have you started a cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`? Error: " + cause;
            throw new MojoExecutionException(message, (Exception)e);
        }
        throw new MojoExecutionException(e.getMessage(), (Exception)e);
    }

    protected OpenShiftClient getOpenShiftClientOrJenkinsShift(KubernetesClient kubernetes, String namespace) throws MojoExecutionException {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull(kubernetes);
        if (openShiftClient == null) {
            String jenkinshiftUrl = AbstractFabric8Mojo.getJenkinShiftUrl(kubernetes, namespace);
            this.log.debug("Using jenknshift URL: " + jenkinshiftUrl, new Object[0]);
            if (jenkinshiftUrl == null) {
                throw new MojoExecutionException("Could not find the service `jenkinshift` im namespace `" + namespace + "` on this kubernetes cluster " + kubernetes.getMasterUrl());
            }
            return KubernetesHelper.createJenkinshiftOpenShiftClient((String)jenkinshiftUrl);
        }
        if (openShiftClient == null) {
            throw new MojoExecutionException("Not connected to an OpenShift cluster and JenkinShift could not be found! Cluster: " + kubernetes.getMasterUrl());
        }
        return openShiftClient;
    }

    public static String getJenkinShiftUrl(KubernetesClient kubernetes, String namespace) {
        String fabric8ConsoleURL;
        String jenkinshiftUrl = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"jenkinshift", (String)namespace, (String)"http", (boolean)true);
        if (jenkinshiftUrl == null && Strings.isNotBlank((String)(fabric8ConsoleURL = AbstractFabric8Mojo.getFabric8ConsoleServiceUrl(kubernetes, namespace)))) {
            jenkinshiftUrl = URLUtils.pathJoin((String[])new String[]{fabric8ConsoleURL, "/k8s"});
        }
        return jenkinshiftUrl;
    }

    private static String getFabric8ConsoleServiceUrl(KubernetesClient kubernetes, String namespace) {
        return KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"fabric8", (String)namespace, (String)"http", (boolean)true);
    }

    protected OpenShiftClient getOpenShiftClientOrNull(KubernetesClient kubernetesClient) {
        try {
            return (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
        }
        catch (OpenShiftNotAvailableException openShiftNotAvailableException) {
            return null;
        }
    }
}

