/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.AbstractResourceMojo;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="app-catalog", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class AppCatalogMojo
extends AbstractResourceMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        String name;
        HashMap<String, String> annotations;
        HashMap<String, String> labels;
        ArrayList<void> openshiftResources = new ArrayList<void>();
        ArrayList<ConfigMap> kubernetesResources = new ArrayList<ConfigMap>();
        Map<URL, KubernetesResource> openshiftMap = this.loadYamlResourcesOnClassPath("META-INF/fabric8/openshift.yml");
        this.log.info("Found " + openshiftMap.size() + " openshift resources", new Object[0]);
        for (Map.Entry<URL, KubernetesResource> entry : openshiftMap.entrySet()) {
            void var8_16;
            URL url = entry.getKey();
            KubernetesResource kubernetesResource = entry.getValue();
            Object var8_13 = null;
            if (kubernetesResource instanceof Template) {
                Template template = (Template)kubernetesResource;
                this.log.debug("Found Template " + KubernetesHelper.getName((HasMetadata)template) + " with " + Lists.notNullList((List)template.getParameters()).size() + " parameters", new Object[0]);
            } else {
                HasMetadata hasMetadata;
                ObjectMeta metadata;
                TemplateBuilder builder = new TemplateBuilder();
                boolean foundMetadata = false;
                if (kubernetesResource instanceof HasMetadata && (metadata = (hasMetadata = (HasMetadata)kubernetesResource).getMetadata()) != null && Strings.isNotBlank((String)metadata.getName())) {
                    foundMetadata = true;
                    builder.withMetadata(metadata);
                }
                if (!foundMetadata) {
                    labels = new HashMap<String, String>();
                    annotations = new HashMap<String, String>();
                    name = this.extractNameFromURL(url, labels);
                    if (name.equals("META-INF")) {
                        this.log.debug("Ignoring local build dependency " + url, new Object[0]);
                        continue;
                    }
                    if (Strings.isNullOrBlank((String)name)) {
                        this.log.warn("Cannot generate a template name from URL: " + url, new Object[0]);
                        continue;
                    }
                    this.populateLabelsFromResources(kubernetesResource, name, labels, annotations);
                    ((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)builder.withNewMetadata().withName(name)).withLabels(labels)).withAnnotations(annotations)).endMetadata();
                }
                if (kubernetesResource instanceof KubernetesList) {
                    KubernetesList list = (KubernetesList)kubernetesResource;
                    List items = list.getItems();
                    if (items == null || items.isEmpty()) {
                        this.log.warn("Ignoring resource " + url + " as it contains a List which contains no items!", new Object[0]);
                        continue;
                    }
                    builder.withObjects(items);
                }
                Template template = builder.build();
            }
            if (var8_16 == null) continue;
            openshiftResources.add(var8_16);
        }
        HashMap<String, Template> kubernetesTemplates = new HashMap<String, Template>();
        Map<URL, KubernetesResource> kubernetesTemplateMap = this.loadYamlResourcesOnClassPath("META-INF/fabric8/" + ResourceClassifier.KUBERNETES_TEMPLATE.getValue() + ".yml");
        for (Map.Entry entry : kubernetesTemplateMap.entrySet()) {
            URL uRL = (URL)entry.getKey();
            KubernetesResource resource = (KubernetesResource)entry.getValue();
            if (!(resource instanceof Template)) continue;
            Template template = (Template)resource;
            String name2 = KubernetesHelper.getName((HasMetadata)template);
            if (Strings.isNullOrBlank((String)name2)) {
                this.log.warn("Ignoring Template from " + uRL + " as it has no name!", new Object[0]);
                continue;
            }
            if (kubernetesTemplates.containsKey(name2)) {
                this.log.warn("Found duplicate template named: " + name2 + " for url: " + uRL, new Object[0]);
            }
            kubernetesTemplates.put(name2, template);
        }
        Map<URL, KubernetesResource> kubernetesMap = this.loadYamlResourcesOnClassPath("META-INF/fabric8/kubernetes.yml");
        for (Map.Entry<URL, KubernetesResource> entry : kubernetesMap.entrySet()) {
            Template template;
            URL url = entry.getKey();
            KubernetesResource resource = entry.getValue();
            labels = new HashMap();
            annotations = new HashMap();
            name = this.extractNameFromURL(url, labels);
            if (name.equals("META-INF")) {
                this.log.debug("Ignoring local build dependency " + url, new Object[0]);
                continue;
            }
            if (Strings.isNullOrBlank((String)name)) {
                this.log.warn("Cannot generate a template name from URL: " + url, new Object[0]);
                continue;
            }
            if (kubernetesTemplates.containsKey(name)) {
                this.log.info("Ignoring duplicate template " + name + " from url: " + url, new Object[0]);
                continue;
            }
            this.populateLabelsFromResources(resource, name, labels, annotations);
            TemplateBuilder builder = new TemplateBuilder();
            ((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)builder.withNewMetadata().withName(name)).withLabels(labels)).withAnnotations(annotations)).endMetadata();
            if (resource instanceof KubernetesList) {
                KubernetesList list = (KubernetesList)resource;
                List items = list.getItems();
                if (items == null || items.isEmpty()) {
                    this.log.warn("Ignoring resource " + url + " as it contains a List which contains no items!", new Object[0]);
                    continue;
                }
                builder.withObjects(items);
            } else if (resource instanceof HasMetadata) {
                HasMetadata hasMetadata = (HasMetadata)resource;
                builder.withObjects(new HasMetadata[]{hasMetadata});
            }
            if ((template = builder.build()) == null) continue;
            kubernetesTemplates.put(name, template);
        }
        for (Map.Entry entry : kubernetesTemplates.entrySet()) {
            String name3 = (String)entry.getKey();
            Template template = (Template)entry.getValue();
            String templateYaml = null;
            try {
                templateYaml = KubernetesHelper.toYaml((Object)template);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to convert template " + name3 + " into YAML: " + e, (Exception)e);
            }
            String catalogName = "catalog-" + name3;
            LinkedHashMap<String, String> labels2 = new LinkedHashMap<String, String>(KubernetesHelper.getLabels((HasMetadata)template));
            Map annotations2 = KubernetesHelper.getOrCreateAnnotations((HasMetadata)template);
            labels2.put("kind", "catalog");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(catalogName + ".yml", templateYaml);
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(catalogName)).withLabels(labels2)).withAnnotations(annotations2)).endMetadata()).withData(data)).build();
            kubernetesResources.add(configMap);
        }
        if (openshiftResources.isEmpty()) {
            this.log.warn("No OpenShift resources generated", new Object[0]);
        } else {
            this.writeResources(((KubernetesListBuilder)new KubernetesListBuilder().withItems(openshiftResources)).build(), ResourceClassifier.OPENSHIFT);
        }
        if (kubernetesResources.isEmpty()) {
            this.log.warn("No Kubernetes resources generated", new Object[0]);
        } else {
            this.writeResources(((KubernetesListBuilder)new KubernetesListBuilder().withItems(kubernetesResources)).build(), ResourceClassifier.KUBERNETES);
        }
    }

    private String extractNameFromURL(URL url, Map<String, String> labels) {
        String[] parts;
        String text = url.toString();
        int idx = text.lastIndexOf(33);
        if (idx > 0) {
            text = text.substring(0, idx);
        }
        if ((parts = text.split("/")) != null && parts.length > 2) {
            String version = parts[parts.length - 2];
            String name = parts[parts.length - 3];
            labels.put("project", name);
            labels.put("version", version);
            return name;
        }
        return null;
    }

    private void populateLabelsFromResources(KubernetesResource resource, String name, Map<String, String> labels, Map<String, String> annotations) {
        KubernetesList list;
        List items;
        if (resource instanceof KubernetesList && (items = (list = (KubernetesList)resource).getItems()) != null) {
            AppCatalogMojo.defaultAnnotationsFromResources(annotations, items);
            for (HasMetadata item : items) {
                ObjectMeta metadata = item.getMetadata();
                Map itemLabels = metadata.getLabels();
                boolean updated = false;
                if (itemLabels == null || itemLabels.size() <= 0) continue;
                for (Map.Entry entry : itemLabels.entrySet()) {
                    String key = (String)entry.getKey();
                    if (labels.containsKey(key)) continue;
                    labels.put(key, (String)entry.getValue());
                    updated = true;
                }
                if (!updated) continue;
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<URL, KubernetesResource> loadYamlResourcesOnClassPath(String resourcePath) throws MojoExecutionException {
        List<URL> resourceList = this.findResourcesOnClassPath(resourcePath);
        HashMap<URL, KubernetesResource> resourceMap = new HashMap<URL, KubernetesResource>();
        Iterator<URL> iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                InputStream is;
                block18: {
                    is = url.openStream();
                    Throwable throwable = null;
                    try {
                        if (is != null) {
                            try {
                                KubernetesResource resource = (KubernetesResource)KubernetesHelper.loadYaml((InputStream)is, KubernetesResource.class);
                                resourceMap.put(url, resource);
                            }
                            catch (IOException e) {
                                this.log.warn("Ignoring resource " + url + " as it could not be parsed: " + e, new Object[]{e});
                                if (is == null) continue;
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    continue;
                                }
                                is.close();
                                continue;
                            }
                        }
                        if (is == null) continue;
                        if (throwable == null) break block18;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (is == null) throw throwable5;
                            if (throwable == null) {
                                is.close();
                                throw throwable5;
                            }
                            try {
                                is.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
            catch (IOException e) {
                this.log.warn("Ignoring resource " + url + " as it could not be opened: " + e, new Object[]{e});
            }
        }
        return resourceMap;
    }

    protected List<URL> findResourcesOnClassPath(String resourcePath) throws MojoExecutionException {
        try {
            URLClassLoader classLoader = ClassUtil.createProjectClassLoader((MavenProject)this.project, (Logger)this.log);
            ArrayList<URL> resourceList = new ArrayList<URL>();
            Enumeration<URL> resources = classLoader.getResources(resourcePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (url == null) continue;
                resourceList.add(url);
            }
            return resourceList;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to find " + resourcePath + " on the compile classpath: " + e, (Exception)e);
        }
    }
}

